// C Source File
// Created 29.06.2008; 14:41:33

#include "standart.h"
#include "fileio.h"
#include "game.h"

DEFINE_INT_HANDLER (CLOCK_TIMER) {
	if(clock.running) {
		if(!clock.counter--) {
			clock.counter = 19;
			if(++clock.seconds >= 60) {
				clock.seconds = 0;
				++clock.minutes;
			}
			clock.updated = 1;
		}
	}
};


#define STATUS_MESSAGE_NR 6
const char *status_message[STATUS_MESSAGE_NR] = {
	COMMENT_PROGRAM_NAME " " COMMENT_VERSION_STRING " by " COMMENT_AUTHORS,
	"Thanks for playing " COMMENT_PROGRAM_NAME,
	"Send feedback to boscop@boolsoft.org",
	"By Boscop, member of BoolSoft",
	"See you later, alligator ;-)",
	"Bye bye...",
};


//	redirect AUTO_INT_1 and AUTO_INT_5
inline void saveAutoInts(INT_HANDLER *saveInt1, INT_HANDLER *saveInt5) { 
	*saveInt1 = GetIntVec(AUTO_INT_1);
	*saveInt5 = GetIntVec(AUTO_INT_5);
	
	SetIntVec(AUTO_INT_1, DUMMY_HANDLER);
	SetIntVec(AUTO_INT_5, CLOCK_TIMER /*DUMMY_HANDLER*/);
} 

//	restore AUTO_INT_1 and AUTO_INT_5
inline void restoreAutoInts(INT_HANDLER saveInt1, INT_HANDLER saveInt5) {
	SetIntVec(AUTO_INT_1, saveInt1);
	SetIntVec(AUTO_INT_5, saveInt5);
}

// Main Function
void _main(void)
{
	if(!SetupCharSet()) return;
	
	//	init random number generator
	randomize();
	
	//	allocate space
	void *offset = NULL;
	if(!(offset = malloc(
		LCD_SIZE +
		BUF_STR_SIZE +
		LCD_SIZE
		))) {
		ST_helpMsg("Memory allocation failed!");
		return;
	}
	
	LcdBuffer = offset;
	offset += LCD_SIZE;
	bufstr = offset;
	offset += BUF_STR_SIZE;
	ScreenBuffer = offset;
	offset += LCD_SIZE;
	
	//	save screen
	FastCopyScreen_R(LCD_MEM, LcdBuffer);
	
	//	clear screen
	FastClearScreen_R(LCD_MEM);
	
	/*
	saveAutoInts(&saveInt1, &saveInt5);
	*/
	
	Error = ERR_NONE;
	
	if(LoadGameData()) {
		Menu();
		//Game();
		if(!SaveGameData()) {
			ST_helpMsg("Saving failed!");
			ngetchx();
		}
	}
	
	FastCopyScreen_R(LcdBuffer, LCD_MEM);
	
	/*
	WaitKeyReleased();
	restoreAutoInts(saveInt1, saveInt5);
	*/
	
	free(LcdBuffer);
	
	if(Error == ERR_NONE) {
		ST_helpMsg(status_message[random(STATUS_MESSAGE_NR)]);
	} else if(Error == FAST_QUIT) {
		ST_helpMsg("Don't let the teacher catch you ;-)");
	} else if(Error == ERR_MEM) {
		ST_helpMsg("Memory allocation failed!");
	}
}