// C Source File
// Created 04.03.2008; 15:22:05

#include "standart.h"
#include "main.h"
#include "fileio.h"
#include "menu.h"
#include "game.h"

//	menu
//#define OPTION_NR 4
//extern short prefs[OPTION_NR+1];

/*
typedef struct {
	unsigned short gameDelay;
	unsigned char spikeMovement;
	unsigned char spikeFactor;
	unsigned char spikeMinLength;
	unsigned char spikeMaxLength;
	unsigned char copNr;
	unsigned char copMoveWait;
} Preferences;
*/

const Preferences std_prefs = {800, SPIKE_MOVEMENT_ALL_DIRECTIONS, 4, 4, 10, 2, 4};
Preferences prefs;

enum MenuOptions {
	MO_SPIKE_MOVEMENT,
	MO_GAME_SPEED,
	MO_SPIKE_FACTOR,
	MO_SPIKE_MIN_LENGTH,
	MO_SPIKE_MAX_LENGTH,
	MO_COP_NR,
	MO_COP_SPEED,
};

void Options(void) {
	/*++prefs[P_SIDE1];
	++prefs[P_SIDE2];*/
	short options[OPTION_NR] = {
		10 - (prefs.gameDelay / 200),
		prefs.spikeMovement + 1,
		prefs.spikeFactor /*+ 1*/,
		prefs.spikeMinLength /*+ 1*/,
		prefs.spikeMaxLength /*+ 1*/,
		prefs.copNr + 1,
		10 - prefs.copMoveWait,
	};
	
	HANDLE dlg = H_NULL, menu[OPTION_NR] /*= {H_NULL,H_NULL,H_NULL,H_NULL}*/;
	unsigned char i;

	if((dlg = DialogNewSimple(234,100)) == H_NULL) {
		Error = ERR_MEM;
		return;
	}
	for(i = 0; i < OPTION_NR; ++i) {
		if((menu[i] = PopupNew(NULL,0)) == H_NULL) {
			HeapFree(dlg);
			while(--i) {
				HeapFree(menu[i]);
			}
			Error = ERR_MEM;
			return;
		}
	}
	
	//	todo: add wall movement
	
	/*static const char *const numStrs[] = {
		"0","1","2","3","4","5","6","7","8","9","10",
	};*/
	
	/*static const unsigned char startVals[] = {
		
	};*/
	PopupAddText(menu[MO_SPIKE_MOVEMENT],-1,"Horz and Vert",0);
	PopupAddText(menu[MO_SPIKE_MOVEMENT],-1,"Horz, Vert & Diagonal",0);
	
	char numStr[3];
	
	static const unsigned char ranges[][2] = {
		{1,10},
		{1,10},
		{1,/*20*/50},
		{1,/*20*/50},
		{0,MAX_COPS},
		{1,10},
	};
	
	//MO_GAME_SPEED
	
	//prefs.spikeMinLength
	for(i = 0; i < 6/*<= MO_COP_SPEED*/; ++i) {
		unsigned char j;
		/*for(j = startVals[i]; j <= endVals[i]; ++j) {
			
		}*/
		for(j = ranges[i][0]; j <= ranges[i][1]; ++j) {
			itoa_ushort_10(numStr, j);
			PopupAddText(menu[MO_GAME_SPEED + i],-1,numStr,0);
		}
	}
	/*
	PopupAddText(menu[MO_GAME_SPEED],-1,"1",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"2",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"3",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"4",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"5",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"6",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"7",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"8",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"9",0);
	PopupAddText(menu[MO_GAME_SPEED],-1,"10",0);
	
	
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"1",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"2",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"3",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"4",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"5",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"6",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"7",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"8",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"9",0);
	PopupAddText(menu[MO_SPIKE_FACTOR],-1,"10",0);
	
	
	
	PopupAddText(menu[MO_COP_NR],-1,"0",0);
	PopupAddText(menu[MO_COP_NR],-1,"1",0);
	PopupAddText(menu[MO_COP_NR],-1,"2",0);
	PopupAddText(menu[MO_COP_NR],-1,"3",0);
	PopupAddText(menu[MO_COP_NR],-1,"4",0);
	PopupAddText(menu[MO_COP_NR],-1,"5",0);
	PopupAddText(menu[MO_COP_NR],-1,"6",0);
	PopupAddText(menu[MO_COP_NR],-1,"7",0);
	PopupAddText(menu[MO_COP_NR],-1,"8",0);
	PopupAddText(menu[MO_COP_NR],-1,"9",0);
	PopupAddText(menu[MO_COP_NR],-1,"10",0);
	
	PopupAddText(menu[MO_COP_SPEED],-1,"1",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"2",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"3",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"4",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"5",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"6",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"7",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"8",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"9",0);
	PopupAddText(menu[MO_COP_SPEED],-1,"10",0);
	*/
	
	DialogAddTitle(dlg,"Options",BT_OK,BT_NONE);
	DialogAddPulldown(dlg,5,15+0*9,"Game Speed",menu[MO_GAME_SPEED],0);
	DialogAddPulldown(dlg,5,15+1*9,"Spike Movement",menu[MO_SPIKE_MOVEMENT],1);
	DialogAddPulldown(dlg,5,15+2*9,"Spike Multiplication",menu[MO_SPIKE_FACTOR],2);
	DialogAddPulldown(dlg,5,15+3*9,"Spike Min Length",menu[MO_SPIKE_MIN_LENGTH],3);
	DialogAddPulldown(dlg,5,15+4*9,"Spike Max Length",menu[MO_SPIKE_MAX_LENGTH],4);
	DialogAddPulldown(dlg,5,15+5*9,"Cop Number",menu[MO_COP_NR],5);
	DialogAddPulldown(dlg,5,15+6*9,"Cop Speed",menu[MO_COP_SPEED],6);
	
	unsigned char result;
	do {
		result = DialogDo(dlg,CENTER,CENTER,NULL,options);
	} while(options[3] > options[4] && result == KEY_ENTER && DlgMessage("Error", "'Spike Min Length' \nmust be lower than \n'Spike Max Length'!",BT_NONE,BT_NONE));
	
	for (i = 0; i < OPTION_NR; ++i) {
		HeapFree(menu[i]);
	}
	HeapFree(dlg);
	
	if(result == KEY_ENTER) {
		/*
		prefs.spikeMovement = options[0] - 1;
		prefs.spikeFactor = options[1] - 1;
		prefs.gameDelay = (10 - options[2]) * 200;
		prefs.copNr = options[3] - 1;
		prefs.copMoveWait = 10 - options[4];
		*/
		
		prefs.gameDelay = (10 - options[0]) * 200;
		prefs.spikeMovement = options[1] - 1;
		prefs.spikeFactor = options[2];
		prefs.spikeMinLength = options[3];
		prefs.spikeMaxLength = options[4];
		prefs.copNr = options[5] - 1;
		prefs.copMoveWait = 10 - options[6];
	}
}

void Highscores(void) {
	
	#define SPACING 5
	
	unsigned char width = 6 * (MAX_NAME_LENGTH + 3 + 3 + 1) + 2 * SPACING;
	
	static char entry[MAX_NAME_LENGTH + 3 + 3 + 1];
	
	WINDOW w;
	WinOpen(&w,&(WIN_RECT){(LCD_WIDTH - width) >> 1, 12, 
		((LCD_WIDTH - width) >> 1) + width, 12 + 12 + 2 * SPACING + (MAX_HISCORES + 1) * 8},
		WF_SAVE_SCR | WF_ROUNDEDBORDER | WF_TITLE, "Hiscores");
	WinFont(&w, /*F_4x6*/ F_6x8);
	WinActivate(&w);
	WinStrXY(&w, SPACING, SPACING, "NAME         LSDs");
	unsigned char i/*, j*/;
	for(i = 0; i < MAX_HISCORES; ++i) {
		memset(entry, ' ', MAX_NAME_LENGTH + 3 + 1);
		strcpy(entry, hiscores[i].name);
		entry[strlen(hiscores[i].name)] = ' ';
		//j = strlen(hiscores[i].name);
		//entry[j++] = ' ';
		itoa_ushort_10_extended(entry + MAX_NAME_LENGTH + 3, hiscores[i].score, 3, 1);
		WinStrXY(&w, SPACING, SPACING + 8 * (i + 1), entry);
	}
	ngetchx();
	WinClose(&w);
}

void Help(void) {
	
	#define HELP_LINES 17
	
	static const char *const helpLines[HELP_LINES] = {
		"You are a drug addict who can not live without",
		"his LSD pills. So you try to consume as much",
		"LSDs as you can get. But they are widespread",
		"and the cops are chasing you! ",
		"Avoid colliding with them and dodge the spikes!",
		"",
		"Good luck!",
		"",
		"Keys:",
		"Arrows - Moving",
		"APPS - Pause",
		"HAND - Teleport",
		"+/- - Contrast",
		"CLR - Teachermode",
		"In Teachermode:",
		"Diamond - Fast quit",
		"2nd - Shut calc off",
	};
	
	unsigned char width = 0;
	unsigned char i;
	for(i = 0; i < HELP_LINES; ++i) {
		if(strlen(helpLines[i]) > strlen(helpLines[width])) {
			width = i;
		}
	}
	
	#define SPACING 5
	
	width = DrawStrWidth(helpLines[width], F_4x6) + 2 * SPACING;
	
	WINDOW w;
	WinOpen(&w,&(WIN_RECT){(LCD_WIDTH - width) >> 1, /*5*/ 0, 
		((LCD_WIDTH - width) >> 1) + width, /*5*/ 0 + 12 + 2 * SPACING + HELP_LINES * 6},
		WF_SAVE_SCR | WF_ROUNDEDBORDER | WF_TITLE, "Help");
	WinFont(&w, F_4x6);
	WinActivate(&w);
	for(i = 0; i < HELP_LINES; ++i) {
		WinStrXY(&w, SPACING, SPACING + 6 * i, helpLines[i]);
	}
	ngetchx();
	WinClose(&w);
}

void About(void) {
	
	#define ABOUT_LINES 10
	
	static const char *const aboutLines[ABOUT_LINES] = {
		COMMENT_PROGRAM_NAME " " COMMENT_VERSION_STRING	" Copyright () 2008",
		"by Oliver Hoog aka Boscop, member of BoolSoft",
		"http://www.boolsoft.org/",
		"",
		"For bug reports, comments, questions",
		"or suggestions email me at: boscop@boolsoft.org",
		"",
		"Compiled with TIGCC 0.96 8,",
		EXTGRAPH_VERSION_PWDSTR,
		"Thanks to Technoplaza and BoolSoft's members."
	};
	
	//unsigned short largestStringsWidth = 0;
	unsigned char width = 0;
	unsigned char i;
	for(i = 0; i < /*sizeof(aboutLines)*/ABOUT_LINES; ++i) {
		/*if(strlen(aboutLines[i]) > largestStringsWidth) {
			largestStringsWidth = strlen(aboutLines[i]);
		}*/
		if(strlen(aboutLines[i]) > strlen(aboutLines[width])) {
			width = i;
		}
	}
	
	#define SPACING 5
	
	width = DrawStrWidth(aboutLines[width], F_4x6) + 2 * SPACING;
	
	WINDOW w;
	WinOpen(&w,&(WIN_RECT){(LCD_WIDTH - width) >> 1, 12, 
		((LCD_WIDTH - width) >> 1) + width, 12 + 12 + 2 * SPACING + ABOUT_LINES * 6},
		WF_SAVE_SCR | WF_ROUNDEDBORDER | WF_TITLE, "About");
	WinFont(&w, F_4x6);
	WinActivate(&w);
	for(i = 0; i < /*sizeof(aboutLines)*/ABOUT_LINES; ++i) {
		WinStrXY(&w, SPACING, SPACING + 6 * i, aboutLines[i]);
	}
	ngetchx();
	WinClose(&w);
}

void (*GameFuncs[5])(void) = {Game, Options, Highscores, Help, About};

void Menu(void) {
	short result = 0;
	do {
		//	clear screen
		FastClearScreen_R(LCD_MEM);
		
		HANDLE handle = PopupNew(COMMENT_PROGRAM_NAME /*"\n" COMMENT_AUTHORS*/, 0);
		PopupAddText(handle, -1, "Start Game", 1);
		PopupAddText(handle, -1, "Options", 2);
		PopupAddText(handle, -1, "Highscores", 3);
		PopupAddText(handle, -1, "Help", 4);
		PopupAddText(handle, -1, "About", 5);
		PopupAddText(handle, -1, "Exit", 6);
		result = PopupDo(handle, CENTER, CENTER, 0);
		HeapFree(handle);
		if(result == 0 || result == 6) {
			break;
		}
		(GameFuncs[result - 1])();
	} while(Error == ERR_NONE);
}