// Header File
// Created 29.06.2008; 14:42:34

#ifndef _GAME_H_
#define _GAME_H_

void Game();

typedef struct {
	volatile unsigned char running : 1;
	volatile unsigned char counter : 5;
	volatile unsigned char seconds : 6;
	volatile unsigned char minutes : 6;
	volatile unsigned char updated : 1;
} Clock;

extern Clock clock;

typedef enum {
	GAME_STATE_RUNNING,
	GAME_STATE_ABORTED,
	GAME_STATE_LOST,
	GAME_STATE_NEXT_LEVEL,
} GameState;


//#define DIFFICULTY 4


typedef struct {
	const void */*const*/ data;
	unsigned char width;
	//unsigned char bytewidth;
	unsigned char height;
} Sprite;

typedef short Axis;	//unsigned char

typedef struct {
	Axis x;
	Axis y;
} Position;

typedef struct {
	//Axis x, y;
	Position pos;
	unsigned char lsdNr;
} Player;

typedef struct {
	//Axis x, y;
	Position pos;
} Lsd;

#define LSD_PLAYER_MIN_DIST 20

typedef struct {
	unsigned char active;
	//Axis x, y;
	Position pos;
	/*unsigned*/ char vx, vy;
	unsigned char length;
} Spike;

#define MAX_SPIKES 1000
//#define SPIKE_MIN_LENGTH 5	//2	//5
//#define SPIKE_MAX_LENGTH 8	//16
#define SPIKE_PLAYER_MIN_DIST 60	//30	//20

typedef struct {
	Position pos;
	unsigned char moveWaitCounter;
} Cop;

#define MAX_COPS 30
//#define COP_MOVE_WAIT 3	//2	//5
#define COP_PLAYER_MIN_DIST 80
#define COP_RANDOM_STEP 10	//100	//30	//10


#endif