<?php

define ('ENV_CHARSET',	'ISO-8859-1');

?>
<html>
	<head>
		<meta http-equiv="Content-Type" content="application/xhtml+xml;charset=<?php echo ENV_CHARSET; ?>" />
		<title>Encoding Detection Test</title>
	</head>
	<body>
<?php

function	fileTextEncode ($text)
{
	$cs_latin1 = 0;
	$cs_utf8 = 0;

	// Detect file charset by reading first characters
	$size = min (strlen ($text), 256);

	for ($i = 0; $i < $size; ++$i)
	{
		$byte = ord ($text[$i]);

		if ($byte > 127)
		{
			if (($byte & 224) == 192 && $i + 1 < $size && (ord ($text[$i + 1]) & 192) == 128)
			{
				++$cs_utf8;
				$i += 1;
			}
			else if (($byte & 240) == 224 && $i + 2 < $size && (ord ($text[$i + 1]) & 192) == 128 && (ord ($text[$i + 2]) & 192) == 128)
			{
				++$cs_utf8;
				$i += 2;
			}
			else if (($byte & 248) == 240 && $i + 3 < $size && (ord ($text[$i + 1]) & 192) == 128 && (ord ($text[$i + 2]) & 192) == 128 && (ord ($text[$i + 3]) & 192) == 128)
			{
				++$cs_utf8;
				$i += 3;
			}
			else
				++$cs_latin1;
		}
	}

	// Convert from detected to current charset
	switch (strtolower (ENV_CHARSET))
	{
		case 'iso-8859-1':
		case 'latin-1':
			return $cs_latin1 < $cs_utf8 ? utf8_decode ($text) : $text;

		case 'utf-8':
			return $cs_latin1 > $cs_utf8 ? utf8_encode ($text) : $text;

		default:
			return $text;
	}
}

echo nl2br (fileTextEncode (file_get_contents ('test1.txt'))) . '<br /><br />';
echo nl2br (fileTextEncode (file_get_contents ('test2.txt'))) . '<br /><br />';
echo nl2br (fileTextEncode (file_get_contents ('test3.txt'))) . '<br /><br />';
echo nl2br (fileTextEncode (file_get_contents ('test4.txt'))) . '<br /><br />';

?>

	</body>
</html>
