;modified by rockyone		pour  MI-3 MI-9			19/03/2017
;	
; Add  SPU							22/03/2017
; Ajout copy palette et palette noir pour le diaporama		03.06.2019
; Modif. l'image ne serat plus conserv aprs conversion	07.07.9019
; modifi pour petits fichiers SPC 				09.07.2019
; Modif retour eror: -2 bad header or bad file size		11.09.2019
;		     -5 bad dcompressed
; Alignement des buffers palettes sur ceux d'IFF		19.10.2020
; Ajout open SPS						16.09.2025
;-------------------------------------------------------------------------		
;
;				OPEN SPC SPU SPS
;				****************
;
; Source	72224 Fichier charg  source+0
; Ecran         Adresse physique de l'cran
; Buf_ecr       32034 : ecr_buf = buf_ecr+34
; File_size     taille du fichier charg
; type%         1 only file SPS
;
;
;		   60		64	68	  72		76
; Call Spc_SPU ( L Source, L Screen, L Ecr_buf, L file_size, types%)
;		
;	--------------------------------------------------------------
;
; Retour:  D0 =  0  Ok
;	   D0 = -5  bad data
;	   D0 = -6  bad raster
;
; Retour buffer Source
;   +0       5120 octets : reservs pour table de conversion
;   +5120     320 octets : reservs pour conversion ligne image
;   +5440                : 
;   +32000  19200 octets : palettes Restauration, Sauvegarde, Conversion
;   +51200  19200 octets : palettes Affichage
;   +70400   2016 octets : 63 palettes / 21 lignes, pour le diaporama
;   total   72416 octets
;
;
; Retour Screen   image 
; Retour Ecr_Buf  image pour restauration et conversion en gris
;
;  - l'image Spectrum est perdue aprs la conversion en gris -
;-------------------------------------------------------------------------
;SPC SPS : 
; 	 +0	W	'SP'
;  	 +2	W	$0
;  	 +4	LW	taille de l'image compress
;  	 +8	LW	taille des palettes compress
; 	+12	LW	dbut des data images compres
;
;SPU :  +0              data image   32000
;	+32000	        palette      19104 
;			total	     51104 octets
;-------------------------------------------------------------------------
;a0 buf_pic
;a1 screen
;a2 buf_ecr+34
	movem.l	d1-d7/a0-a6,-(sp)	
	movem.l	60(sp),a0-a2
	move.l	72(sp),d6		; file size

	movea.l	a0,a3			; adr. copy palette		
	adda.l	#51200,a3		;  "	"	"
	lea.l	32000(a1),a6		; End of screen

	moveq	#-2,d0
	cmpi.w	#$5350,(a0)		; "SP" ?
	bne	spu			

;-------------------------------------------------------------------------
;                   DECOMPRESSION SPC / sps
;-------------------------------------------------------------------------
;a0 source
;a1 screen
;a2 buf_ecr
;a3 = a0+51200  
;a6 end screen
;-------------------------------------------------------------------------

	lea.l	12(a0),a4		; adr image compresed
	moveq	#1,d1			; Offset byte 
	moveq	#6,d2			; For xor
	

	bsr	first_line          ; clear first line screen
;                           ; a1 est incrment de 160 bytes	
                            
	lea.l 	8(a6),a5		; end of last plane
		                    
;*************************		
        tst.w   76(sp)			; = 1 for SPS file    
        bne   depac_sps     
;*************************      		
                            
depac:		                
	move.b	(a4)+,d3		; start of unpacking
	ext.w	d3			    ; pack-bit method
	bpl.s	literal         
                            
	neg.w	d3              
	addq.w	#1,d3           
	move.b	(a4)+,d7        
	                        
full:	                    
	move.b	d7,(a1)         
	adda.l	d1,a1			; address next byte
	eor.b	d2,d1           
	dbra.w	d3,full         
                            
	bra.s	depac_end       
	                        
literal:	                
	move.b	(a4)+,(a1)      
	adda.w	d1,a1           
	eor.b	d2,d1           
	dbra.w	d3,literal          
	                        
depac_end:	                
	cmpa.l	a6,a1			; End of a plan ?
	bcs.s	depac			; No => continu
	bne	error_pic               

	addq.l	#2,a6			; End of the next plan.
	lea.l	-31840(a6),a1		; Beginning of next plan.
	cmpa.l	a5,a6			; Last plan ?
	bcs.s	depac
;...............................................
	move.l	a4,d7			; Calculate the number
	addq.l	#1,d7			; of uncompressed bytes...
	bclr	#0,d7
*************	
sps_end_data:
************* 
	lea.l	12(a0),a4
	sub.l	a4,d7		
	cmp.l	4(a0),d7		; Compacted image size
	bne	error_pic		; Error ! => End.
;...............................................
;a4 a5 source
;a3 buffer palette
; palettes decompresses dans pal_display (199*96 to 200*96)
	lea.l	96(a3),a2		; Pal_restor line 1
* 	move.l	8(a0),d1		; Compacted pallet size.
	lea.l	12(a0,d7),a4		; Palett address.
	movea.l	a4,a5			; For control
	

	move.w	#596,d4		; Nomber of palettes -1
	moveq	#0,d7

;*************************		
        tst.w   76(sp)  
        bne   pal_sps
;************************* 
 
pal:	
	moveq	#13,d2			; Unpacking the palette.
	move.w	(a4)+,d3
	lsr.w	#1,d3
	move.w	d7,(a2)+
color:
	lsr.w	#1,d3
	bcc.s	empty			; 
	move.w	(a4)+,(a2)+
	dbra.w	d2,color
	bra.s	pal_end
	
empty:	move.w	d7,(a2)+
	dbra.w	d2,color


pal_end:
	move.w	#$fff,(a2)+		; Color 15
	dbra.w	d4,pal

***********
sps_pal_end:
************	
	suba.l	a5,a4			; Nunber byte depacted.
	cmpa.l	8(a0),a4		; Compare with the size of
;					; the compressed pallets.
	bne.s	error_pal_sps

		
;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
; recopy Pal_Display dans Pal_restor
recopy_pal:
	movea.l	a3,a0			; Pal_display
	lea.l	-19200(a3),a1		; Pal_restor
	movea.l a3,a6			; Copy the palettes for 
	bsr.s	copy_32			; the slideshow.

; 21 palettes noir pour la ligne "Info fichier" et le menu du diaporama
	lea.l	19200+30(a3),a3
	move.w	#63-1,d0		; 63 palettes = 21 ligne.
black_pal:
	move.w	#$fff,(a3)		; To display Info_File
	adda.w	#32,a3			; and slide show menu on
	dbra.w	d0,black_pal		; image.

; copie Screen to Ecr_buf
	bsr.s	recopy_pic		; image on Buf_Ecr a2

;inutile maintenant que tout l'ecran est copier
*	move.l	60(sp),a1		; clears first line of
*	bsr.s	first_line		; the image source.

	moveq	#0,d0			; Return no error.
;-------------------------------------------------------------------------
;bad header or bad size file
bad_header:
					
end_prg:
	movem.l	(sp)+,d1-d7/a0-a6	
	rts
error_pic:	
	moveq	#-5,d0			; eror in compressed data
	bra.s	end_prg
error_pal_sps:
	moveq	#-6,d0
	bra.s	end_prg

;------------------------------------------------------------------------
;				Sub routines
;------------------------------------------------------------------------
first_line:
	moveq	#160/8-1,d7		; Clears the first line
clear:	
	clr.l	(a1)+			
	clr.l	(a1)+
	dbra.w	d7,clear
	rts
;		--------------------------------		
recopy_pic:
	movem.l	68(sp),a0-a1		
	lea.l	32000(a1),a6		; recopy 32000 byte
copy_32:
	move.l	(a0)+,(a1)+		; or   19104     bytes
	move.l	(a0)+,(a1)+		; or   19200     bytes
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	cmpa.l	a1,a6
	bhi.s	copy_32
	rts		
;-------------------------------------------------------------------------
;				   DECOMPRESSION SPS   
;-------------------------------------------------------------------------
;a0 source (ne pas modifier l'adresse)
;a1 screen
;a2             adr. buf_ecr+34
;a3 = a0+51200  adr. copy palette
;a4 = a0   adr. image data
;a6 end screen
; A1  est dj incrment de 160 octets par BSR Firts_Line    
;-------------------------------------------------------------------------
;			TEST FORMAT COMPRESSION SPS            
;-------------------------------------------------------------------------
depac_sps:
	lea.l	0(a0,d6.l),a3
	btst.b	#0,-(a3)	
	beq	init_vertical
	
;-------------------------------------------------------------------------
;			SPS HORIZONTALE            
;-------------------------------------------------------------------------

sps_horizontal:
	cmpa.l	a1,a6			; end of an image plan ?
	bhi.s	read_byte_h		; no a6 > a1
	bsr	new_plan

read_byte_h:
	clr.l	d3	
	move.b	(a4)+,d3		; lire l'en-tte
	bmi.s	sps_literal		;  si d3 >= 128 ? copie brute

sps_rle:
	addq.l	#2,d3			; rptition x+3 fois
	move.b	(a4)+,d7
	
sps_rle_loop:
	cmpa.l	a1,a6
	bhi.s	ok_rle

	bsr     new_plan
ok_rle:   
	move.b	d7,(a1)
	adda.l	d1,a1
	eor.b   d2,d1
	dbra.w	d3,sps_rle_loop
	
	bra.s	sps_depac_end

sps_literal:
	subi.b	#-128,d3         ; copier x-128+1 octets

sps_loop_l:
	cmpa.l	a1,a6
	bhi.s	ok_literal
	bsr.s   new_plan
    
ok_literal:    
	move.b	(a4)+,(a1)
	adda.l	d1,a1
	eor.b   d2,d1
	dbra.w	d3,sps_loop_l

sps_depac_end:
	cmpa.l	a1,a6 			; fin d'un plan ?
	bhi.s	sps_horizontal

	bsr.s	new_plan		; next  plans ?
	cmpa.l	a6,a5
	bhi.s	sps_horizontal		; oui continuer
	
;................................................................
; fin de la dcompression verticale et horizontal des images SPS 
;................................................................
end_sps:
	movea.l	a0,a3			; adr. copy palette		
	adda.l	#51200,a3
	lea.l	12(a0),a4
	adda.l	4(a0),a4
	movea.l	a4,a5
	move.l  a4,d7			; offset adresse palettes
	
	bra	sps_end_data        ; suite dcompression
	
new_plan:
	moveq	#1,d1
	addq.l  #2,a6
	lea.l   -31840(a6),a1
	rts

;-------------------------------------------------------------------------
;			SPS VERTICAL

; a0    adr image source  ( ne pas modifier )
; a1    adr screen destination (pointe dj sur la 2 ligne)
; a2    adr screen
; a3    intulis
; a4    adr image compresse
; a5    free
; a6    adr end_colonnes et end_screen
; d1    ofsset entre deux colonne de plan 
; d2    
; d3    registre des rptitions d'octet
; d4    compteur de colonnes d'octets par plan d'image 
; d5    free
; d6    plan 
; d7    registre d'un octet  dupliquer
;-------------------------------------------------------------------------
init_vertical:
	moveq   #1,d1           ; dcalage colonne pair = +1
	moveq   #6,d2           ; XOR ? alterne 1 ? 7
	move.l	#40,d4		; colonne
	moveq	#4,d6		; plan    
	movea.l	a1,a5

sps_vertical:
	cmpa.l  a1,a6           ; fin d'une colonne ?
	bhi.s   read_byte_v
	bsr     new_plan_v

read_byte_v:
	clr.l   d3
	move.b  (a4)+,d3        ; lire len-tte
	bmi.s   sps_literal_v   ; ngatif ? littral

;--- RLE ---
sps_rle_v:
	addq.l  #2,d3           ; x+3 rptitions
	move.b  (a4)+,d7
    
rle_loop_v:
	cmpa.l  a1,a6
	bhi.s   ok_rle_v
	bsr     new_plan_v

ok_rle_v:
	move.b  d7,(a1)
	adda.l  #160,a1             ; descendre de 1 ligne (160 octets)
	dbra    d3,rle_loop_v   
    
	bra.s   sps_depac_end_v     ;

;--- LITTRAL ---
sps_literal_v:
	subi.b	#128,d3         ; x-128+1 octets

sps_loop_v:
	cmpa.l  a1,a6
	bhi.s   ok_literal_v
	bsr     new_plan_v
    
ok_literal_v:
	move.b  (a4)+,(a1)      ;
	adda.l  #160,a1         ; descendre dune ligne
	dbra    d3,sps_loop_v

;--- BOUCLE ---
sps_depac_end_v:                
*	tst.b	d6			; dernier plan?
*	beq.s	end_v			; oui
	cmpa.l	a1,a6			; derniere ligne ?
	bhi.s   sps_vertical		; non  

	bsr     new_plan_v		; passe  la suivante
	tst.b    d6			; dernier plan ?
	bhi.s   sps_vertical        	; non
	
end_v:
;--------------------
*	bra	recopy_pal
	bra	end_sps  
;--------------------

;--- GESTION COLONNES / PLANS ---
new_plan_v:
	subq.w  #1,d4           ; colonne -1
	beq.s	next_plan_v	

	adda.l  d1,a6		; +1 (col. paire) ou +7 (col. impaire)
	eor.b   d2,d1		; alterne 1 et 7
	lea     -31840(a6),a1   ; retour haut de la colonne suivante
	rts
    

next_plan_v:
	moveq	#1,d1		; reset offset colonne
	move.w  #40,d4		; reset colonne
	subi.b	#1,d6		; plan -1

	addq.l	#2,a5		; plan suivant
	movea.l	a5,a1		; premiere colonne du plan
	lea.l	31840(a1),a6    ; fin premiere colonne d'un plan
    	rts
   

;-------------------------------------------------------------------------
;           Dcompression palette SPS              
;
;a0 source
;a1 screen
;a3 = a0+51200      adr. copy palette  ( Pal_display )
;a2 = a3+96         adr. decompression palette

;a4 = 12(a0,d7)     adr. palette compressed
;a5 = a4
;a6  = 32000 (a1)   adr. end screen
; A1  est dj incrment de 160 octets par BSR Firts_Line    


; A4 = adresse pair ou impair des palettes compresses
; D4 =597-1 dcomptage des palettes
;-------------------------------------------------------------------------
Pal_sps:
	adda.l	8(a0),a5	; fin des palettes compresses 
	moveq	#0,d6		; D6 = buffer bits
 	moveq	#0,d5		; D5 = compteur bits dans buffer

palette_loop:
	clr.w	(a2)+		; palette[0] = $000
    	moveq	#14,d1		; Lire en-tte 14 bits
	bsr.s	read_bits	; D0 = masque 14 bits

	move.w	d0,d3		; D3 = masque en-tte
	moveq	#1,d2		; D2 = index couleur (1  14)
    
entry_loop:
	moveq	#14,d7		; Calculer position bit
	sub.w	d2,d7		; Position = 14 - index
	btst	d7,d3		; Bit prsent dans masque ?
	beq.s	entry_zero	; Non, couleur = $000
    
	moveq	#9,d1		; Lire couleur 9 bits (rrrgggbbb)
	bsr.s	read_bits	; D0 = couleur 9 bits
	bsr.s	convert_color	; Convertir au format Atari ST

	move.w	d0,(a2)+	; Stocker couleur convertie
	bra.s	next_entry
    
entry_zero:
	clr.w	(a2)+			; palette[i] = $000

next_entry:
	addq.w	#1,d2                   ; Index couleur suivant
	cmpi.w	#15,d2                  ; Fini les couleurs 1-14 ?
	blt.s	entry_loop              ; Non, continuer
    
	move.w	#$0FFF,(a2)+            ; palette[15] = $FFF
	dbra.w	d4,palette_loop         ; Palette suivante

end_byte_pal:    
 	movea.l	a4,a5
	suba.l	8(a0),a5
	
*	bra	recopy_pal   
	bra	sps_pal_end                 ; suite dcompression

;-------------------------------------------------------------------------
; Conversion couleur 9 bits vers format Atari ST
; Entre: D0 = rrrgggbbb (9 bits)
; Sortie: D0 = 0000 0rrr 0ggg 0bbb (format Atari ST)
; Modifie: D1,D7 seulement
;-------------------------------------------------------------------------
convert_color:
	move.w	d0,d7                   ; Copie couleur originale
    
; Extraire rouge (bits 8-6) vers bits 10-8
	andi.w	#$01C0,d0               ; Masquer rouge (bits 8-6)
	lsl.w	#2,d0                   ; Dcaler vers bits 10-8
    
; Extraire vert (bits 5-3) vers bits 6-4  
	move.w	d7,d1                   ; Rcuprer original
	andi.w	#$0038,d1               ; Masquer vert (bits 5-3)
	lsl.w	#1,d1                   ; Dcaler vers bits 6-4
	or.w	d1,d0                   ; Combiner
    
; Extraire bleu (bits 2-0) - dj en bonne position
	andi.w	#$0007,d7               ; Masquer bleu
	or.w	d7,d0                   ; Combiner final
    
	rts

;-------------------------------------------------------------------------
; Lecture de N bits depuis flux continu
; Entre: D1 = nombre de bits (1-16)
; Sortie: D0 = bits lus
; Modifie: D0,D7
; Utilise: A1 = limite fin des donnes, A4 = pointeur lecture
; Utilise: D5 = bits disponibles dans buffer, D6 = buffer bits
;-------------------------------------------------------------------------
read_bits:
	moveq	#0,d0                   ; Rsultat

fill_buffer:
	cmp.w	d1,d5                   ; Assez de bits dans buffer ?
	bge.s	extract                 ; Oui, extraire
    
	lsl.l	#8,d6                   ; Dcaler buffer de 8 bits

; Vrifier si donnes disponibles
	cmpa.l	a4,a5		
	bhi.s	read_byte_pal		;>  A5 > A4 : encore des donnes

; Plus de byte
	move.b	#$00,d6                 ; remplir avec des zeros
	bra.s	bits_added
    
read_byte_pal:
	move.b	(a4)+,d6                ; Lire nouveau byte
    
bits_added:
	addq.w	#8,d5                   ; +8 bits disponibles dans buffer
	bra.s	fill_buffer	; Vrifier si assez de bits maintenant
    
extract:
	move.w	d5,d7                   ; Bits disponibles
	sub.w	d1,d7                   ; Position aprs extraction
	move.w	d7,d5                   ; Mettre  jour compteur bits
    
	move.l	d6,d0                   ; Copie buffer
	lsr.l	d7,d0                   ; Dcaler pour extraire bits voulus
    
; Crer et appliquer masque pour N bits
	moveq	#32,d7                  ; Prparer masque
	sub.w	d1,d7                   ; 32 - nombre_bits
	moveq	#-1,d1                  ; $FFFFFFFF
	lsr.l	d7,d1                   ; Masque pour N bits
	and.l	d1,d0                   ; Appliquer masque
    
	rts

;-------------------------------------------------------------------------
;			DECOMPRESSION SPU
;-------------------------------------------------------------------------
spu:		
*	move.w	72(sp),d6
*	ext.l	d6
	cmpi.l	#51104,d6	; File size ?
	bne	bad_header	; Error !!

; image to screen
	bsr	first_line	; a1 Clear first line screen
	lea.l	160(a0),a0	; a0 Jump first line image
	bsr	copy_32		; a0 on a1 Image on the screen 

; a1=a6 screen
; a0= source + 32000
; a3= source + 51200
; aligne les datas palettes dans le buffer pal_display
;	a0 :  	source 199*3*32 palettes
; 	a1 :	but    200*3*32 palettes
;	
; palette to Pal_display
	lea.l	96(a3),a1	; but + 3 palette noir ( ligne 0 )
	lea.l	19200(a3),a6	; limite de copie        : 19104 bytes
	bsr	copy_32		; On the source +51200

; aO = source+51104
; a3 = source+51200	
; recopy toutes les palettes dans le buffer pal_restore source+32000
;
; Pal_display to Pal_restor
	bra	recopy_pal

	END
;-------------------------------------------------------------------------
	