; rockyone			pour MI-3M >v48			28.10.2025
;--------------------------------------------------------------------------
; Conversion palette PI1 -> 16 niveaux de gris (tris par luminosit)
;	...	     PI2 ->  4 niveaux de gris 		...
;
;
; Appel Omikron BASIC :
;	buf_pi1 : buffer 32066 octets + 64 octets pour le tri des couleurs
;
;*	typ% =  0 image 1 palette 16 ou 4 couleurs
;*	typ% = -1 image 3 palettes par lignes
;*	typ% = -2 image 1 palette par ligne
;
;	CALL conv_gris( L Buf_Pi1, typ% )
;
; La palette de couleurs est remplace par la palette grise dans buf_pi1
;--------------------------------------------------------------------------
                                        
conv_gris:                              
	movem.l	d0-d7/a0-a6,-(sp)           
	move.l	64(sp),a0		; buffer PI1 / PI2
	lea.l	32066(a0),a2		; a2 -> buffer de travail

;-------------------------------
; Palette resolution  0 ou 1
;-------------------------------
	lea.l	pal_grey(pc),a6 	; a6 -> palette grise
	move.w  (a0)+,d7		; 0 / 1 rsolution image
	move.w  d7,d5
	andi.w  #1,d5
	lsl.w	#5,d5			; *32
	adda.w  d5,a6          		; a6 -> palette low / medium

;-------------------------------
; Nombre de couleurs  convertir
;-------------------------------                          
	move.w #32,d5
	lsl.w   #1,d7       	; 0 / 2	
	addq.w  #1,d7
	lsr.w   d7,d5           ; 16 ou 4 couleurs
	subq.w  #1,d5           ; -1 pour dbra


all_pall:	                
	movea.l	a0,a1		; reset a1 -> palette couleurs (16 mots)
	movea.l	a2,a3	        ; reset a3 -> luminosits (16 mots)
	lea.l	32(a2),a4	; reset a4 -> indices (16 mots)

	moveq.l	#0,d6
        move.w	d5,d7		; nombre de couleurs                   

;------------------------------- 
; Calculer luminosit et index
;------------------------------
calc_lum:                   
	move.w	(a1)+,d1        
	andi.w	#$777,d1        
                            
*	move.w	d0,d1		; R
*	andi.w	#$00F,d1        
*	mulu	#1,d1		; R * 0.1  *1
                            
	move.w	d1,d2		; V
	lsr.w	#4,d2           
	mulu	#6,d2		; V * 0.6  *6
                            
	move.w	d1,d3		; B
	lsr.w	#8,d3           
	mulu	#3,d3		; B * 0.3  *3

	add.w	d2,d1           
	add.w	d3,d1           
                            
	move.w	d1,(a3)+	; Luminosit
	move.w	d6,(a4)+	; Index
	addq.w	#1,d6           
	dbra	d7,calc_lum 
    
;-------------------------                           
; Tri a bulles des Lum/Idx
;-------------------------
	movea.l	a2,a3           ; Lum
	lea.l	32(a2),a4	; Idx
	move.w	d5,d7           ; nombre de couleurs      

tri_externe:                
	movea.l	a3,a1           
	movea.l	a4,a5           
	move.w	d7,d6           

tri_interne:                
*---
	move.w	(a1),d1         
	move.w	2(a1),d2   
	cmp.w	d2,d1           
	ble.s	no_swap  <=

	move.w	d2,(a1)         
	move.w	d1,2(a1)  
*---
	move.l	(a5),d2
	swap	d2
	move.l	d2,(a5)      

no_swap:                    
	addq.l	#2,a1    
   	addq.l	#2,a5           
	subq.w	#1,d6      
	bhi.s	tri_interne     ; >0
	dbra	d7,tri_externe  
                        
;--------------------------------    
; Ecriture palette grise	
;--------------------------------
	movea.l a6,a5           ; a5 -> palette grise
	move.w	d5,d7           ; nombre de couleurs

write_loop:                 
	move.w	(a4)+,d1	; index original
	lsl.w	#1,d1           
	lea.l	0(a0,d1.w),a1   
	move.w	(a5)+,(a1)      
	dbra	d7,write_loop   
	                        
*next_pal:                  
*    lea.l   32(a0),a0      
*    cmpa.l  a0,ax          
*    bhi.s   all_pal        
                            
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;-----------------------------------------------------------
; Palettes grise precalculee ( du plus fonce au plus clair )
;-----------------------------------------------------------
pal_grey:
	dc.w	$0000,$0888,$0111,$0999
	dc.w	$0222,$0AAA,$0333,$0BBB
	dc.w	$0444,$0CCC,$0555,$0DDD
	dc.w	$0666,$0EEE,$0777,$0FFF

	dc.w    $0000,$0AAA,$0BBB,$0FFF
	end
