#define MAXD 0.4
#define MIND 0.1
#define W 640.
#define H 480.

varying vec2 vTexCoord;
uniform sampler2D uImage0;
uniform float blackHoleX;
uniform float blackHoleY;
uniform float apply;

float f(float d)
{
    return 1. / pow((d - MIND) / (MAXD - MIND), 1. / 3.5);
}

void main()
{
	vec2 frustrum = vec2(W / H, H / H);
	vec2 uv = vTexCoord - vec2(0.5, 0.5);
	uv *= frustrum;
	if(apply > 0.5)
	{
		vec2 attractionPoint = vec2(blackHoleX, blackHoleY) - vec2(0.5, 0.5);
		attractionPoint * frustrum;
		float d = distance(uv, attractionPoint);
		
		if(d < MAXD)
		{
			if(d < MIND)
			{
				gl_FragColor = vec4(vec3(0.), 1.);
				return;
			}
			uv = f(d) * (uv - attractionPoint) + attractionPoint;
		}
	}
	gl_FragColor = texture2D(uImage0, uv / frustrum + vec2(0.5, 0.5));
}
