// Megadrive/Genesis - SGDK - 08/05/2011
// Test affichage de tiles sur le Scroll/Plan A
// et tableau multidimensionnel
// mais il y a un problme  ligne 132: le premier tile a toujour la valeur 0

#include <genesis.h>

//sapf01.h is generated from sapf01.bmp
//just be sure to put your 16colors bitmap on 'res' folder
// file logo-blue-sapf01-25024.jpg is here for reference : it's the original picture I used
#include "sapfv.h"
#include "sapf01.h"
#include "sapf02.h"
#include "sapf03.h"
#include "sapf04.h"
#include "sapf05.h"
#include "sapf06.h"

int main( )
{
    // tableau pour les tiles
    const u16 tbr01[5][5]=
    {
	{0x04,0x03,0x02,0x03,0x04},
	{0x01,0x02,0x03,0x02,0x01},
	{0x01,0x02,0x03,0x02,0x01},
	{0x02,0x03,0x03,0x03,0x02},
	{0x03,0x03,0x01,0x03,0x03}
    };



    u16 comptx;u16 compty;u16 compti; // variables pour lecture de data ci-dessus
    u16 planA[6]; // (0  6) variable utilise pour stocker la position en Vram des Tiles du Plan/Scroll A
    u16 value; // pour le joypad
    u16 dbtest; // variable de test debug
    u16 wt;u16 ht;u16 num_tiles; // variables importantes pour les tiles/Vram
    u16 tile_ind = TILE_USERINDEX; // initialize tile index where to transfert tile data

    // load first image: Tile00 (vide, utilis pour effacer en fait)
    wt = sapfv[0] / 8; // get the image width (in tile)
    ht = sapfv[1] / 8; // get the image height (in tile)
    num_tiles = wt * ht; // number of tiles composing the image
    VDP_setPalette(PAL1, (u16 *) &sapfv[2]); // get the palette at sapfv[2 to 17]
    VDP_loadBMPTileData((u32*) &sapfv[18], tile_ind, wt, ht, wt); // load bitmap data at sapfv[18....] in VRAM
    // wt = width in tiles we want to load
    // ht = height in tile we want to load
    // wt = width in tiles of the bitmap
    // the 3rd arg is needed because you could load only a part of the bitmap if you want but SGDK needs the width as reference

    // adjust tile index for next transfert
    planA[0] = tile_ind; // planA[0] stocke la position en Vram de Tile 00
    tile_ind += num_tiles;

    // load next image: Tile01
    wt = sapf01[0] / 8;
    ht = sapf01[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf01[18], tile_ind, wt, ht, wt);
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 0, 0, wt, ht); // Test: draw the sapf01 at (0, 0)

    planA[1] = tile_ind; // planA[1] stocke la position en Vram de Tile 01
    tile_ind += num_tiles;

    // load next image: Tile02
    wt = sapf02[0] / 8;
    ht = sapf02[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf02[18], tile_ind, wt, ht, wt);
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 4, 0, wt, ht); // Test: draw the sapf02 at (4, 0)

    planA[2] = tile_ind; // planA[2] stocke la position en Vram de Tile 02
    tile_ind += num_tiles;

    // load next image: Tile03
    wt = sapf03[0] / 8;
    ht = sapf03[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf03[18], tile_ind, wt, ht, wt);
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 8, 0, wt, ht); // Test: draw the sapf03 at (8, 0)

    planA[3] = tile_ind; // planA[3] stocke la position en Vram de Tile 03
    tile_ind += num_tiles;

    // load next image: Tile04
    wt = sapf04[0] / 8;
    ht = sapf04[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf04[18], tile_ind, wt, ht, wt);
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 12, 0, wt, ht); // Test: draw the sapf04 at (12, 0)

    planA[4] = tile_ind; // planA[4] stocke la position en Vram de Tile 04
    tile_ind += num_tiles;

    // load next image: Tile05
    wt = sapf05[0] / 8;
    ht = sapf05[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf05[18], tile_ind, wt, ht, wt);
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 16, 0, wt, ht); // Test: draw the sapf05 at (16, 0)


    planA[5] = tile_ind; // planA[5] stocke la position en Vram de Tile 05
    tile_ind += num_tiles;

    // load next image: Tile06  wt = sapf06[0] / 8;
    ht = sapf06[1] / 8;
    num_tiles = wt * ht;
    VDP_loadBMPTileData((u32*) &sapf06[18], tile_ind, wt, ht, wt);
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 20, 0, wt, ht); // Test: draw the sapf06 at (20, 0)

    planA[6] = tile_ind; // planA[6] stocke la position en Vram de Tile 06
    //tile_ind += num_tiles;




    // Testons encore en affichant toujours plus de tiles !
    VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, tile_ind), 28, 0, wt, ht);


    for(comptx=0 ; comptx<5; comptx++) // affichage de 5 tiles (0  4).
		{
        VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[1]), comptx*4+20, 4, wt, ht);
		}


	for(compty=0 ; compty<5; compty++) // de 0  24, ce qui fait 25 tiles (soit 5 ranges de 5 tiles).
		{
        for(comptx=0 ; comptx<5; comptx++) // de 0  24, ce qui fait 25 tiles (soit 5 ranges de 5 tiles).
            {
            compti = tbr01[compty][comptx]; // problem: le premier tile a toujour la valeur 0
            VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[compti]), comptx*4, compty*4+8, wt, ht); // lecture du tableau tbr01

//            VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[tbr01[compty][comptx]]), comptx*4, compty*4+8, wt, ht); // lecture du tableau tbr01
            }
        }

    dbtest=0; // test de l'appui sur le bouton start: affichage d'un tile.

    // *****************************
    // ***** Boucle principale *****
    // *****************************
	while(1)
	{
    // Test manuel avec votre belle joypad ergonomique...
    value = JOY_readJoypad(JOY_1); // valeur du joypad joueur 1

    //if (value & BUTTON_UP)
    //if (value & BUTTON_DOWN)
    //if (value & BUTTON_LEFT)
    //if (value & BUTTON_RIGHT)
    //if (value & BUTTON_A)
    //if (value & BUTTON_B)
    //if (value & BUTTON_C)
    if (dbtest == 0)
        {
        if (value & BUTTON_START)
            {
            dbtest=1;
            VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[1]), 28, 16, wt, ht); // l j'affiche
            }
		}
    if (dbtest == 1)
        {
        if (value & BUTTON_A)
            {
            dbtest=0;
            VDP_fillTileMapRectInc(APLAN, TILE_ATTR_FULL(PAL1, 0, 0, 0, planA[0]), 28, 16, wt, ht); // l je vide
            }
		}
	VDP_waitVSync();
	}
	return 0;
}

