//********************************//
//**         GBAlib v2.0        **//
//**  published in January 2009 **//
//**     by Martin BOUSQUET     **//
//** martin.bousquet@hotmail.fr **//
//********************************//

// TODO : trouver le bug du cliping vertical !!!!!!!!!!!!...????!!!??!!!!

#include "..\dev\gbalib2.h"	//  MODIFIER EN : #include "gbalib2.h"

#if defined GBA_ALL
#define GBA_MAP_ROUTINES
#define GBA_DRAW_MASKED_SPRITE
#define GBA_DRAW_INVERTED_SPRITE
#define GBA_COLLISION
#endif

#asm
._GBA_map_addr
GBA_map_addr:
	defw $0000

._GBA_tile_addr
GBA_tile_addr:
	defw $0000

._GBA_map_height
GBA_map_height:
	defw $0000

._GBA_map_width
GBA_map_width:
	defw $0000

._GBA_scroll_y
GBA_scroll_y:
	defw $0000
	
._GBA_scroll_x
GBA_scroll_x:
	defw $0000

._GBA_offset_x
GBA_offset_x:
	defb $0000

._GBA_offset_y
GBA_offset_y:
	defb $0000

GBA_offset_x_2:
	defb $0000

GBA_pixel_mask:
	defb $0000

GBA_save_byte:
	defb $0000

GBA_save_byte_2:
	defb $0000

#if defined GBA_MAP_ROUTINES
;-------------------------
; GBA HORIZONTAL SCROLLS |
;-------------------------

GBA_scroll_horizontal:
	push de
	ld bc,(GBA_scroll_x)
	add hl,bc
	ld de,(GBA_scroll_y)
	ld a,(GBA_map_width)
	call GBA_hl_plus_axde
	pop de
	ld bc,GBA_scroll_horizontal_next
	push bc
	push hl
	call GBA_find_tile
	ld bc,(GBA_offset_y)
	ld b,0
	add hl,bc
	ld a,(GBA_offset_y)
	sub 8
	neg
	jr GBA_col_1xa_loop

GBA_scroll_horizontal_next:
	ld b,7

GBA_scroll_horizontal_loop:
	push bc
	ld a,8
	call GBA_col_1xa
	pop bc
	djnz GBA_scroll_horizontal_loop
	ld a,(GBA_offset_y)
	or a
	ret z

GBA_col_1xa:
	push hl
	call GBA_find_tile	;  de and a unchanged

GBA_col_1xa_loop:
	push af
	ld a,(GBA_offset_x)
	and (hl)
	ex de,hl
	jr z,GBA_pixel_white
	ld a,(GBA_pixel_mask)
	or (hl)
	ld (hl),a

GBA_pixel_white:
	ld bc,12
	add hl,bc
	ex de,hl
	inc hl
	pop af
	dec a
	jr nz,GBA_col_1xa_loop
	pop hl
	ld bc,(GBA_map_width)
	add hl,bc
	ret

;-----------------------
; GBA VERTICAL SCROLLS |
;-----------------------

GBA_scroll_vertical:
	push de
	ld de,(GBA_scroll_x)
	add hl,de
	ld a,(GBA_map_width)
	ld de,(GBA_scroll_y)
	call GBA_hl_plus_axde
	pop de
	ld b,GBA_SCREEN_WIDTH+1

GBA_scroll_vertical_loop:
	push bc
	push hl
	call GBA_find_tile
	ld bc,(GBA_offset_y)
	ld b,0
	add hl,bc
	ld a,(hl)
	ld (de),a
	inc de
	pop hl
	inc hl
	pop bc
	djnz GBA_scroll_vertical_loop
	dec de
	ex de,hl
	ld a,(GBA_offset_x_2)
	or a
	ret z

GBA_scroll_vertical_loop_2:	
	push hl
	sla (hl)
	dec hl
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 1
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 2
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 3
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 4
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 5
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 6
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 7
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 8
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 9
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 10
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 11
	rl (hl)
	dec hl
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
	pop hl
	dec a
	jr nz,GBA_scroll_vertical_loop_2
	ret

;-------------------------------------------------------------------------;
;----------------------| GBA SPRITE ROUTINES |----------------------------;
;-------------------------------------------------------------------------;

GBA_find_tile:
	ld l,(hl)
	ld h,0
	ld bc,(GBA_tile_addr)
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,bc
	ret
#endif

#if defined GBA_DRAW_MASKED_SPRITE || defined GBA_DRAW_INVERTED_SPRITE
GBA_find_pixel:
	ld hl,GBA_FRONT_BUFFER_ORIGIN
	ld a,b
	and @111
	srl b
	srl b
	srl b
	ld d,0
	ld e,b
	add hl,de
	ld e,c
	ex de,hl
	add hl,hl
	add hl,hl
	ld b,h
	ld c,l
	add hl,hl
	add hl,bc
	add hl,de
	ret

GBA_clip_sprite:
	ld a,127
	cp b
	ret c
	ld a,GBA_SCREEN_WIDTH
	sub d
	add a,a
	add a,a
	add a,a
	sub b
	ret c
	ld a,c
	bit 7,a
	jr z,GBA_clip_sprite_next
	neg
	cp e
	ccf
	ret c
	add a,a
	push de
	ld e,d
	ld d,0
	call GBA_hl_plus_axde
	pop de
	or a
	ret

GBA_clip_sprite_next:
	ld a,GBA_SCREEN_HEIGHT
	add a,a
	add a,a
	add a,a
	dec a
	sub c
	ret c
	inc a
	cp e
	ret nc
	ld e,a
	or a
	ret
#endif

;-------------------------------------------------------------------------;
;---------------------| GBA USEFUL ROUTINES |-----------------------------;
;-------------------------------------------------------------------------;

GBA_hl_plus_axde:
	ld b,8

GBA_hl_plus_axde_loop:
	srl a
	jr nc,GBA_hl_plus_axde_next
	add hl,de

GBA_hl_plus_axde_next:
	sla e	; multiply de with 2
	rl d
	djnz GBA_hl_plus_axde_loop
	ret

;-------------------------------------------------------------------------;
;------------------------| OTHER ROUTINES |-------------------------------;
;-------------------------------------------------------------------------;

GBA_return_false:
	ld hl,0
	ret

GBA_return_true:
	ld hl,1
	ret

#if defined GBA_DRAW_MASKED_SPRITE || defined GBA_DRAW_INVERTED_SPRITE
GBA_get_sprite_parameters:
	ld a,(hl)
	push af
	inc hl
	inc hl
	push hl
	inc hl
	inc hl
	ld e,(hl)
	inc hl
	inc hl
	ld d,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	ld b,(hl)
	pop hl
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	pop af
	or a
	call nz,GBA_clip_sprite
	ret
#endif
#endasm

#if defined GBA_MAP_ROUTINES
char GBA_init_map(unsigned char GBA_scroll_x, unsigned char GBA_scroll_y, unsigned char GBA_map_width, unsigned char GBA_map_height, unsigned char *GBA_tile_addr, unsigned char *GBA_map_addr){
#asm
	ld hl,2
	add hl,sp
	push hl
	ld de,GBA_map_addr
	ld bc,12
	ldir
	pop hl
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a	; hl = *GBA_map_addr

GBA_init_map:
	ld de,(GBA_scroll_x)
	add hl,de
	ld de,(GBA_scroll_y)
	ld a,(GBA_map_width)
	call GBA_hl_plus_axde
	ld (GBA_offset_x_2),a
	ld (GBA_offset_y),a
	ld (GBA_offset_x),a
	set 7,a
	ld (GBA_offset_x),a
	ld de,GBA_BACK_BUFFER_ORIGIN
	ld b,GBA_SCREEN_WIDTH

GBA_init_map_row:
	ld c,GBA_SCREEN_HEIGHT
	push de
	push hl

GBA_init_map_col:
	push bc
	push hl
	call GBA_find_tile
	ld a,8

GBA_draw_8x8:
	ld b,(hl)
	inc hl
	ex de,hl
	ld (hl),b
	ld bc,12
	add hl,bc
	ex de,hl
	dec a
	jr nz,GBA_draw_8x8
	pop hl
	ld bc,(GBA_map_width)
	add hl,bc
	pop bc
	dec c
	jr nz,GBA_init_map_col
	pop hl
	inc hl
	pop de
	inc de
	djnz GBA_init_map_row
#endasm
}

void GBA_restore_map(void){
#asm
GBA_restore_map:
	ld hl,GBA_BACK_BUFFER_ORIGIN
	ld de,GBA_FRONT_BUFFER_ORIGIN
#if GBA_SCREEN_WIDTH == 12
	ld bc,GBA_SCREEN_WIDTH*8*GBA_SCREEN_HEIGHT
	ldir
#else
	ld b,8*GBA_SCREEN_HEIGHT	
GBA_restore_map_loop:
	push bc
#if GBA_SCREEN_WIDTH < 7
	push de
	push hl
	ld bc,GBA_SCREEN_WIDTH
	ldir
	ld bc,12
	pop hl
	add hl,bc
	ex de,hl
	pop add hl,bc
	ex de,hl
#else
	ld bc,GBA_SCREEN_WIDTH
	ldir
	inc hl
	inc de
#if GBA_SCREEN_WIDTH < 11
	inc hl
	inc de
#elif GBA_SCREEN_WIDTH < 10
	inc hl
	inc de
#elif GBA_SCREEN_WIDTH < 9
	inc hl
	inc de
#elif GBA_SCREEN_WIDTH < 8
	inc hl
	inc de
#endif
	pop bc
	djnz GBA_restore_map_loop	
#endif
#endif
#endasm
}

void GBA_scroll_right(void){
#asm
GBA_scroll_right:
	ld a,(GBA_map_width)
	ld hl,GBA_scroll_x
	sub (hl)
	cp GBA_SCREEN_WIDTH+1
	jp c,GBA_return_false
	ld hl,GBA_BACK_BUFFER_ORIGIN+GBA_SCREEN_WIDTH-1
	ld b,8*GBA_SCREEN_HEIGHT

GBA_scroll_right_loop:
	sla (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 1
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 2
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 3
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 4
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 5
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 6
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 7
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 8
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 9
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 10
	rl (hl)
	dec hl
#if GBA_SCREEN_WIDTH > 11
	rl (hl)
	dec hl
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
	ld de,GBA_SCREEN_WIDTH+12
	add hl,de
	djnz GBA_scroll_right_loop
	ld a,@00000001
	ld (GBA_pixel_mask),a
	ld de,GBA_BACK_BUFFER_ORIGIN+GBA_SCREEN_WIDTH-1
	ld hl,(GBA_map_addr)
	ld bc,GBA_SCREEN_WIDTH
	add hl,bc
	call GBA_scroll_horizontal
	ld a,(GBA_offset_x_2)
	inc a
	and @111
	ld (GBA_offset_x_2),a
	ld a,(GBA_offset_x)
	srl a
	ld (GBA_offset_x),a
	ret nc
	ld a,@10000000
	ld (GBA_offset_x),a
	ld hl,GBA_scroll_x
	inc (hl)
	or a
	ld hl,1
#endasm
}

void GBA_scroll_left(void){
#asm
GBA_scroll_left:
	ld a,(GBA_offset_x)
	cp @10000000
	jr nz,GBA_scroll_left_ok
	ld a,(GBA_scroll_x)
	sub 1
	jp c,GBA_return_false

GBA_scroll_left_ok:
	ld a,(GBA_offset_x_2)
	dec a
	and @111
	ld (GBA_offset_x_2),a
	ld a,(GBA_offset_x)
	add a,a
	jr nc,GBA_scroll_left_next
	ld a,@00000001
	ld hl,GBA_scroll_x
	dec (hl)

GBA_scroll_left_next:
	ld (GBA_offset_x),a
	ld hl,GBA_BACK_BUFFER_ORIGIN
	ld b,8*GBA_SCREEN_HEIGHT

GBA_scroll_left_loop:
	srl (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 1
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 2
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 3
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 4
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 5
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 6
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 7
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 8
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 9
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 10
	rr (hl)
	inc hl
#if GBA_SCREEN_WIDTH > 11
	rr (hl)
	inc hl
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#if GBA_SCREEN_WIDTH < 9
	ld de,12-GBA_SCREEN_WIDTH
	add hl,de
#else
#if GBA_SCREEN_WIDTH < 12
	inc hl
#if GBA_SCREEN_WIDTH < 11
	inc hl
#if GBA_SCREEN_WIDTH < 10
	inc hl
#endif
#endif
#endif
#endif
	djnz GBA_scroll_left_loop
	ld a,@10000000
	ld (GBA_pixel_mask),a
	ld hl,(GBA_map_addr)
	ld de,GBA_BACK_BUFFER_ORIGIN
	call GBA_scroll_horizontal
	or a
	ld hl,1
#endasm
}

void GBA_scroll_up(void){
#asm
GBA_scroll_up:
	ld a,(GBA_offset_y)
	or a
	jr nz,GBA_scroll_up_ok
	ld a,(GBA_scroll_y)
	sub 1
	jp c,GBA_return_false

GBA_scroll_up_ok:
	ld a,(GBA_offset_y)
	dec a
	and @111
	ld (GBA_offset_y),a
	cp 7
	jr nz,GBA_scroll_up_next
	ld hl,GBA_scroll_y
	dec (hl)

GBA_scroll_up_next:
	ld de,GBA_BACK_BUFFER_ORIGIN+GBA_SCREEN_WIDTH-1+(12*(8*GBA_SCREEN_HEIGHT-1))
	ld hl,GBA_BACK_BUFFER_ORIGIN+GBA_SCREEN_WIDTH-1+(12*(8*GBA_SCREEN_HEIGHT-2))
#if GBA_SCREEN_WIDTH == 12
	ld bc,8*GBA_SCREEN_HEIGHT*GBA_SCREEN_WIDTH
	lddr
#else
	ld b,8*GBA_SCREEN_HEIGHT

GBA_scroll_up_loop:
	push bc
	ld bc,GBA_SCREEN_WIDTH
#if GBA_SCREEN_WIDTH < 7
	push hl
	push de
	lddr
	pop hl
	ld bc,-12
	add hl,bc
	ex de,hl
	pop hl
	add hl,bc
#else
	lddr
	dec hl
	dec de
#if GBA_SCREEN_WIDTH < 11
	dec hl
	dec de
#if GBA_SCREEN_WIDTH < 10
	dec hl
	dec de
#if GBA_SCREEN_WIDTH < 9
	dec hl
	dec de
#if GBA_SCREEN_WIDTH < 8
	dec hl
	dec de
#endif
#endif
#endif
#endif
#endif
	pop bc
	djnz GBA_scroll_up_loop
#endif
	ld a,(GBA_BACK_BUFFER_ORIGIN+GBA_SCREEN_WIDTH)
	ld (GBA_save_byte),a
	ld hl,(GBA_map_addr)
	ld de,GBA_BACK_BUFFER_ORIGIN
	call GBA_scroll_vertical
	ld a,(GBA_save_byte)
	ld (hl),a
	ld hl,1
#endasm
}

void GBA_scroll_down(void){
#asm
GBA_scroll_down:
	ld a,(GBA_map_height)
	ld hl,GBA_scroll_y
	sub (hl)
	cp GBA_SCREEN_HEIGHT+1
	jp c,GBA_return_false
	ld de,GBA_BACK_BUFFER_ORIGIN
	ld hl,GBA_BACK_BUFFER_ORIGIN+12
#if GBA_SCREEN_WIDTH == 12
	ld bc,8*GBA_SCREEN_WIDTH*GBA_SCREEN_HEIGHT
	ldir
#else
	ld b,8*GBA_SCREEN_HEIGHT

GBA_scroll_down_loop:
	push bc
	ld bc,GBA_SCREEN_WIDTH
#if GBA_SCREEN_WIDTH < 8
	push hl
	push de
	ldir
	pop hl
	ld bc,12
	add hl,bc
	ex de,hl
	pop hl
	add hl,bc
#else
	ldir
	inc hl
	inc de
#if GBA_SCREEN_WIDTH < 11
	inc hl
	inc de
#if GBA_SCREEN_WIDTH < 10
	inc hl
	inc de
#if GBA_SCREEN_WIDTH < 9
	inc hl
	inc de
#endif
#endif
#endif
#endif
	pop bc
	djnz GBA_scroll_down_loop
#endif
	ld a,(de)
	ld (GBA_save_byte_2),a
	ld hl,-12
	add hl,de
	push hl
	ld hl,(GBA_map_addr)
	ld de,(GBA_map_width)
	ld a,GBA_SCREEN_HEIGHT
	call GBA_hl_plus_axde
	pop de
	call GBA_scroll_vertical
	ld a,(GBA_save_byte_2)
	ld (hl),a
	ld a,(GBA_offset_y)
	inc a
	and @111
	ld (GBA_offset_y),a
	jp nz,GBA_return_true
	ld hl,GBA_scroll_y
	inc (hl)
	or a
	ld hl,1
#endasm
}
#endif

#if defined GBA_DRAW_MASKED_SPRITE || defined GBA_DRAW_INVERTED_SPRITE
char GBA_draw_mask_sprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped){
#asm
	ld hl,2
	add hl,sp
	call GBA_get_sprite_parameters
	jp c,GBA_return_false

GBA_draw_mask_sprite:
	push hl
	push de
	call GBA_find_pixel
	pop bc
	ex de,hl
	pop hl

GBA_draw_mask_sprite_col:
	push bc
	push de

GBA_draw_mask_sprite_row:
	push bc
	ld b,(hl)
	ld c,@11111111
	inc hl
	push hl
	push af
	push af
	ld a,(hl)

GBA_inverted_opcode:
	nop
	nop
	ld h,a
	ld l,0
	pop af
	or a
	jr z,GBA_draw_mask_sprite_next

GBA_draw_mask_sprite_shift:
	scf
	rr b
	rr c
	srl h
	rr l
	dec a
	jr nz,GBA_draw_mask_sprite_shift

GBA_draw_mask_sprite_next:
	ex de,hl
	ld a,(hl)
	and b
	or d
	ld (hl),a
	inc hl
	ld a,(hl)
	and c
	or e
	ld (hl),a
	ex de,hl
	pop af
	pop hl
	inc hl
	pop bc
	djnz GBA_draw_mask_sprite_row
	ex de,hl
	pop hl
	ld bc,12
	add hl,bc
	ex de,hl
	pop bc
	dec c
	jr nz,GBA_draw_mask_sprite_col
#endasm
}
#endif

#if defined GBA_DRAW_INVERTED_SPRITE
char GBA_draw_inverted_sprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped){
#asm
	ld hl,2
	add hl,sp
	call GBA_get_sprite_parameters
	jp c,GBA_return_false

GBA_draw_inverted_sprite:
	push hl
	ld hl,GBA_inverted_opcode
	ld (hl),$2f			; opcode for 'cpl'
	inc hl
	ld (hl),$a8			; opcode for 'xor b'
	pop hl
	call GBA_draw_mask_sprite
	ld hl,GBA_inverted_opcode
	ld (hl),0
	inc hl
	ld (hl),0
#endasm
}
#endif

#if defined GBA_COLLISION
char GBA_collision(unsigned char x, unsigned char y){
#asm
	ld hl,2
	add hl,sp
	ld c,(hl)
	inc hl
	inc hl
	ld b,(hl)

GBA_collision:
	ld hl,(GBA_map_addr)
	ld de,(GBA_scroll_x)
	add hl,de
	ld a,(GBA_offset_x_2)
	add a,b
	sra a
	sra a
	sra a
	ld e,a
	ld d,0
	bit 7,a
	jr z,GBA_collision_next
	dec d

GBA_collision_next:
	add hl,de
	ld a,(GBA_offset_y)
	add a,c
	sra a
	sra a
	sra a
	ld b,0
	ld c,a
	bit 7,a
	jr z,GBA_collision_next2
	dec b

GBA_collision_next2:
	ex de,hl
	ld hl,(GBA_scroll_y)
	add hl,bc
	ex de,hl
	ld a,(GBA_map_width)
	call GBA_hl_plus_axde
	ld l,(hl)
	ld h,0
#endasm
}
#endif