//********************************//
//**         GBAlib v2.0        **//
//**  published in January 2009 **//
//**     by Martin BOUSQUET     **//
//** martin.bousquet@hotmail.fr **//
//********************************//

//****************************************************//
//** Uncomment #define of functions you want to use **//
//****************************************************//

//#define GBA_ALL	//Auto define all functions
#define GBA_MAP_ROUTINES
#define GBA_DRAW_MASKED_SPRITE
#define GBA_DRAW_INVERTED_SPRITE
#define GBA_COLLISION

//***********************//
//** GBAlib2 constants **//
//***********************//

#define GBA_FRONT_BUFFER	graph_mem
#define GBA_BACK_BUFFER	saferam1
#define GBA_SCREEN_WIDTH	12
#define GBA_SCREEN_HEIGHT	8
#define GBA_SCREEN_OFFSET_X	0
#define GBA_SCREEN_OFFSET_Y	0
#define GBA_FRONT_BUFFER_ORIGIN	GBA_FRONT_BUFFER+GBA_SCREEN_OFFSET_X+(12*GBA_SCREEN_OFFSET_Y)
#define GBA_BACK_BUFFER_ORIGIN	GBA_BACK_BUFFER+GBA_SCREEN_OFFSET_X+(12*GBA_SCREEN_OFFSET_Y)
#define GBA_NO_CLIP_SPRITE	0
#define GBA_CLIP_SPRITE	1

//***********************//
//** GBAlib2 variables **//
//***********************//

extern unsigned char GBA_map_addr;
extern unsigned char GBA_tile_addr;
extern unsigned char GBA_map_height;
extern unsigned char GBA_map_width;
extern unsigned char GBA_scroll_y;
extern unsigned char GBA_scroll_x;
extern unsigned char GBA_offset_x;
extern unsigned char GBA_offset_y;

//**************************//
//** Functions prototypes **//
//**************************//

char GBA_init_map(unsigned char GBA_scroll_x, unsigned char GBA_scroll_y, unsigned char GBA_map_width, unsigned char GBA_map_height, unsigned char *GBA_tile_addr, unsigned char *GBA_map_addr);
void GBA_restore_map(void);
void GBA_scroll_right(void);
void GBA_scroll_left(void);
void GBA_scroll_up(void);
void GBA_scroll_down(void);
char GBA_draw_mask_sprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped);
char GBA_draw_inverted_sprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite, unsigned char is_clipped);
char GBA_collision(unsigned char x, unsigned char y);