#define bcall(romcall);	asm("rst rbr_call\ndefw "#romcall);

#define screen_w	96
#define screen_h	64

// SAFE MEMORY AREAS
// saferam1 = 768 bytes (apdram)
// saferam2 = 531 bytes (statram)
// saferam3 = 128 bytes (textmem)
// saferam4 = 66 bytes (ops)
// saferam5 = 10 bytes (imathptrs)

// DIRECT INPUT KEY GROUPS
#define dkey_group_1	0xfe
#define dkey_group_2	0xfd
#define dkey_group_3	0xfb
#define dkey_group_4	0xf7
#define dkey_group_5	0xef
#define dkey_group_6	0xdf
#define dkey_group_7	0xbf

// DIRECT INPUT KEY VALUES
// GROUP 1
#define dkey_up	247
#define dkey_right	251
#define dkey_left	253
#define dkey_down	254
// GROUP 2
#define dkey_clear	191
#define dkey_power	223
#define dkey_div	239
#define dkey_mul	247
#define dkey_sub	251
#define dkey_add	253
#define dkey_enter	254
// GROUP 3
#define dkey_vars	191
#define dkey_tan	223
#define dkey_rparen	239
#define dkey_9	247
#define dkey_6	251
#define dkey_3	253
#define dkey_chs	254
// GROUP 4
#define dkey_stat	127
#define dkey_prgm	191
#define dkey_cos	223
#define dkey_lparen	239
#define dkey_8	247
#define dkey_5	251
#define dkey_2	253
#define dkey_decpnt	254
// GROUP 5
#define dkey_graphvar	127
#define dkey_matrix	191
#define dkey_apps	dkey_matrix
#define dkey_sin	223
#define dkey_comma	239
#define dkey_7	247
#define dkey_4	251
#define dkey_1	253
#define dkey_0	254
// GROUP 6
#define dkey_alpha	191
#define dkey_math	223
#define dkey_recip	239
#define dkey_square	247
#define dkey_log	251
#define dkey_ln	253
#define dkey_store	254
// GROUP 7
#define dkey_del	127
#define dkey_mode	191
#define dkey_2nd	223
#define dkey_yequ	239
#define dkey_windows	247
#define dkey_zoom	251
#define dkey_trace	253
#define dkey_graph	254

// GETCSC CODES
#define skey_down	0x01
#define skey_left	0x02
#define skey_right	0x03
#define skey_up	0x04
#define skey_enter	0x09
#define skey_add	0x0a
#define skey_sub	0x0b
#define skey_mul	0x0c
#define skey_div	0x0d
#define skey_power	0x0e
#define skey_clear	0x0f
#define skey_chs	0x11
#define skey_3	0x12
#define skey_6	0x13
#define skey_9	0x14
#define skey_rparen	0x15
#define skey_tan	0x16
#define skey_vars	0x17
#define skey_decpnt	0x19
#define skey_2	0x1a
#define skey_5	0x1b
#define skey_8	0x1c
#define skey_lparen	0x1d
#define skey_cos	0x1e
#define skey_prgm	0x1f
#define skey_stat	0x20
#define skey_0	0x21
#define skey_1	0x22
#define skey_4	0x23
#define skey_7	0x24
#define skey_comma	0x25
#define skey_sin	0x26
#define skey_matrix	0x27
#define skey_apps	skey_matrix
#define skey_graphvar	0x28
#define skey_store	0x2a
#define skey_ln	0x2b
#define skey_log	0x2c
#define skey_square	0x2d
#define skey_recip	0x2e
#define skey_math	0x2f
#define skey_alpha	0x30
#define skey_graph	0x31
#define skey_trace	0x32
#define skey_zoom	0x33
#define skey_window	0x34
#define skey_yequ	0x35
#define skey_2nd	0x36
#define skey_mode	0x37
#define skey_del	0x38

// RST ROUTINES
#asm
defc rop1toop2 = $8
defc rfindsym = $10
defc rpushrealo1 = $18
defc rmov9toop1 = $20
defc rbr_call = $28
defc rfpadd = $30
defc brt_jump0 = $50
#endasm

// PROGRAM TOKENS
#define tasm	$6a
#define tasmcomp	$6b
#define tasmprgm	$6c
#define tasmcmp	$6d
#define t2bytetok	$bb
#define tprog	$5f

// HARDWARE PORTS
#define plink	$0
#define pkey	$1
#define pstatus	$2
#define pintmask	$3
#define pintid	$4
#define pmmaptmrfreq	$4
#define pmpagec	$5
#define plnkastberead	$5
#define pmpagea	$6
#define pmpageb	$7
#define plnkastseenable	$8
#define plnkastsestatus	$9
#define plnkastseinbuf	$a
#define plnkastsecfg	$a
#define plnkastsercvtimeout	$b
#define plnkastsesndtimeout	$c
#define plnkastseoutbuf	$d
#define pmpageahighbits	$e
#define pmpagebhighbits	$f
#define plcdcmd	$10
#define plcddata	$11
#define pprotctrl	$14
#define pasicid	$15
#define pcpuspeed	$20
#define pflashtyperammask	$21
#define pflashexeclowerlimit	$22
#define pflashexecupperlimit	$23
#define pflashexecexecoverride	$24
#define pramexeclowerlimit	$25
#define pramexecupperlimit	$26
#define pblockmremapc	$27
#define pblockmremapb	$28
#define plcddelay0	$29
#define plcddelay1	$2a
#define plcddelay2	$2b
#define plcddelay3	$2c
#define punknown2d	$2d
#define pmemdelay	$2e
#define plcdgendelay	$2f
#define ptmr1freq	$30
#define ptmr1cfg	$31
#define ptmr1count	$32
#define ptmr2freq	$33
#define ptmr2cfg	$34
#define ptmr2count	$35
#define ptmr3freq	$36
#define ptmr3cfg	$37
#define ptmr3count	$38
#define pusbunkoldflg	$39
#define pusbunkoldflg2	$3a
#define prtcctrl	$40
#define prtcset0	$41
#define prtcset1	$42
#define prtcset2	$43
#define prtcset3	$44
#define prtc0	$45
#define prtc1	$46
#define prtc2	$47
#define prtc3	$48

// ERROR FLAGS
#define app_push_errorh	$59
#define app_pop_errorh	$5c
#define e_overflow	$1
#define e_divby0	$2
#define e_singularmat	$3
#define e_domain	$4
#define e_increment	$5
#define e_break	$6
#define e_nonreal	$7
#define e_syntax	$8
#define e_datatype	$9
#define e_argument	$a
#define e_dimmismatch	$b
#define e_dimension	$c
#define e_undefined	$d
#define e_memory	$e
#define e_invalid	$f
#define e_illegalnest	$10
#define e_bound	$11
#define e_graphrange	$12
#define e_zoom	$13
#define e_label	$14
#define e_stat	$15
#define e_solver	$16
#define e_singularity	$17
#define e_signchange	$18
#define e_iterations	$19
#define e_badguess	$1a
#define e_statplo	$1b
#define e_toltoosmall	$1c
#define e_reserved	$1d
#define e_mode	$1e
#define e_lnkerr	$1f
#define e_lnkmemerr	$20
#define e_lnktranserr	$21
#define e_lnkduperr	$22
#define e_lnkmemfull	$23
#define e_unknown	$24
#define e_scale	$25
#define e_idnotfound	$26
#define e_nomode	$27
#define e_validation	$28
#define e_length	$29
#define e_application	$2a
#define e_apperr1	$2b
#define e_apperr2	$2c
#define e_expiredapp	$2d
#define e_badadd	$2e
#define e_archived	$2f
#define e_version	$30
#define e_archfull	$31
#define e_variable	$32
#define e_duplicate	$33

// OTHER FLAGS
#define newdispf	$8	//derivative mode flags
#define preclrformode	$		//1=help blink on mode screen
#define allowprogtokens	$1		//1=allow programming tokens to be parsed in basic programs
//
#define trigflags	0	// iy offset value
#define trigdeg  	2
//
#define plotflags	2	// iy offset value
#define plotloc  	1
#define plotdisp 	2
//
#define grfmodeflags	2	// iy offset value
#define grffuncm 	4
#define grfpolarm	5
#define grfparamm	6
#define grfrecurm	7
//
#define graphflags  	3	// iy offset value
#define graphdraw	0
#define graphcursor 	2
//
#define grfdbflags  	4	// iy offset value
#define grfdot   	0
#define grfsimul 	1
#define grfgrid  	2
#define grfpolar 	3
#define grfnocoord  	4
#define grfnoaxis	5
#define grflabel 	6
//
#define textflags	5	// iy offset value
#define texterasebelow	1
#define textscrolled	2
#define textinverse 	3
//
#define onflags  	9	// iy offset value
#define onrunning	3
#define oninterrupt 	4
//
#define statflags	9	// iy offset value
#define statsvalid  	6
//
#define fmtflags 	10          // iy offset value
#define fmtexponent 	0
#define fmteng   	1
//
#define nummode  	10          // iy offset value
#define fmtreal  	5
#define fmtrect  	6
#define fmtpolar 	7
//
#define curflags 	12          // iy offset value
#define curable  	2
#define curon    	3
#define curlock  	4
//
#define appflags 	13          // iy offset value
#define apptextsave 	1
#define appautoscroll	2
//
#define plotflag2	17          // iy offset value
#define expr_param  	3
#define expr_writing	4
//
#define indicflags  	18          // iy offset value
#define indicrun 	0
#define indiconly	2
//
#define shiftflags  	18          // iy offset value
#define shift2nd 	3
#define shiftalpha  	4
#define shiftalock  	6
//
#define tblflags 	19          // iy offset value
#define autofill 	4
#define autocalc 	5
//
#define sgrflags 	20          // iy offset value
#define grfsplit 	0
#define vertsplit	1
#define write_on_graph	4
#define textwrite	7
//
#define asm_flag1	33          // iy offset value
#define asm_flag1_0 	0
#define asm_flag1_1 	1
#define asm_flag1_2 	2
#define asm_flag1_3 	3
#define asm_flag1_4 	4
#define asm_flag1_5 	5
#define asm_flag1_6 	6
#define asm_flag1_7 	7
//
#define asm_flag2	34          // iy offset value
#define asm_flag2_0 	0
#define asm_flag2_1 	1
#define asm_flag2_2 	2
#define asm_flag2_3 	3
#define asm_flag2_4 	4
#define asm_flag2_5 	5
#define asm_flag2_6 	6
#define asm_flag2_7 	7
//
#define asm_flag3	35          // iy offset value
#define asm_flag3_0 	0
#define asm_flag3_1 	1
#define asm_flag3_2 	2
#define asm_flag3_3 	3
#define asm_flag3_4 	4
#define asm_flag3_5 	5
#define asm_flag3_6 	6
#define asm_flag3_7 	7
//
#define hookflags4	$36
#define tracehookactive	$
#define parserhookactive	$1
#define appchangehookactive	$2
#define catalog1hookactive	$3
#define helphookactive	$4
#define cxredisphookactive	$5
#define menuhookactive	$6
#define silentlinkhookactive	$7

// RAM AREAS
#define libstart	$4
#define imathptrs	$8251
#define contrast	$8447
#define currow	$844b
#define curcol	$844c
#define op1	$8478
#define saferam4	op1
#define op2	$8483
#define op3	$848e
#define op4	$8499
#define op5	$84a4
#define op6	$84af
#define imathptr1	$84d3
#define saferam5	imathptr1
#define imathptr2	$84d5
#define imathptr3	$84d7
#define imathptr4	$84d9
#define imathptr5	$84db
#define textmem	$8508
#define textshadow	textmem
#define saferam3	textshadow
#define statram	$858f
#define saferam2	statram
#define pencol	$86d7
#define penrow	$86d8
#define usermemoff	$89ec
#define curgy	$8d18
#define curgx	$8d19
#define plotsscreen	$9340
#define graph_mem	plotsscreen
#define gbuf	graph_mem
#define grbuf	gbuf
#define basic_prog	$9652
#define parse_var	basic_prog
#define basic_start	$965b
#define nextparsebyte	$965d
#define cmdshad	$966e
#define ptemp	$982e
#define progptr	$9830
#define vat	progptr
#define appbackupscreen	$9872	// 768 bytes
#define apdram	appbackupscreen
#define saferam1	apdram
#define sram	saferam1
#define savesscreen	sram
#define parserhookptr	$9bac
#define progstart	$9d95
#define symtable	$fe6e

// ROM CALLS
#define _ldhlind	$4009
#define _cphlde	$400c
#define _divhlby10	$400f
#define _divhlbya	$4012
#define _getcsc	$4018
#define _jforcecmdnochar	$4027
#define _lcdbusy	$4051
#define _fpadd	$4072
#define _fpmult	$4084
#define _fpdiv	$4099
#define _int	$40a5
#define _sin	$40bd
#define _hltimes9	$40f9
#define _cpop1op2	$4111
#define _op3toop4	$4114
#define _op1toop4	$4117
#define _op2toop4	$411a
#define _op4toop2	$411d
#define _op3toop2	$4120
#define _op1toop3	$4123
#define _op5toop2	$4126
#define _op5toop6	$4129
#define _op5toop4	$412c
#define _op1toop2	$412f
#define _op6toop2	$4132
#define _op6toop1	$4135
#define _op4toop1	$4138
#define _op5toop1	$413b
#define _op3toop1	$413e
#define _op6toop5	$4141
#define _op4toop5	$4144
#define _op3toop5	$4147
#define _op2toop5	$414a
#define _op2toop6	$414d
#define _op1toop6	$4150
#define _op1toop5	$4153
#define _op2toop1	$4156
#define _op2toop3	$416e
#define _op4toop3	$4171
#define _op5toop3	$4174
#define _op4toop6	$4177
#define _mov9toop1	$417a
#define _op1set4	$419e
#define _op1set1	$419b
#define _op1set3	$41a1
#define _op3set2	$41a4
#define _op1set2	$41a7
#define _op5set0	$41b3
#define _op1set0	$41bf
#define _zeroop1	$41c5
#define _zeroop2	$41c8
#define _zeroop3	$41cb
#define _op5exop6	$420a
#define _htimesl	$4276
#define _op1exop4	$421c
#define _memfree	$42e5
#define _chksysvar	$42f1
#define _chkfindsym	_chksysvar
#define _findsym	$42f4
#define _insertmem	$42f7
#define _enoughram	$42fd
#define _enoughmem	_enoughram
#define _createprog	$4339
#define _delvar	$4351
#define _deletemem	$4357
#define _delmem	_deletemem
#define _popop1	$437e
#define _poprealo6	$4381
#define _poprealo5	$4384
#define _poprealo4	$4387
#define _poprealo3	$438a
#define _poprealo2	$438d
#define _poprealo1	$4390
#define _pushrealo6	$43ab
#define _pushrealo5	$43ae
#define _pushrealo4	$43b1
#define _pushrealo3	$43b4
#define _pushrealo2	$43b7
#define _pushrealo1	$43ba
#define _pushop1	$43c9
#define _errundefined	$44b6
#define _errmemory	$44b9
#define _jerror	$44d7
#define _putmap	$4501
#define _putc	$4504
#define _disphl	$4507
#define _puts	$450a
#define _putps	$4510
#define _newline	$452e
#define _clrlcdf	$4540
#define _clrlcdfull	_clrlcdf
#define _clrscr	$4543
#define _clrscrf	$4546
#define _clrscrnfull _clrscrf
#define _cleartextshad	$454c
#define _homeup	$4558
#define _vputmap	$455e
#define _vputs	$4561
#define _vputsn	$4564
#define _indicatoron	$456d
#define _indicatoroff	$4570
#define _saveoscreen	$45fa
#define _getk	$4744
#define _setxxop1	$478c
#define _setxxop2	$478f
#define _setxxxxop2	$4792
#define _cline	$4798
#define _darkline	$47dd
#define _darkpoint	$47f2
#define _iline	$47e0
#define _ipoint	$47e3
#define _copygbuf	$486a
#define _grbufcpy	_copygbuf
#define _getkey	$4972
#define _parseinp	$4a9b
#define _convop1	$4aef
#define _cleargbuf	$4bd0
#define _grbufclr	_cleargbuf
#define _dispop1a	$4bf7
#define _executenewprgm	$4c3c
#define _createappvar	$4e6a
#define _createprotprog	$4e6d
#define _executeprgm	$4e7c
#define _getbytepaged	$4f54
#define _delvararc	$4fc6
#define _archunarch	$4fd8
#define _flashtoram	$5017
#define _setparserhook	$5026
#define _disableparserhook	$5029

// DATA TYPE EQUATES
#define realobj	$
#define listobj	$1
#define matobj	$2
#define equobj	$3
#define strngobj	$4
#define progobj	$5
#define protprogobj	$6
#define pictobj	$7
#define gdbobj	$8
#define unknownobj	$9
#define unknownequobj	$a
#define newequobj	$b
#define cplxobj	$c
#define clistobj	$d
#define undefobj	$e
#define windowobj	$f
#define zstoobj	$10
#define tblrngobj	$11
#define lcdobj	$12
#define backupobj	$13
#define appobj	$14	//application, only used in menus/link
#define appvarobj	$15	//application variable
#define tempprogobj	$16 //program, home deletes when finished
#define groupobj	$17 //group.