#include "..\dev\tilib.h"	//  MODIFIER EN : #include "tilib.h"

#if defined TL_ALL
#define TL_RANDOM
#define TL_DELAY
#define TL_SMALL_SPRITE
#define TL_LARGE_SPRITE
#define TL_GBUF_TO_LCD
#define TL_DIRECT_INPUT
#define TL_GET_KEY
#define TL_GET_PIXEL
#define TL_RECTANGLE_FILLED
#define TL_TEXT
#endif

#if defined TL_RANDOM
#asm
TL_random_data:
	defw $0000
#endasm
char __FASTCALL__ TL_random(unsigned char max){
#asm
	ld b,l

TL_random:
	push hl
	push de
	ld hl,(TL_random_data)
	ld a,r
	ld d,a
	ld e,(hl)
	add hl,de
	add a,l
	xor h
	ld (TL_random_data),hl
	sbc hl,hl
	ld e,a
	ld d,h
TL_random_loop:
	add hl,de
	djnz TL_random_loop
	ld a,h
	pop de
	pop hl
	ld h,0
	ld l,a
#endasm
}
#endif

#if defined TL_DELAY
char __FASTCALL__ TL_delay(unsigned char delay){
#asm
	ld b,l
	ei

delay_loop:
	halt
	djnz delay_loop
	di
#endasm
}
#endif

#if defined TL_SMALL_SPRITE
char TL_small_sprite(unsigned char x, unsigned char y, unsigned char height, unsigned char *sprite){
#asm
; Sprite routine by Joe Wingbermuehle
	ld hl,2
	add hl,sp
	ld e,(hl)
	inc hl
	ld d,(hl)
	push de
	pop ix
	inc hl
	ld b,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	ld a,(hl)
	ld l,c

TL_small_sprite:
	ld e,l
	ld h,$00
	ld d,h
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	and $07
	ld c,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,gbuf
	add hl,de

TL_small_sprite_loop_1:
	ld d,(ix)
	ld e,$00
	ld a,c
	or a
	jr z,TL_small_sprite_skip_1

TL_small_sprite_loop_2:
	srl d
	rr e
	dec a
	jr nz,TL_small_sprite_loop_2

TL_small_sprite_skip_1:
	ld a,(hl)
	xor d
	ld (hl),a
	inc hl
	ld a,(hl)
	xor e
	ld (hl),a
	ld de,$0b
	add hl,de
	inc ix
	djnz TL_small_sprite_loop_1
#endasm
}
#endif

#if defined TL_LARGE_SPRITE
char TL_large_sprite(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char *sprite){
#asm
; Sprite routine by Joe Wingbermuehle
	ld hl,2
	add hl,sp
	ld e,(hl)
	inc hl
	ld d,(hl)
	push de
	pop ix
	inc hl
	ld b,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	push hl
	inc hl
	inc hl
	ld a,(hl)
	pop hl
	ld l,(hl)

TL_large_sprite:
	di
	ex af,af
	ld a,c
	push af
	ex af,af
	ld e,l
	ld h,0
	ld d,h
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	and $07
	ld c,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,gbuf
	add hl,de

TL_large_sprite_loop_1:
	push hl

TL_large_sprite_loop_2:
	ld d,(ix)
	ld e,0
	ld a,c
	or a
	jr z,TL_large_sprite_skip_1

TL_large_sprite_loop_3:
	srl d
	rr e
	dec a
	jr nz,TL_large_sprite_loop_3

TL_large_sprite_skip_1:
	ld a,(hl)
	xor d
	ld (hl),a
	inc hl
	ld a,(hl)
	xor e
	ld (hl),a
	inc ix
	ex af,af
	dec a
	push af
	ex af,af
	pop af
	jr nz,TL_large_sprite_loop_2
	pop hl
	pop af
	push af
	ex af,af
	ld de,$0c
	add hl,de
	djnz TL_large_sprite_loop_1
	pop af
#endasm
}
#endif

#if defined TL_GBUF_TO_LCD || defined TL_TEXT
void TL_gbuf_to_lcd(void){
#asm
; Fast copy routine by Joe Wingbermuehle
TL_gbuf_to_lcd:
	di
	ld a,$80
	out (plcdcmd),a
	ld hl,gbuf-12-(-(12*64)+1)
	ld a,$20
	ld c,a
	inc hl
	dec hl

TL_gbuf_to_lcd_again:
	ld b,64
	inc c
	ld de,-(12*64)+1
	out (plcdcmd),a
	add hl,de
	ld de,10

TL_gbuf_to_lcd_loop:
	add hl,de
	inc hl
	inc hl
	inc de
	ld a,(hl)
	out (plcddata),a
	dec de
	djnz TL_gbuf_to_lcd_loop
	ld a,c
	cp $2b+1
	jr nz,TL_gbuf_to_lcd_again
#endasm
}
#endif

#if defined TL_DIRECT_INPUT
char __FASTCALL__ TL_direct_input(unsigned char keygroup){
#asm
	ld a,l	; a = keygroup
	out (pkey),a
	in a,(pkey)
	ld h,0
	ld l,a		; hl is the return parameter
#endasm
}
#endif

#if defined TL_GET_KEY
void TL_get_key(void){
#asm
TL_get_key_loop:
	rst rbr_call
	defw _getcsc
	or a
	jr z,TL_get_key_loop
	ld h,0
	ld l,a
#endasm
}
#endif

#if defined TL_GET_PIXEL
char TL_get_pixel(unsigned char x, unsigned char y){
#asm
	ld hl,2
	add hl,sp
	ld e,(hl)	; e=y
	inc hl
	inc hl
	ld a,(hl)	; a=x
	ld l,e

TL_get_pixel:
	ld h,0
	ld d,h
	ld e,l
	add hl,hl
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,plotsscreen
	add hl,de
	and 7
	ld b,a
	ld a,$80
	jr z,TL_test_pixel

TL_get_pixel_loop:
	rrca
	djnz TL_get_pixel_loop

TL_test_pixel:
	and (hl)
	or a
	jr nz,TL_get_pixel_quit
	ld hl,0

TL_get_pixel_quit:
#endasm
}
#endif

#if defined TL_RECTANGLE_FILLED
char TL_rectangle_filled(unsigned char x, unsigned char y, unsigned char width, unsigned char height, unsigned char color){
#asm
; Rectangle filled routine by chickendude
#define GBUF_LSB	$40
#define GBUF_MSB	$93
	ld hl,2
	add hl,sp
	push hl
	inc hl
	inc hl
	ld b,(hl)
	inc hl
	inc hl
	ld c,(hl)
	inc hl
	inc hl
	ld e,(hl)
	inc hl
	inc hl
	ld d,(hl)
	pop hl
	ld a,(hl)
	cp 2
	jr z,TL_rectangle_filled_xor
	or a
	jr nz,TL_rectangle_filled_solid

;b = height
;c = width
;d = starting x
;e = starting y

TL_rectangle_filled_white:
	call TL_rectangle_filled_solid

TL_rectangle_filled_xor:
	ld a,$ae		;xor (hl)
	jr TL_rectangle_filled_2

TL_rectangle_filled_solid:
	ld a,$b6		;or (hl)

TL_rectangle_filled_2:
	push de
	push bc
	ld (TL_rectangle_filled_or_xor),a	;use smc for xor/solid fill
	ld a,d			;starting x
	and $7			;what bit do we start on?
	ex af,af
	ld a,d			;starting x
	ld l,e			;ld hl,e
	ld h,0			; ..
	ld d,h			;set d = 0
	add hl,de		;starting y * 12
	add hl,de		;x3
	add hl,hl		;x6
	add hl,hl		;x12
	rra				;a = x coord / 8
	rra				;
	rra				;
	and @00011111	;starting x/8 (starting byte in gbuf)
	add a,GBUF_LSB
	ld e,a			;
	ld d,GBUF_MSB	;
	add hl,de		;hl = offset in gbuf
	ex af,af
	ld d,a
	ld a,@10000000
	jr z,TL_rectangle_filled_4

TL_rectangle_filled_3:
	rra
	dec d
	jr nz,TL_rectangle_filled_3

TL_rectangle_filled_4:
	ld e,12

TL_rectangle_filled_loop_x:
	push af
	push bc
	push hl
	ld c,a

TL_rectangle_filled_loop_y:
TL_rectangle_filled_or_xor:
	or (hl)			;smc will modify this to or/xor
	ld (hl),a
	ld a,c
	add hl,de
	djnz TL_rectangle_filled_loop_y
	pop hl
	pop bc
	pop af
	rrca
	jr nc,TL_rectangle_filled_5
	inc hl

TL_rectangle_filled_5:
	dec c
	jr nz,TL_rectangle_filled_loop_x

TL_rectangle_filled_end:
	pop bc
	pop de
#endasm
}
#endif

#if defined TL_TEXT
#asm
TL_text_wait:
	defb 0
TL_text_typing_speed:
	defb 0
TL_text_default_col:
	defb 0
#endasm
char TL_text(unsigned char x, unsigned char y, unsigned char *text, unsigned char is_typed, unsigned char typing_speed){
#asm
; Text routine by chickendude
;0		($00)	= end of a dialogue or end of a menu option
;NEWX	($ff)	= new X coordinate
;NEWY	($fe)	= new Y coordinate
;NEWXY	($fd)	= new XY coordinates
;NEWL	($fc)	= new line
;BRK	($fb)	= pause
	ld hl,2
	add hl,sp
	set textwrite,(iy+sgrflags)
	ld a,(hl)
	ld (TL_text_typing_speed),a
	inc hl
	inc hl
	ld a,(hl)
	ld (TL_text_wait),a
	inc hl
	inc hl
	push hl
	inc hl
	inc hl
	ld d,(hl)
	inc hl
	inc hl
	ld e,(hl)
	pop hl
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a

TL_text_start:
	ld (pencol),de
	ld a,e
	ld (TL_text_default_col),a

TL_text_loop:
	ld de,(pencol)
	ld a,(hl)
	or a
	jp z,TL_gbuf_to_lcd
	cp TL_BRK
	jr c,TL_text_not_special
	ld bc,TL_text_loop
	push bc
	push hl
	ld hl,TL_text_routine_table
	cpl
	add a,a
	ld c,a
	ld b,0
	add hl,bc
	ld c,(hl)
	inc hl
	ld b,(hl)
	pop hl			;hl = adress in the string
	push bc			;bc = routine adress where we want to jump
	ret

TL_text_not_special:
	push de
	push ix
	rst rbr_call
	defw _vputmap
	pop ix
	pop de
	ld a,(TL_text_wait)	;= 0 if no delay, != 0 else
	or a
	call nz,TL_text_delay
	inc hl
	jr TL_text_loop

TL_text_delay:
	di
	exx
	ld a,dkey_group_6	;check ALPHA to skip text typing
	out (pkey),a
	in a,(pkey)
	bit 7,a
	jr nz,TL_text_delay_skip
	xor a
	ld (TL_text_wait),a

TL_text_delay_skip:
	ld a,(TL_text_typing_speed)
	ld b,a

TL_text_delay_loop:
	push bc
	call nc,TL_gbuf_to_lcd
	pop bc
	djnz TL_text_delay_loop
	exx
	ret

TL_text_routine_table:
	defw TL_text_new_x
	defw TL_text_new_y
	defw TL_text_new_x_y
	defw TL_text_new_line
	defw TL_text_pause

TL_text_new_x:
	inc hl
	ld e,(hl)
	ld (pencol),de
	inc hl
	ret

TL_text_new_x_y:
	call TL_text_new_x

TL_text_new_y:
	inc hl
	ld d,(hl)
	ld (pencol),de
	inc hl
	ret

TL_text_new_line:
	ld a,d
	add a,6	;penrow+6
	ld d,a
	ld a,(TL_text_default_col)
	ld e,a
	ld (pencol),de
	inc hl
	ld a,(hl)
	ret

TL_text_pause:
	push hl
	call TL_gbuf_to_lcd

TL_text_pause_loop:
	ei
	halt
	di
	ld a,dkey_group_7	;check 2nd
	out (pkey),a
	in a,(pkey)
	bit 5,a
	jr nz,TL_text_pause_loop

TL_text_load_next:
	ld hl,TL_text_wait
	inc (hl)
	in a,(pkey)
	inc a
	jr nz,TL_text_load_next
	pop hl
	inc hl					;skip BRK
	ret
#endasm
}
#endif