/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.bencode;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.klomp.snark.bencode.InvalidBEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BEValue {
    private final Object value;

    public BEValue(byte[] value) {
        this.value = value;
    }

    public BEValue(Number value) {
        this.value = value;
    }

    public BEValue(List value) {
        this.value = value;
    }

    public BEValue(Map value) {
        this.value = value;
    }

    public String getString() throws InvalidBEncodingException {
        try {
            return new String(this.getBytes(), "UTF-8");
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError(uee.toString());
        }
    }

    public byte[] getBytes() throws InvalidBEncodingException {
        try {
            return (byte[])this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public Number getNumber() throws InvalidBEncodingException {
        try {
            return (Number)this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public int getInt() throws InvalidBEncodingException {
        return this.getNumber().intValue();
    }

    public long getLong() throws InvalidBEncodingException {
        return this.getNumber().longValue();
    }

    public List<BEValue> getList() throws InvalidBEncodingException {
        try {
            return (List)this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public Map getMap() throws InvalidBEncodingException {
        try {
            return (Map)this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public String toString() {
        byte[] bs;
        String valueString = this.value instanceof byte[] ? ((bs = (byte[])this.value).length <= 12 ? new String(bs) : "bytes:" + bs.length) : this.value.toString();
        return "BEValue[" + valueString + "]";
    }
}

