/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package seedpwn;

import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Random;

/**
 * thanks to http://code.threerings.net/svn/snark/trunk/src/java/org/klomp/snark/bencode/InvalidBEncodingException.java
 * @author anonymous
 */
public class Main {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        new Main().run();
    }

    private Proxy proxy;
    private final ArrayList<Pwner> pwners;
    private final Random rand;

    public Main() {
        proxy = null;
        pwners = new ArrayList<Pwner>();
        rand = new Random();
        
    }

    public void run() {
        new ui(this).setVisible(true);
    }

    void setproxy(String text) throws Exception {
        String parts[] = text.split(":");
        if(parts.length!=2) {
            throw new Exception("Bad proxy, required = host:port");
        }
        String host = parts[0];
        int port;
        try {
            port = Integer.decode(parts[1]).intValue();
        } catch(NumberFormatException ex) {
            port = 80;
        }
        proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        System.out.println("proxy defined: "+proxy.toString());
    }

    void download(String url, String dest) throws MalformedURLException, IOException {
        System.out.println("starting download: "+url);
        System.out.println("destination: "+dest);
        URL u = new URL(url);

        URLConnection c;
        if(proxy==null) {
            c=u.openConnection();
        } else {
            c=u.openConnection(proxy);
        }
        System.out.println("connected, reading...");
        InputStream in = c.getInputStream();
        
        FileOutputStream fo = new FileOutputStream(dest);
        boolean done=false;
        byte[] buffer = new byte[1024];
        int count;
        int total=0;
        while(!done) {
            try {
                count = in.read(buffer);
                if(count==-1) break;
                fo.write(buffer, 0, count);
                total += count;
            } catch(EOFException ex) {
                done = true;
            }
            
        }
        fo.close();
        in.close();
        System.out.println("done, got "+total+" bytes.");
    }

    void pwn(int threads, String filename) throws IOException {
        System.out.println("starting pwning: "+filename);
        Torrent t = new Torrent(filename);
        System.out.println("Torrent parsed");
        pwners.clear();
        int urls = t.getTrackers().size();
        
        for(int i =0; i<threads;i++) {
            for(int j=0;j<urls;j++) {
                Pwner p = new Pwner(this,t,i,j);
                pwners.add(p);
                new Thread(p).start();
            }
        }
        System.out.println("pwners started");
    }

    synchronized String generateip() {
        int a,b,c,d;
        a = rand.nextInt()&0xff;
        b = rand.nextInt()&0xff;
        c = rand.nextInt()&0xff;
        d = rand.nextInt()&0xff;
        return String.format("%d.%d.%d.%d",a,b,c,d);
    }

    String peerid() {
        int a=1000000+rand.nextInt(9999999-1000000);
        int b=1000000+rand.nextInt(9999999-1000000);
        int c=1000000+rand.nextInt(9999999-1000000);
        return String.valueOf(a)+String.valueOf(b)+String.valueOf(c);
    }

    boolean completed() {
        return rand.nextInt(4)==0;
    }

    int left() {
        return rand.nextInt(1024 * 1024 * 1024) + (1024 * 1024 * 2);
    }

    int port() {
        return 5000+rand.nextInt(32000-5000);
    }

    void stop() {
        for(Pwner p : pwners) {
            p.stop();
        }
    }

}

/* some torrents:
 * http://torrent.fedoraproject.org/torrents//F13-Beta-i686-Live.torrent
 * http://torrent.fedoraproject.org/torrents//Fedora-13-Beta-i386-DVD.torrent
 * http://torrent.fedoraproject.org/torrents//Fedora-13-Beta-i386-CDs.torrent
 * 
 */