/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package seedpwn;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;

/**
 *
 * @author slo
 */
public class Torrent {
    private byte[] infohash;
    private ArrayList<String> trackers;

    public Torrent(String inFileName) throws IOException {
        BDecoder dec = new BDecoder(new FileInputStream(inFileName));
        BEValue root = dec.bdecode();

        //info hash
        infohash = dec.get_special_map_digest();

        //announce
        Map<String, BEValue> m = root.getMap();
        BEValue announce = m.get("announce-list");
        trackers = new ArrayList<String>();
        if(announce==null) {
            announce = m.get("announce");
            if(announce==null) {
                throw new IOException("no announce data in torrent");
            }
            //this is a single string
            trackers.add(announce.getString());
        } else {
            //this is a list of list (wtf?)
            List<BEValue> lists = announce.getList();
            for(BEValue v: lists) {
                String s = v.getList().get(0).getString();
                System.out.println("v:"+s);
                if(!s.startsWith("http")) {
                    continue;
                }
                trackers.add(s);
            }
            
        }

        System.out.println("trackers:");
        for(String s: trackers) {
            System.out.println("=>"+s);
        }
        
    }

    public byte[] getInfoHash() {
        return infohash;
    }

    public List<String> getTrackers() {
        return trackers;
    }
}
