/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Scanner;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class ServeurUDP
extends JFrame {
    private static String word;
    JLabel lblWordToFind = new JLabel();

    public ServeurUDP() {
        this.setBounds(50, 50, 175, 100);
        this.setResizable(false);
        this.setAutoRequestFocus(false);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new FlowLayout(1, 5, 5));
        this.lblWordToFind.setHorizontalAlignment(0);
        this.lblWordToFind.setPreferredSize(new Dimension(175, 14));
        JLabel lblServerRunningDo = new JLabel("Server running. Do not close.");
        this.getContentPane().add(lblServerRunningDo);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        horizontalStrut.setPreferredSize(new Dimension(35, 0));
        this.getContentPane().add(horizontalStrut);
        JLabel lblInfoMot = new JLabel("Mot \u00e0 trouver :");
        this.getContentPane().add(lblInfoMot);
        Component horizontalStrut_1 = Box.createHorizontalStrut(20);
        horizontalStrut_1.setPreferredSize(new Dimension(35, 0));
        this.getContentPane().add(horizontalStrut_1);
        this.lblWordToFind.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                ServeurUDP.this.lblWordToFind.setText(word);
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ServeurUDP.this.lblWordToFind.setText("  ");
            }
        });
        this.getContentPane().add(this.lblWordToFind);
    }

    public static void main(String[] args) throws Exception {
        ServeurUDP frame = new ServeurUDP();
        frame.setVisible(true);
        int erreur = 0;
        int[] trouve = null;
        Scanner sc = new Scanner(System.in);
        word = ServeurUDP.initWord();
        char[] motAff = null;
        char[] mot = null;
        String wordAff = "";
        mot = word.toCharArray();
        char[] alpha = new char[25];
        ServeurUDP.initialiserTableauChar(alpha, ' ');
        DatagramSocket socketServeur = new DatagramSocket(Integer.parseInt(args[0]));
        byte[] msgRecu = new byte[1024];
        byte[] msgmotAff = new byte[1024];
        byte[] msgUrlImg = new byte[1024];
        byte[] msgAlpha = new byte[1024];
        int i = 0;
        while (i < word.length()) {
            wordAff = mot[i] != '-' ? String.valueOf(wordAff) + "*" : String.valueOf(wordAff) + "-";
            ++i;
        }
        motAff = wordAff.toCharArray();
        while (true) {
            DatagramPacket paquetRecu = new DatagramPacket(msgRecu, msgRecu.length);
            socketServeur.receive(paquetRecu);
            String message = new String(paquetRecu.getData());
            System.out.println("RECEIVED: " + message);
            char lettre = message.charAt(0);
            message = null;
            trouve = ServeurUDP.lettreTrouvee(lettre, mot);
            if (trouve[0] == -1) {
                ++erreur;
            } else {
                int it = 0;
                while (trouve[it] != -1) {
                    motAff[trouve[it]] = lettre;
                    ++it;
                }
            }
            InetAddress IPAddress = paquetRecu.getAddress();
            int port = paquetRecu.getPort();
            msgmotAff = ServeurUDP.charToString(motAff).getBytes();
            DatagramPacket paquetmotAff = new DatagramPacket(msgmotAff, msgmotAff.length, IPAddress, port);
            socketServeur.send(paquetmotAff);
            Thread.sleep(100L);
            msgUrlImg = ServeurUDP.checkMot(motAff, '*') ? ServeurUDP.urlPendu(erreur).getBytes() : "gagner".getBytes();
            DatagramPacket paquetUrl = new DatagramPacket(msgUrlImg, msgUrlImg.length, IPAddress, port);
            socketServeur.send(paquetUrl);
            if (ServeurUDP.checkMot(motAff, '*') && ServeurUDP.urlPendu(erreur) != "perdu") continue;
            System.exit(0);
        }
    }

    public static String initWord() {
        String word = "";
        int i = (int)(Math.random() * 100000.0);
        while (i > 336529) {
            i /= 2;
        }
        try {
            int carac;
            LineNumberReader fnr = new LineNumberReader(new FileReader(new File("file/word.txt")));
            word = "";
            String secretWord = "";
            while ((carac = fnr.read()) != -1) {
                if (fnr.getLineNumber() == i + 1) break;
                if (fnr.getLineNumber() != i) continue;
                word = String.valueOf(word) + (char)carac;
            }
            word = word.trim();
            int j = 0;
            while (j < word.length()) {
                secretWord = String.valueOf(secretWord) + (word.charAt(j) != '\'' && word.charAt(j) != '-' ? "*" : Character.valueOf(word.charAt(j)));
                ++j;
            }
            fnr.close();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Erreur de chargement depuis le fichier de mots !", "ERREUR", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Erreur de chargement depuis le fichier de mots !", "ERREUR", 0);
        }
        return word;
    }

    static void initialiserTableauInt(int[] t, int nb) {
        int i = 0;
        while (i < t.length) {
            t[i] = nb;
            ++i;
        }
    }

    static void initialiserTableauChar(char[] t, char lettre) {
        int i = 0;
        while (i < t.length) {
            t[i] = lettre;
            ++i;
        }
    }

    static int[] lettreTrouvee(char l, char[] mot) {
        int[] trouve = new int[100];
        int x = 0;
        ServeurUDP.initialiserTableauInt(trouve, -1);
        int i = 0;
        while (i < mot.length) {
            if (mot[i] == l) {
                trouve[x] = i;
                ++x;
            }
            ++i;
        }
        return trouve;
    }

    static String urlPendu(int nb) {
        String url = "";
        switch (nb) {
            case 0: {
                url = "file/pendu0.jpg";
                break;
            }
            case 1: {
                url = "file/pendu1.jpg";
                break;
            }
            case 2: {
                url = "file/pendu2.jpg";
                break;
            }
            case 3: {
                url = "file/pendu3.jpg";
                break;
            }
            case 4: {
                url = "file/pendu4.jpg";
                break;
            }
            case 5: {
                url = "file/pendu5.jpg";
                break;
            }
            case 6: {
                url = "file/pendu6.jpg";
                break;
            }
            case 7: {
                url = "file/pendu7.jpg";
                break;
            }
            case 8: {
                url = "perdu";
                break;
            }
        }
        return url;
    }

    public static String charToString(char[] word) {
        String s = "";
        int j = 0;
        while (j < word.length) {
            s = String.valueOf(s) + word[j];
            ++j;
        }
        return s;
    }

    static boolean checkMot(char[] mot, char lettre) {
        boolean check = false;
        int i = 0;
        while (i < mot.length) {
            if (mot[i] == lettre) {
                check = true;
            }
            ++i;
        }
        return check;
    }
}

