package client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.Socket;

public class ServerListener extends Thread {

	Socket emission;

	BufferedReader in;

	PrintWriter out;

	/**
	 * Datas assignated variables
	 */
	private int Case = -1;
	private String Winner = null;

	private String Message;

	/**
	 * Sending datas variables
	 */
	private String cellToSend = null;

	/**
	 * Receiving datas variables
	 */

	DatagramPacket paquetRecu;

	Thread receiver = new Thread(new Runnable() {

		@Override
		public void run() {
			System.out.println(emission.toString());
			while (true) {
				/**
				 * Data receiving
				 */
				try {
					Message = in.readLine();
					Message = Message.trim();
					System.out.println(Message);
				} catch (IOException e1) {
				}

				try { // If parseInt successful => it's a cell
					Case = Integer.parseInt(Message);
					System.out.println("case = " + Message);
				} catch (Exception e) {
					// If parseInt failed => it's a game over
					if (Message != null) {
						System.out.println("winner");
						Winner = Message;
					}
				}
				Message = null;
			}
		}
	});

	/**
	 * 
	 */

	public ServerListener(Socket sock) throws Exception {

		emission = sock;

		// Setting a timeout for receiving datas
		emission.setSoTimeout(100);

		/**
		 * Defining the input and output
		 */
		in = new BufferedReader(
				new InputStreamReader(emission.getInputStream()));

		out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(
				emission.getOutputStream())), true);

		/**
		 * Starting datas receiving
		 */
		receiver.start();

	}

	public void run() {

		while (true) {

			/**
			 * Sending datas
			 * 
			 * Check if the listener have to send datas each 100 milli-seconds
			 * to not overload the processor
			 */
			try {
				Thread.sleep(100);
			} catch (InterruptedException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			/**
			 * Datas to send
			 */
			if (this.cellToSend != null) {
				System.out.println("Cell send : " + this.cellToSend);
				out.println(this.cellToSend);
				this.cellToSend = null;
			}

		}
	}

	public int getCell() {
		return this.Case;
	}

	/**
	 * Reset cell buffer
	 */
	public void resetCell() {
		this.Case = -1;
	}

	/**
	 * Local variable "Winner" will be null of there is no winner
	 * 
	 * @return
	 */
	public String getWinner() {
		String win = Winner;
		this.Winner = "";
		if (win != "")
			return win;
		else
			return null;
	}

	/**
	 * Method allowing the client to send data te the buffer
	 * 
	 * @param cellToSend
	 */
	public void setCellToSend(String cellToSend) {
		this.cellToSend = cellToSend;
	}
}