package objet;

import java.awt.GridLayout;
import java.io.*;
import java.net.*;
import java.util.Random;

public class ServTaquin implements Runnable {
	Socket sock_com;

	ServTaquin(Socket sock_com) throws SocketException {
		this.sock_com = sock_com;

	}

	Piece[] Pieces;

	int dimX;
	int dimY;
	int pieceVide;

	public int getDimX() {
		return dimX;
	}

	public void setDimX(int dimX) {
		this.dimX = dimX;
	}

	public int getDimY() {
		return dimY;
	}

	public void setDimY(int dimY) {
		this.dimY = dimY;
	}

	public Piece[] getPieces() {
		return Pieces;
	}

	public void setPieces(Piece[] pieces) {
		Pieces = pieces;
	}

	public int getPieceVide() {
		return pieceVide;
	}

	public void setPieceVide(int pieceVide) {
		this.pieceVide = pieceVide;
	}

	//Modifie le tableau en coonsquence d'un coup haut/bas/droit/gauche
	
	public void Gauche(int id) {

		int idVois = id + 1;
		if ((id % dimX) != 0 && idVois <= dimX * dimY) {
			Pieces[id].setValeur(Pieces[idVois].getValeur());
			Pieces[idVois].setValeur("");
			setPieceVide(idVois);
		}

	}

	public void Droit(int id) {

		int idVois = id - 1;
		if ((id % dimX) != 1 && idVois >= 1) {
			Pieces[id].setValeur(Pieces[idVois].getValeur());
			Pieces[idVois].setValeur("");
			setPieceVide(idVois);
		}

	}

	public void Haut(int id) {

		int idVois = id + dimY;
		if ((id / dimY) < dimY && idVois <= dimX * dimY) {

			Pieces[id].setValeur(Pieces[idVois].getValeur());
			Pieces[idVois].setValeur("");
			setPieceVide(idVois);
		}

	}

	public void Bas(int id) {

		int idVois = id - dimY;
		if ((id / dimX) > 0 && dimX != id & idVois > 0) {
			Pieces[id].setValeur(Pieces[idVois].getValeur());
			Pieces[idVois].setValeur("");
			setPieceVide(idVois);
		}

	}

	public void melange() {
		Random rand = new Random();
		int randNum;
		for (int i = 0; i < 10000; i++) {
			randNum = rand.nextInt(4) + 1;
			switch (randNum) {
			case 1:
				Gauche(getPieceVide());
				break;
			case 2:
				Droit(getPieceVide());
				break;
			case 3:
				Haut(getPieceVide());
				break;
			case 4:
				Bas(getPieceVide());
				break;
			}

		}
	}

	public boolean condVict() {
		boolean bool = true;

		for (int i = 1; i < getDimX() * getDimY(); i++) {
			if (!(Pieces[i].getValeur().equals(Pieces[i].getId()))) {
				bool = false;
			}
		}

		return bool;

	}

	public void run() {
		try {
			System.out.println("Addresse socket" + sock_com.getInetAddress());
			System.out.println("Connexion venant de "
					+ sock_com.getInetAddress().getHostName());

			// Cration des flux
			BufferedReader in = new BufferedReader(new InputStreamReader(
					sock_com.getInputStream()));
			PrintWriter out = new PrintWriter(new BufferedWriter(
					new OutputStreamWriter(sock_com.getOutputStream())), true);
			
			int nbrCoup = 0;
			setDimX(Integer.parseInt(in.readLine())); //rcupre les dimensions du taquin choisit par le joueur et envoy par le client
			setDimY(Integer.parseInt(in.readLine())); //afin de construire le tableau de pice
			int val = 0;
			Pieces = new Piece[dimX * dimY + 1];
			for (int i = 0; i < dimY; i++) {

				for (int j = 0; j < dimX; j++) {
					val = j + (i * dimX) + 1;
					Pieces[val] = new Piece(Integer.toString(val));
				}
			}
			Pieces[val].setValeur(" ");
			setPieceVide(val);
			melange();

			for (int i = 1; i <= val; i++) {
				out.println(Pieces[i].getId()); //envoie le tableau de pice au client aprs mlange
				out.println(Pieces[i].getValeur()); //le tableau est envoy sous la forme de l'id et la valeur de chaque pices
			}

			String cas;

			while (!condVict()) {
				nbrCoup++;
				cas = in.readLine(); // rcupre la commande haut/bas/droit/gauche envoy par le client, puis  le tableau actualis est envoy
				switch (cas) { 
				case "haut":
					Haut(getPieceVide()); // application du mouvement slctionn par le client
					out.println("continue"); // indique au client que la partie n'est pas termin et que le tableau va tre envoy

					for (int i = 1; i <= val; i++) {
						out.println(Pieces[i].getId()); 
						out.println(Pieces[i].getValeur());
					}
					break;
				case "bas":
					Bas(getPieceVide());
					out.println("continue");

					for (int i = 1; i <= val; i++) {
						out.println(Pieces[i].getId());
						out.println(Pieces[i].getValeur());					
						}
					break;
				case "gauche":
					Gauche(getPieceVide());
					out.println("continue");

					for (int i = 1; i <= val; i++) {
						out.println(Pieces[i].getId());
						out.println(Pieces[i].getValeur());					
						}
					break;
				case "droit":
					Droit(getPieceVide());
					out.println("continue");
					for (int i = 1; i <= val; i++) {
						out.println(Pieces[i].getId());
						out.println(Pieces[i].getValeur());					
						}
					break;
				default:
					break;

				}
				
			}
			out.println("victoire"); //indique au client que la partie est termin
			out.println(nbrCoup); // indique au client le nombre de coup ncessaire pour finir le taquin
			
			in.close(); 
			out.close(); 
			sock_com.close(); 
			System.exit(1);
			 

		} catch (IOException  e) {
			System.exit(1);
		}
	}
}
