package affichage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import java.awt.FlowLayout;
import java.util.ArrayList;

import javax.swing.JButton;

import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JLabel;

import java.awt.Component;

import javax.swing.Box;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.border.BevelBorder;

@SuppressWarnings("serial")
public class Fenetre extends JFrame {

	private static Integer clickedCell = null;

	private JLabel label = new JLabel("En attente du client");
	private static Component horizontalStrut = null;

	private boolean active = false;

	private static ArrayList<JButton> grid = new ArrayList<JButton>();

	private static JPanel contentPane;

	public Fenetre(String title) {

		/**
		 * Create the frame.
		 */
		setAlwaysOnTop(true);
		setTitle(title);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));

		/**
		 * Create the panel containing the buttons
		 */

		JPanel pnlBoard = new JPanel();
		pnlBoard.setPreferredSize(new Dimension(90, 90));
		contentPane.add(pnlBoard);
		pnlBoard.setLayout(new GridLayout(3, 3, 0, 0));

		/**
		 * Struct separating the grid and the message
		 */
		horizontalStrut = Box.createHorizontalStrut(this.getWidth());
		horizontalStrut.setPreferredSize(new Dimension(this.getWidth(), 25));

		contentPane.addComponentListener(new ComponentAdapter() {
			@Override
			public void componentResized(ComponentEvent arg0) {
				horizontalStrut.setPreferredSize(new Dimension(contentPane
						.getWidth(), 25));
			}
		});
		contentPane.add(horizontalStrut);

		contentPane.add(label);

		/**
		 * button creation
		 */

		for (int i = 0; i < 9; i++) {
			grid.add(i, new JButton(""));
			grid.get(i).setName(Integer.toString(i + 1));
			grid.get(i).setMargin(new Insets(0, 0, 0, 0)); // Remove all margins
		}

		for (int i = 0; i < 9; i++) {
			/**
			 * Disable all buttons animations (hover, click,...)
			 */
			grid.get(i).setContentAreaFilled(false);
			grid.get(i).setBackground(Color.white);
			grid.get(i).setFocusable(false);
			grid.get(i).setOpaque(true);
			grid.get(i)
					.setBorder(
							new BevelBorder(BevelBorder.LOWERED, null, null,
									null, null));
			pnlBoard.add(grid.get(i));

			/**
			 * Individual and anonymous listener for each cell (button)
			 */
			grid.get(i).addMouseListener(new MouseAdapter() {
				@Override
				public void mouseClicked(MouseEvent arg0) {
					if (active
							&& (((JButton) arg0.getSource()).getText() == ""))
						clickedCell = Integer.parseInt(((JButton) arg0
								.getSource()).getName());
					System.out.println(active);
				}
			});
		}

		// setPreferredSize(new Dimension(30, 30))
	}

	public static Integer getClickedCase() {
		return clickedCell;
	}

	/**
	 * Tick a case with the appropriate color
	 * 
	 * @param Case
	 *            => the cell to tick
	 * @param car
	 *            => the character of the player (to insert in the cell)
	 * @return
	 */
	public static boolean setCase(Integer Case, String car) {

		if (car == "X")
			grid.get(Case - 1).setForeground(Color.red);
		else
			grid.get(Case - 1).setForeground(Color.blue);

		clickedCell = null; // flushing the cell buffer

		if (grid.get(Case - 1).getText() == "") { // If cell empty
			grid.get(Case - 1).setText(car);
		} else
			// If cell already filled
			return false;

		return true;
	}

	/**
	 * 
	 */
	public boolean isActive() {
		return active;
	}

	public String getLabel() {
		return label.getText();
	}

	/**
	 * Change the label under the grid
	 * 
	 * @param str
	 */
	public void setLabel(String str) {
		this.label.setText(str);
	}

	/**
	 * Reset the grid (for a new game)
	 */
	public static void reset() {
		for (int i = 0; i < grid.size(); i++) {
			grid.get(i).setText("");
		}
	}

	/**
	 * Lock/Unlock the window (depending of the current player's turn)
	 * 
	 * @param active
	 * @param player
	 */
	public void setActive(boolean active, String player) {
		// if (active)
		label.setText("C'est au joueur " + player + " de jouer");
		/*
		 * else if (player == "X") label.setText("C'est au joueur O de jouer");
		 * else label.setText("C'est au joueur X de jouer");
		 */
		this.active = active;
	}

	/**
	 * Get the value of a cell (to know which player ticked the cell)
	 * 
	 * @param numCase
	 * @return
	 */
	public static String getVal(Integer numCase) {
		return grid.get(numCase - 1).getText();
	}

	/**
	 * Display a window asking the player for a new game (or closing the game)
	 * 
	 * @param player
	 */
	public void win(String player) {

		String victory = "";

		System.out.println("player = " + player);

		switch (player) {
		case "draw":
			label.setText("Egalit !");
			victory = "Egalit";
			break;

		default:
			label.setText("Le gagnant est le joueur " + player + " !");
			victory = "Le gagnant est le joueur " + player + " !";
			break;
		}

		Object[] options = { "Reset", "Fermer" };
		int answer = JOptionPane.showOptionDialog(this, victory, "Game Over",
				JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null,
				options, // the titles of buttons
				options[0]); // default button title

		switch (answer) {
		case 0:
			System.out.println("Reset");
			Fenetre.reset();
			break;

		default:
			System.out.println("Fermer");
			System.exit(0);
			break;
		}
	}

	/**
	 * Check if all cells are filled
	 * 
	 * @return
	 */
	public boolean draw() {
		boolean full = true;
		for (int i = 0; i < grid.size(); i++) {
			if (grid.get(i).getText() == "")
				full = false;
		}
		return full;
	}

}
