import java.net.*;
import java.util.Date;
import java.util.Scanner;
import java.io.*;

import javax.swing.JOptionPane;

public class ServeurUDP {
	public static void main(String args[]) throws Exception {

		int erreur = 0, trouve[] = null;
		Scanner sc = new Scanner(System.in);
		String word;
		word = initWord();
		char[] motAff = null, mot = null;
		String wordAff = "";
		mot = word.toCharArray();
		char[] alpha = new char[25];
		initialiserTableauChar(alpha, ' ');

		DatagramSocket socketServeur = new DatagramSocket(3000);
		byte[] msgRecu = new byte[1024];
		byte[] msgmotAff = new byte[1024];
		byte[] msgUrlImg = new byte[1024];
		byte[] msgAlpha = new byte[1024];

		for (int i = 0; i < word.length(); i++) { // remplace tout les caractre du mo  trouver
			if (mot[i] != '-') {				  // par des '*', sauf les '-'
				wordAff = wordAff + "*";
			} else {
				wordAff = wordAff + "-";
			}
		}
		motAff = wordAff.toCharArray();

		while (true) {

			DatagramPacket paquetRecu = new DatagramPacket(msgRecu,
					msgRecu.length);
			socketServeur.receive(paquetRecu);

			String message = new String(paquetRecu.getData());
			System.out.println("RECEIVED: " + message);

			char lettre = message.charAt(0);		//recoit la lettre envoye par le client

			message = null;

			trouve = lettreTrouvee(lettre, mot);	//cherche la lettre grce  a fonction lettretrouve

			if (trouve[0] == -1) {
				erreur++; // si la premire valeur du tableau renvoy par lettretrouve est -1 => aucune occurence => erreur

			} else {
				int it = 0;

				while (trouve[it] != -1) { 		// rcupre la place de toute les occurences de la lettre
					motAff[trouve[it]] = lettre; // remplace les '*' aux emplacement trouv par la lettre
					it++;
				}
			}

			InetAddress IPAddress = paquetRecu.getAddress();
			int port = paquetRecu.getPort();

			msgmotAff = charToString(motAff).getBytes();
			DatagramPacket paquetmotAff = new DatagramPacket(msgmotAff, // Renvoi le mot aprs transformation
					msgmotAff.length, IPAddress, port);
			socketServeur.send(paquetmotAff);

			Thread.sleep(100);

			if (checkMot(motAff, '*')) {msgUrlImg = urlPendu(erreur).getBytes();}// Renvoi si aucun '*' n'est present dans le mot, envoi "gagner"
			else {msgUrlImg = "gagner".getBytes();}
			DatagramPacket paquetUrl = new DatagramPacket(msgUrlImg,	// Renvoi l'url de l'image  afficher
					msgUrlImg.length, IPAddress, port);
			socketServeur.send(paquetUrl);
			
			if ((checkMot(motAff, '*'))==false||urlPendu(erreur)=="perdu"){System.exit(0);} // si mot trouv ou si le joueur  perdu, arrete le serveur

		}
	}

	public static String initWord() {
		String secretWord, word = "";
		int i = (int) (Math.random() * 100000);  // Initialise me mot grce  un dictionnaire de mot
		while (i > 336529) {
			i /= 2;
		}

		try {
			LineNumberReader fnr = new LineNumberReader(new FileReader(
					new File("file/word.txt")));
			int carac;
			word = "";
			secretWord = "";
			while ((carac = fnr.read()) != -1) {
				if (fnr.getLineNumber() == (i + 1))
					break;

				else {
					if (fnr.getLineNumber() == i) {
						word += (char) carac;
					}
				}
			}

			word = word.trim();

			for (int j = 0; j < word.length(); j++) {
				secretWord += (word.charAt(j) != '\'' && word.charAt(j) != '-') ? "*"
						: word.charAt(j);
			}

			fnr.close();
		} catch (FileNotFoundException e) {
			JOptionPane.showMessageDialog(null,
					"Erreur de chargement depuis le fichier de mots !",
					"ERREUR", JOptionPane.ERROR_MESSAGE);
		} catch (IOException e) {
			JOptionPane.showMessageDialog(null,
					"Erreur de chargement depuis le fichier de mots !",
					"ERREUR", JOptionPane.ERROR_MESSAGE);
		}
		return word;
	}

	static void initialiserTableauInt(int t[], int nb) {	//initialise un tableau d'entier avec la valeur passe en paramtre
		for (int i = 0; i < t.length; i++) {
			t[i] = nb;
		}
	}

	static void initialiserTableauChar(char t[], char lettre) { //initialise un tableau de char avec la valeur passe en paramtre
		for (int i = 0; i < t.length; i++) {
			t[i] = lettre;
		}
	}

	static int[] lettreTrouvee(char l, char[] mot) { //cherche dans un tableau de char si le caractre pass en paramtre est prsent 
		int[] trouve = new int[100];				// et enregistre sa/ses positions grce  un tableau d'entier
		int x = 0;	

		initialiserTableauInt(trouve, -1);

		for (int i = 0; i < mot.length; i++) {
			if (mot[i] == l) {
				trouve[x] = i;
				x++;
			}
		}

		return trouve;

	}

	static String urlPendu(int nb) { // definit l'url de l'image a afficher en fonction du nombre d'erreur.
		String url = "";			// la valeur perdu sert  dfinir la fin de la partie
		switch (nb) {

		case 0: 
			url = "file/pendu0.jpg";
			break;

		case 1: 
			url = "file/pendu1.jpg";
			break;
		case 2: 
			url = "file/pendu2.jpg";

			break;
		case 3: 
			url = "file/pendu3.jpg";
			break;
		case 4: 

			url = "file/pendu4.jpg";
			break;
		case 5: 
			url = "file/pendu5.jpg";
			break;
		case 6:
			url = "file/pendu6.jpg";
			break;
		case 7:
			url = "file/pendu7.jpg";
			break;
		case 8:
			url = "perdu";
			break;
		default:
			break;

		}
		return url;
	}

	public static String charToString(char[] word) { // converti un tableau de char en string
		String s = "";
		for (int j = 0; j < word.length; j++) {
			s = s + word[j];
		}
		return s;

	}
	static boolean checkMot(char[] mot, char lettre) { // renvoi true si le charatere existe dans la tableau de charactere

		boolean check = false;

		for (int i = 0; i < mot.length; i++) {

			if (mot[i] == lettre) {
				check = true;
			}

		}
		return check;
	}
}
