import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

import java.awt.FlowLayout;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import java.awt.Component;

import javax.swing.Box;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class Prgm extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private JPanel contentPane;

	String className = this.getClass().getCanonicalName();

	JPanel pnlDatas = new JPanel();

	private JLabel lblIP = new JLabel("IP :");
	private JTextField txtIP = new JTextField("localhost");
	private JLabel lblPort = new JLabel(":");
	private JTextField txtPort = new JTextField("3042");
	private BtnLauncher btnTTT = new BtnLauncher("icons/TTT.png");
	private BtnLauncher btnPendu = new BtnLauncher("icons/pendu.png");
	private BtnLauncher btnTaquin = new BtnLauncher("icons/taquin.png");

	private Component struct_Datas_Help = Box.createHorizontalStrut(this
			.getWidth());

	private final JButton btnHelp = new JButton("Open README");

	private final Component struct_Help_Choice = Box.createHorizontalStrut(this
			.getWidth());

	/**
	 * Games process
	 */
	private Process proc_TTT_Serveur;
	private Process proc_TTT_Client;

	private Process proc_Pendu_Serveur;
	private Process proc_Pendu_Client;

	private Process proc_Taquin_Serveur;
	private Process proc_Taquin_Client;
	private final JMenuBar menuBar = new JMenuBar();
	private final JMenu mnu_file = new JMenu("File");
	private final JMenuItem itemClose = new JMenuItem("Fermer");
	private final JMenu pnuHelp = new JMenu("Help");
	private final JMenuItem item_help = new JMenuItem("open README.txt");

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) throws Exception {

		try {
			// Change UI to the system's one
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
		}
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					Prgm frame = new Prgm();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

	}

	/**
	 * Create the frame.
	 */
	public Prgm() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 500);

		setJMenuBar(menuBar);

		mnu_file.add(itemClose);

		menuBar.add(mnu_file);

		menuBar.add(pnuHelp);

		pnuHelp.add(item_help);
		contentPane = new JPanel();
		setContentPane(contentPane);
		contentPane.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));

		contentPane.add(pnlDatas);
		pnlDatas.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
		lblIP.setHorizontalAlignment(SwingConstants.RIGHT);
		pnlDatas.add(lblIP);

		txtIP.setColumns(15);
		pnlDatas.add(txtIP);
		lblPort.setHorizontalAlignment(SwingConstants.RIGHT);
		pnlDatas.add(lblPort);

		txtPort.setColumns(5);
		pnlDatas.add(txtPort);

		/**
		 * Elements used to separate components vertically
		 */
		struct_Datas_Help.setPreferredSize(new Dimension(this.getWidth(), 0));
		struct_Help_Choice.setPreferredSize(new Dimension(this.getWidth(), 0));

		/**
		 * Listeners to resize structs (to always occupy the whole width)
		 */
		addComponentListener(new ComponentAdapter() {
			@Override
			public void componentResized(ComponentEvent event) {
				struct_Datas_Help.setPreferredSize(new Dimension(event
						.getComponent().getWidth(), 0));
				struct_Help_Choice.setPreferredSize(new Dimension(event
						.getComponent().getWidth(), 0));
			}
		});

		contentPane.add(struct_Datas_Help);

		/**
		 * Help file opener
		 */
		btnHelp.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent ME) {

				// Get current directory path
				File path = new File("");

				// Get README.txt path
				File readme = new File(path.getAbsolutePath()
						+ "/externalFiles/README.txt");
				System.out.println(readme.toString());

				// Open the file
				try {
					Desktop.getDesktop().open(readme);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		item_help.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {

				// Get current directory path
				File path = new File("");

				// Get README.txt path
				File readme = new File(path.getAbsolutePath()
						+ "/externalFiles/README.txt");
				System.out.println(readme.toString());

				// Open the file
				try {
					Desktop.getDesktop().open(readme);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		/**
		 * Menu close item
		 */
		itemClose.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				System.exit(0);
			}
		});
		/**
		 * 
		 */
		contentPane.add(btnHelp);

		contentPane.add(struct_Help_Choice);

		JPanel pnlchoice = new JPanel();
		pnlchoice.setPreferredSize(new Dimension(125, 350));
		contentPane.add(pnlchoice);

		/**
		 * Open game : Tic-Tac-Toe
		 */
		btnTTT.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent arg0) {
				String args_serv = txtPort.getText();

				String args_cl = txtIP.getText() + " " + txtPort.getText();

				// Check if game launched
				try {

					/**
					 * Launch the server
					 */
					if (proc_TTT_Serveur == null || !proc_TTT_Serveur.isAlive())
						proc_TTT_Serveur = Runtime.getRuntime().exec(
								"java -jar games/morpion_serveur.jar "
										+ args_serv);

					/**
					 * Launch the client
					 */
					if (proc_TTT_Client == null || !proc_TTT_Client.isAlive())
						proc_TTT_Client = Runtime.getRuntime()
								.exec("java -jar games/morpion_client.jar "
										+ args_cl);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});

		/**
		 * Open game : Pendu
		 */
		btnPendu.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent arg0) {
				String args_serv = txtPort.getText();

				String args_cl = txtIP.getText() + " " + txtPort.getText();

				// Check if game launched
				try {

					/**
					 * Launch the server
					 */
					if (proc_Pendu_Serveur == null
							|| !proc_Pendu_Serveur.isAlive())
						proc_Pendu_Serveur = Runtime.getRuntime().exec(
								"java -jar games/pendu_serveur.jar "
										+ args_serv);

					final BufferedReader stdInput = new BufferedReader(
							new InputStreamReader(proc_Pendu_Serveur
									.getInputStream()));

					/**
					 * This game need the output to be redirected to work
					 */
					Thread penduServOutput = new Thread(new Runnable() {
						@Override
						public void run() {

							// Read the output from the process
							System.out
									.println("Here is the standard output of the command:\n");
							String s = null;
							try {
								while ((s = stdInput.readLine()) != null) {
									System.out.println(s);
								}
							} catch (IOException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
					penduServOutput.start();

					/**
					 * Launch the client
					 */
					if (proc_Pendu_Client == null
							|| !proc_Pendu_Client.isAlive())
						proc_Pendu_Client = Runtime.getRuntime().exec(
								"java -jar games/pendu_client.jar " + args_cl);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});

		/**
		 * Open game : Taquin
		 */
		btnTaquin.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent arg0) {
				String args_serv = txtPort.getText();

				String args_cl = txtIP.getText() + " " + txtPort.getText();

				// Check if game launched
				try {

					/**
					 * Launch the server
					 */
					if (proc_Taquin_Serveur == null
							|| !proc_Taquin_Serveur.isAlive())
						proc_Taquin_Serveur = Runtime.getRuntime().exec(
								"java -jar games/taquin_serveur.jar "
										+ args_serv);

					/**
					 * Launch the client
					 */
					if (proc_Taquin_Client == null
							|| !proc_Taquin_Client.isAlive())
						proc_Taquin_Client = Runtime.getRuntime().exec(
								"java -jar games/taquin_client.jar " + args_cl);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});

		/**
		 * Add the launch buttons
		 */
		pnlchoice.add(btnTTT);
		pnlchoice.add(btnPendu);
		pnlchoice.add(btnTaquin);
	}
}
