package client;

import java.net.Socket;

import affichage.Fenetre;

public class Client implements Runnable {

	private static String IP;
	private static int port;

	// true = client's turn
	private static boolean myTurn = true;

	private static ServerListener listener;

	private static String winner = "";

	private static boolean still;

	// Will wait for the winner to be announced
	private static Thread checkWinner = new Thread(new Runnable() {

		@Override
		public void run() {
			while (true) {
				if ((winner = listener.getWinner()) != null) {
					frame.win(winner);
					still = false;
					winner = "";
				}
				try {
					Thread.sleep(100);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	});

	// Win tick a case when the message will be received
	private static Thread caseTicker = new Thread(new Runnable() {

		@Override
		public void run() {
			while (true) {

				// Activate the window
				frame.setActive(true, "X");

				// Wait for the opponent turn
				while (myTurn) {
					try {
						Thread.sleep(100);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}

				// Lock the window
				frame.setActive(false, "O");

				while (listener.getCell() == -1) {
					try {
						Thread.sleep(100);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					// System.out.println(listener.getCase());
				}
				// Activate the window
				frame.setActive(true, "X"); // Unlock window

				System.out.println("From Serveur : " + listener.getCell());
				Fenetre.setCase(listener.getCell(), "O");
				myTurn = true;
				listener.resetCell();
			}
		}
	});

	private static Fenetre frame = new Fenetre("Client");

	public static void main(String argv[]) throws Exception {

		// InetAddress.getByName(argv[0]);

		// Integer.parseInt(argv[1]);

		listener = new ServerListener(new Socket(argv[0],
				Integer.parseInt(argv[1])));

		System.out.println(listener.toString());

		listener.start();

		checkWinner.start();
		caseTicker.start();

		frame.setVisible(true);

		while (true)
			Game();
	}

	public static void Game() throws Exception {

		still = true; // true = game running
		frame.setActive(true, "X"); // Unlock window
		
		// the client starts
		myTurn = true;

		while (true) {

			do {

				/**
				 * Wait for a cell to be clicked
				 */
				while (Fenetre.getClickedCase() == null) {
					Thread.sleep(100);
					if (!still)
						return;
				}

				// Send the case
				listener.setCellToSend(Fenetre.getClickedCase().toString());
			} while (!Fenetre.setCase(Fenetre.getClickedCase(), "X"));
			frame.setActive(false, "O"); // Unlock window
			myTurn = false;
		}
	}

	
	/**
	 * Not used.
	 * Was created in case of thread needed.
	 */
	@Override
	public void run() {

		try {
			listener = new ServerListener(new Socket(IP, port));

			listener.start();

			checkWinner.start();
			caseTicker.start();

			frame.setVisible(true);

			while (true)
				Game();

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static void setIP(String iP) {
		IP = iP;
	}

	public static void setPort(String port) {
		Client.port = Integer.parseInt(port);
	}
}