package serveur;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

import affichage.Fenetre;

public class Serveur implements Runnable {

	private static int port;

	private static Fenetre frame = new Fenetre("Serveur");

	private static Socket soc_com;

	private static ServerSocket ecoute;

	private static BufferedReader in;
	private static PrintWriter out;

	public static void main(String args[]) throws Exception {
		frame.setVisible(true);

		//Wait for the client to connect
		ecoute = new ServerSocket(Integer.parseInt(args[0]));
		soc_com = ecoute.accept();

		System.out.println("Le serveur recoit sur le port : "
				+ Integer.parseInt(args[0]));

		System.out.println(" " + soc_com.getInetAddress());
		InetAddress origin = soc_com.getInetAddress();
		System.out.println("Connection venant de : " + origin.getHostName());
		
		// Define the input and output
		in = new BufferedReader(new InputStreamReader(soc_com.getInputStream()));
		out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(
				soc_com.getOutputStream())), true);

		System.out.println(">>> Serveur prêt ! ");

		while (true)
			Game();

	}
	
	public static void Game() throws Exception {

		String message;

		frame.setActive(false, "X"); // Lock window

		while (true) {
			message = in.readLine();
			System.out.println("RECEIVED: [" + message + "]");

			Fenetre.setCase(Integer.parseInt(message), "X");

			/**
			 * Check the winner (before the server's turn)
			 */
			if (checkWin(Integer.parseInt(message)) != null) {
				String winner = checkWin(Integer.parseInt(message));

				out.println(winner);

				frame.win(winner);

				return;

				// frame.setActive(true, "X"); // Unlock window
			}

			frame.setActive(true, "O"); // Unlock window

			do {

				/**
				 * Wait for a cell to be clicked
				 */
				while (Fenetre.getClickedCase() == null) {
					Thread.sleep(100);
				}

				message = Fenetre.getClickedCase().toString();
			} while (!Fenetre.setCase(Fenetre.getClickedCase(), "O"));

			frame.setActive(false, "X"); // Lock window

			System.out.println("SEND: " + message);
			out.println(message);

			/**
			 * Check winner (after the server's turn)
			 */
			if (checkWin(Integer.parseInt(message)) != null) {
				String winner = checkWin(Integer.parseInt(message));

				out.println(winner);

				frame.win(winner);

				return;

				// frame.setActive(true, "X"); // Unlock window
			}

		}

	}

	public static String checkWin(Integer changedCase) {

		System.out.println("[" + changedCase + "]");

		String winner = null;

		/*
		 * 1 | 2 | 3 -> (C+1 mod 3) + 0 --------- 4 | 5 | 6 -> (C+1 mod 3) + 3
		 * --------- 7 | 8 | 9 -> (C+1 mod 3) + 6
		 * 
		 * columns : C+3 mod 10 + 1
		 * 
		 * lines : ((C+1 mod 3) div 3 ) * 2
		 */
		/**
		 * Cross-check
		 */
		ArrayList<Integer> lines = new ArrayList<Integer>();
		lines.add((changedCase - 1) / 3 * 3 + 1);
		lines.add((changedCase - 1) / 3 * 3 + 2);
		lines.add((changedCase - 1) / 3 * 3 + 3);

		ArrayList<Integer> cols = new ArrayList<Integer>();
		cols.add(changedCase);
		cols.add((changedCase + 3) % 10 + (changedCase + 3) / 10);
		cols.add((changedCase + 6) % 10 + (changedCase + 6) / 10);

		System.out.println(lines.toString());
		System.out.println(cols.toString());

		if (Fenetre.getVal(lines.get(0)) == Fenetre.getVal(lines.get(1))
				&& Fenetre.getVal(lines.get(0)) == Fenetre.getVal(lines.get(2))) {
			winner = Fenetre.getVal(changedCase);
			System.out.println("cas1");
		} else if (Fenetre.getVal(cols.get(0)) == Fenetre.getVal(cols.get(1))
				&& Fenetre.getVal(cols.get(0)) == Fenetre.getVal(cols.get(2))) {
			winner = Fenetre.getVal(changedCase);
			System.out.println("cas2");
		} else if (Fenetre.getVal(1) == Fenetre.getVal(5)
				&& Fenetre.getVal(1) == Fenetre.getVal(9)
				&& Fenetre.getVal(1) != "") {
			winner = Fenetre.getVal(changedCase);
			System.out.println("cas3");
		} else if (Fenetre.getVal(3) == Fenetre.getVal(5)
				&& Fenetre.getVal(3) == Fenetre.getVal(7)
				&& Fenetre.getVal(3) != "") {
			winner = Fenetre.getVal(changedCase);
			System.out.println("cas4");
		} else if (frame.draw()) {
			winner = "draw";
			System.out.println("egalite");
		} else
			return null;

		if (winner == "")
			return null;
		else
			return winner;
	}

	@Override
	public void run() {
		frame.setVisible(true);

		// socketServeur = new DatagramSocket(Integer.parseInt(args[0]));

		try {
			ecoute = new ServerSocket(port);
			soc_com = ecoute.accept();

			System.out.println("\n Le serveur recoit sur le port : " + port);

			System.out.println(" " + soc_com.getInetAddress());
			InetAddress origin = soc_com.getInetAddress();
			System.out
					.println("Connection venant de : " + origin.getHostName());
			in = new BufferedReader(new InputStreamReader(
					soc_com.getInputStream()));
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(
					soc_com.getOutputStream())), true);

			System.out.println(">>> Serveur prêt ! ");

			while (true)
				Game();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	public static void setPort(String port) {
		Serveur.port = Integer.parseInt(port);
	}
}
