import java.awt.Insets;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class BtnLauncher extends JButton {

	public BtnLauncher(String image) {
		/**
		 * Create the click animation
		 */
		addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(MouseEvent arg0) {
				setBorder(new BevelBorder(BevelBorder.LOWERED, null, null,
						null, null));
			}

			@Override
			public void mouseReleased(MouseEvent arg0) {
				setBorder(new BevelBorder(BevelBorder.RAISED, null, null, null,
						null));
			}
		});

		setBorder(new BevelBorder(BevelBorder.RAISED, null, null, null, null));

		/**
		 * Set an image on the button
		 */
		setIcon(new ImageIcon(this.getClass().getResource(image)));

		setMargin(new Insets(0, 0, 0, 0));
	}

}
