/* Megadrive/Genesis - SGDK095 - 05/05/2014 - Toulouse
 Test affichage de sprites et leur animation avec la manipulation de la Vram

 Attention: BUG sur la console relle avec la mthode DMA

IMAGE nbres_image "nbres.png" 0

je ne vois pas comment obtenir une imaga  partie d'une planche de sprite, alors image par image :
IMAGE nbre0 "nbre0.bmp" 0
IMAGE nbre1 "nbre1.bmp" 0
IMAGE nbre2 "nbre2.bmp" 0
IMAGE nbre3 "nbre3.bmp" 0
IMAGE nbre4 "nbre4.bmp" 0
IMAGE nbre5 "nbre5.bmp" 0
IMAGE nbre6 "nbre6.bmp" 0
IMAGE nbre7 "nbre7.bmp" 0
IMAGE nbre8 "nbre8.bmp" 0
IMAGE nbre9 "nbre9.bmp" 0
*/

#include <genesis.h>
#include "gfx.h"
// sprites :
struct genresSprites
{
		u16 *pal; 		//pointer to pal data
		u32 **sprites;		//pointer to sprites data
		u16 count;		//nb sprites
		u16 width;		//width of each sprite in pixels
		u16 height;		//height of each sprite in pixels
		u16 size; 		//since we use width/height in pixel, useful info on sprite size
						//TODO : size is not SGDK compliant, you need to use size>>8
						//		will be fixed in coming release
};
extern struct genresSprites spsc;

// Tiles taille 8x8 pixels :
/* arf !
#include "nbre0.h"
#include "nbre1.h"
#include "nbre2.h"
#include "nbre3.h"
#include "nbre4.h"
#include "nbre5.h"
#include "nbre6.h"
#include "nbre7.h"
#include "nbre8.h"
#include "nbre9.h"
*/

// position sprite en Vram :
#define vrchif0   16  // taille 8x8 pixels soit 1 tile
#define vrchif1   17
#define vrchif2   18
#define vrchif3   19
#define vrchif4   20
#define vrchif5   21
#define vrchif6   22
#define vrchif7   23
#define vrchif8   24
#define vrchif9   25

#define vrsc   26

int main( )
{
    VDP_setPalette(PAL2, spsc.pal);

	/* chiffres de 0  9 :  nbres_image -> 9 images d'une taille de 8x8 pixels  */
    VDP_loadBMPTileData((u32*) &nbre0, vrchif0, 1, 1, 1); //  chiffre 0 arf !! -> extern const Image nbre0; -> je voudrais mettre cette image en VRam 16
    VDP_loadBMPTileData((u32*) &nbre1, vrchif1, 1, 1, 1); //  chiffre 1
    VDP_loadBMPTileData((u32*) &nbre2, vrchif2, 1, 1, 1); //  chiffre 2
    VDP_loadBMPTileData((u32*) &nbre3, vrchif3, 1, 1, 1); //  chiffre 3
    VDP_loadBMPTileData((u32*) &nbre4, vrchif4, 1, 1, 1); //  chiffre 4
    VDP_loadBMPTileData((u32*) &nbre5, vrchif5, 1, 1, 1); //  chiffre 5
    VDP_loadBMPTileData((u32*) &nbre6, vrchif6, 1, 1, 1); //  chiffre 6
    VDP_loadBMPTileData((u32*) &nbre7, vrchif7, 1, 1, 1); //  chiffre 7
    VDP_loadBMPTileData((u32*) &nbre8, vrchif8, 1, 1, 1); //  chiffre 8
    VDP_loadBMPTileData((u32*) &nbre9, vrchif9, 1, 1, 1); //  chiffre 9

    //VDP_drawImageEx(BPLAN, &nbres_image, TILE_ATTR_FULL(PAL0, FALSE, FALSE, FALSE, ind), 0, 0, FALSE, TRUE);

    VDP_loadTileData( spsc.sprites[0], vrsc, 2, 0); // texte: SC
    VDP_loadBMPTileData((u32*) &nbre0, 28, 1, 1, 1); //  centaine: chiffre 0
    VDP_loadBMPTileData((u32*) &nbre0, 29, 1, 1, 1); //  dizaine: chiffre 0
    VDP_loadBMPTileData((u32*) &nbre0, 30, 1, 1, 1); //  unit: chiffre 0

	SpriteDef mySprite1;
	SpriteDef mySprite2;

    // Sprite texte SC :
	mySprite1.posx = 136;mySprite1.posy = 16;
	mySprite1.size = SPRITE_SIZE(2,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite1.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, vrsc);
	mySprite1.link  = 1;
	VDP_setSpriteP(0, &mySprite1);
    // Sprite score  3 chiffres :
	mySprite2.posx = 160;mySprite2.posy = 16;
	mySprite2.size = SPRITE_SIZE(3,1);  //  a sprite 1x1 using 1 tile (8x8 pixels)
	mySprite2.tile_attr = TILE_ATTR_FULL(PAL2,1,0,0, 28);
	mySprite2.link  = 2;
	VDP_setSpriteP(1, &mySprite2);


	VDP_updateSprites();

    // *****************************

    u16 value; // pour le joypad
    u16 lachA;u16 lachB;u16 lachC;
    lachA=0;lachB=0;lachC=0;

    u16 pepete;u16 unite;u16 dizaine;u16 centaine;
    pepete=0;unite=0;dizaine=0;centaine=0;

    // chiffres via DMA, position en vram  modifier pour le sprite mySprite2 :
    u16 amdch[10];
    amdch[0] = 512;amdch[1] = 544;amdch[2] = 576;amdch[3] = 608;amdch[4] = 640;amdch[5] = 672;amdch[6] = 704;amdch[7] = 736;amdch[8] = 768;amdch[9] = 800;

    // *****************************
    // ***** Boucle principale *****
    // *****************************

	while(1)
	{

    value = JOY_readJoypad(JOY_1); // valeur du joypad joueur 1
    if (lachA==1)
        {
        if (!(value & BUTTON_A))            {lachA=0;}
        }
    if (lachB==1)
        {
        if (!(value & BUTTON_B))            {lachB=0;}
        }
    if (lachC==1)
        {
        if (!(value & BUTTON_C))            {lachC=0;}
        }

    if (lachA==0) // mthode DMA
        {
        if (value & BUTTON_A)
            {
            lachA=1;

            pepete += 1;
            unite = pepete % 10;
            dizaine = pepete / 10 % 10;
            centaine = pepete / 100 % 10;

            VDP_waitDMACompletion();VDP_doVRamDMACopy (amdch[centaine],896,32);
            VDP_waitDMACompletion();VDP_doVRamDMACopy (amdch[dizaine],928,32);
            VDP_waitDMACompletion();VDP_doVRamDMACopy (amdch[unite],960,32);

            VDP_setSpriteP(0, &mySprite1);
            }
        }

    if (lachB==0) // mthode BASIQUE
        {
		if (value & BUTTON_B)
			{
            lachB=1;

            pepete += 1;
            unite = pepete % 10;
            dizaine = pepete / 10 % 10;
            centaine = pepete / 100 % 10;

            if (unite == 0) {VDP_loadBMPTileData((u32*) &nbre0, 30, 1, 1, 1);}
            if (unite == 1) {VDP_loadBMPTileData((u32*) &nbre1, 30, 1, 1, 1);}
            if (unite == 2) {VDP_loadBMPTileData((u32*) &nbre2, 30, 1, 1, 1);}
            if (unite == 3) {VDP_loadBMPTileData((u32*) &nbre3, 30, 1, 1, 1);}
            if (unite == 4) {VDP_loadBMPTileData((u32*) &nbre4, 30, 1, 1, 1);}
            if (unite == 5) {VDP_loadBMPTileData((u32*) &nbre5, 30, 1, 1, 1);}
            if (unite == 6) {VDP_loadBMPTileData((u32*) &nbre6, 30, 1, 1, 1);}
            if (unite == 7) {VDP_loadBMPTileData((u32*) &nbre7, 30, 1, 1, 1);}
            if (unite == 8) {VDP_loadBMPTileData((u32*) &nbre8, 30, 1, 1, 1);}
            if (unite == 9) {VDP_loadBMPTileData((u32*) &nbre9, 30, 1, 1, 1);}

            if (dizaine == 0) {VDP_loadBMPTileData((u32*) &nbre0, 29, 1, 1, 1);}
            if (dizaine == 1) {VDP_loadBMPTileData((u32*) &nbre1, 29, 1, 1, 1);}
            if (dizaine == 2) {VDP_loadBMPTileData((u32*) &nbre2, 29, 1, 1, 1);}
            if (dizaine == 3) {VDP_loadBMPTileData((u32*) &nbre3, 29, 1, 1, 1);}
            if (dizaine == 4) {VDP_loadBMPTileData((u32*) &nbre4, 29, 1, 1, 1);}
            if (dizaine == 5) {VDP_loadBMPTileData((u32*) &nbre5, 29, 1, 1, 1);}
            if (dizaine == 6) {VDP_loadBMPTileData((u32*) &nbre6, 29, 1, 1, 1);}
            if (dizaine == 7) {VDP_loadBMPTileData((u32*) &nbre7, 29, 1, 1, 1);}
            if (dizaine == 8) {VDP_loadBMPTileData((u32*) &nbre8, 29, 1, 1, 1);}
            if (dizaine == 9) {VDP_loadBMPTileData((u32*) &nbre9, 29, 1, 1, 1);}

            if (centaine == 0) {VDP_loadBMPTileData((u32*) &nbre0, 28, 1, 1, 1);}
            if (centaine == 1) {VDP_loadBMPTileData((u32*) &nbre1, 28, 1, 1, 1);}
            if (centaine == 2) {VDP_loadBMPTileData((u32*) &nbre2, 28, 1, 1, 1);}
            if (centaine == 3) {VDP_loadBMPTileData((u32*) &nbre3, 28, 1, 1, 1);}
            if (centaine == 4) {VDP_loadBMPTileData((u32*) &nbre4, 28, 1, 1, 1);}
            if (centaine == 5) {VDP_loadBMPTileData((u32*) &nbre5, 28, 1, 1, 1);}
            if (centaine == 6) {VDP_loadBMPTileData((u32*) &nbre6, 28, 1, 1, 1);}
            if (centaine == 7) {VDP_loadBMPTileData((u32*) &nbre7, 28, 1, 1, 1);}
            if (centaine == 8) {VDP_loadBMPTileData((u32*) &nbre8, 28, 1, 1, 1);}
            if (centaine == 9) {VDP_loadBMPTileData((u32*) &nbre9, 28, 1, 1, 1);}

            VDP_setSpriteP(0, &mySprite1);
            }
        }


    VDP_drawText("BOUTON A = DMA ; BOUTON B = BASIQUE", 2, 0);

	VDP_updateSprites();
	VDP_waitVSync();
	}
	return 0;
}

