;###################################
;#DRAW PLAYER
;# playerSprites: address where sprites are stored
;# playerY: player's y coordinate on screen (range between $10-$20) 
;# playerX: x coord (range: $10-$40 or $20-$30, haven't decided yet) 
;###################################

drawPlayer:
    ld ix,playerSprites
    ld hl,yCoord
playerY = $+1
    ld a,10
    sub (hl)        ;subtract map's y coordinates from our player to draw player correctly on the map
    ld l,a
    ld h,0
    ld d,h
    ld b,h
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl       ;x16
playerYOff = $+1
    ld e,0
    add hl,de
    ld e,l
    ld d,h
    add hl,hl        ;y*2
    add hl,de        ;y*3
    add hl,hl        ;y*6
    add hl,de        ;y*7
    add hl,hl        ;y*14
    ld de,saferam1+2 ;86EC
    add hl,de
    ld a,(xCoord)
    neg
playerX = $+1
    add a,10
    ld c,a
    sla c
playerXOff = $+1
    ld a,0
    cp 8
    jr c,$+3
    inc c           ;if XOff >= 8, move one byte over
    add hl,bc       ;hl = starting point in gbuf
    and $7
    ld c,16
    ld b,a
drawPlayerLoop:
   push bc
drawPlayerRow
   ld d,(ix+32)   ;sprite mask
   ld e,(ix+33)
   ld a,$ff
   dec b \ inc b \ jr z,skipMaskClip
   scf \ rr d \ rr e \ rra \ djnz $-6   ;rotate mask
skipMaskClip:
   and (hl)
   ld (hl),a
   dec hl
   ld a,(hl)
   and e
   ld (hl),a
   dec hl
   ld a,(hl)
   and d
   ld (hl),a
   pop bc
   inc hl
   inc hl
   push bc
   ld d,(ix)      ;sprite
   ld e,(ix+1)
   xor a
   cp b
   jp z,skipSpriteClip
   srl d \ rr e \ rra \ djnz $-5   ;rotate sprite
skipSpriteClip:
   or (hl)
   ld (hl),a
   dec hl
   ld a,(hl)
   or e
   ld (hl),a
   dec hl
   ld a,(hl)
   or d
   ld (hl),a
   inc ix
   inc ix
   ld de,16
   add hl,de
   pop bc
   dec c
   jp nz, drawPlayerLoop
   ret