passedGo:
    push af
    ld hl,textGO
    call drawText
    pop af
    ret

landProperty:
    ld a,(hl)
    inc hl
    ld h,(hl)
    ld l,a
    call drawText
    ret


;#############################
;#MOVEPLAYER
;#Advance player through the board
;#############################
movePlayer:
    call randomNumber

    push hl
    ld a,h
    add a,a     ;x2
    add a,a     ;x4
    add a,h     ;x5
    add a,a     ;x10
    add a,l
    ld l,a
    ld h,0
    call dispNumber
    pop hl

    ld a,l
    add a,h
    ld b,a
mP_loop:
    push bc
playerDir = $+1
    ld a,0
    ld hl,mP_return
    push hl                 ;ret jumps to the last address on the stack, so ret will now return us to mP_return
    or a                    ;check player direction
    jr z,movePlayerLeft
    dec a
    jr z,movePlayerUp
    dec a
    jr z,movePlayerRight
    jp movePlayerDown
;This section basically handles checks for the corners and passing GO
mP_return:
    call retrievePlayerBrush
    inc hl                  ;first byte is the sprite# byte
    ld a,(hl)
    inc hl                  ;skip the action byte
    rra                     ;check if bit 0=1 (%00000001), aka change of direction
    jr nc,$+8
        ex af,af'
        ld a,(hl)
        ld (playerDir),a    ;update player direction
        ex af,af'
    rra                     ;bit 1, GO
    call c,passedGo
    pop bc  
    djnz mP_loop
    rra                     ;bit 2, chance
    rra                     ;bit 3, comm chest
    rra                     ;bit 4, property
    jr c,landProperty
    rra                     ;bit 5, rr
    rra                     ;bit 6, util

    ret

;##########################
;#MOVEPLAYERLEFT
;#As the name suggests, moves the player left one
;# tile, scrolling 2 pixels at a time.
;#input: none
;#output: none
;##########################
movePlayerLeft:
    ld a,HRZ_SCROLL         ;when to scroll the map with the player
    ld (mPL_adjustCP),a     ;really ugly way to solve the problem, but it'll have to do for now
    ld hl,playerX
    dec (hl)
    ld b,8
mPL_loop:
    ld hl,playerXOff
    ld a,(hl)
    sub 2
    and $0F
    ld (hl),a

    ld hl,xCoord
    ld a,(playerX)
    sub (hl)
mPL_adjustCP = $+1
    cp HRZ_SCROLL
    push bc
        call c,mapLeft

        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPL_loop
    ret

;##########################
;#MOVEPLAYERUP
;#Moves the player up one tile, scrolling 2 pixels
;# at a time.
;#input: none
;#output: none
;##########################
movePlayerUp:
    ld a,VERT_SCROLL
    ld (mPU_adjustCP),a     ;really ugly way to solve the problem, but it'll have to do for now
    ld hl,playerY
    dec (hl)
    ld b,8
mPU_loop:
    ld hl,playerYOff
    ld a,(hl)
    sub 2
    and $0F
    ld (hl),a

    ld hl,yCoord
    ld a,(playerY)
    sub (hl)
mPU_adjustCP = $+1
    cp VERT_SCROLL
    push bc
        call c,mapUp

        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPU_loop
    ret

;##########################
;#MOVEPLAYERRIGHT
;#Moves the player right one tile, scrolling 2 pixels
;# at a time.
;#input: none
;#output: none
;##########################
movePlayerRight:
    ld b,8
mPR_loop:
    ld hl,xCoord
    ld a,(playerX)
    sub (hl)
    cp (COLUMNS_TO_DRAW-2)-HRZ_SCROLL
    push bc
        call nc,mapRight
        ld hl,playerXOff
        ld a,(hl)
        add a,2
        and $0F
        ld (hl),a
        jr nz,$+6
            ld hl,playerX
            inc (hl)
        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPR_loop
    ret

;##########################
;#MOVEPLAYERDOWN
;#Moves the player down one tile, scrolling 2 pixels
;# at a time.
;#input: none
;#output: none
;##########################
movePlayerDown:
    ld b,8
mPD_loop:
    ld hl,yCoord
    ld a,(playerY)
    sub (hl)
    cp 3-VERT_SCROLL
    push bc
        call nc,mapDown
    ld hl,playerYOff
    ld a,(hl)
    add a,2
    and $0F
    ld (hl),a
    jr nz,$+6
        ld hl,playerY
        inc (hl)

        call drawMap
        call drawPlayer
        call drawGBuf
    pop bc
    djnz mPD_loop
    ret

;##################
;#RANDOMNUMBER
;#Returns two random numbers between 1 and 6
;#input: none
;#output: h and l= "random" number
;##################
randomNumber:
    ld l,2
rN_loop:
    ld h,b          ;store the first random number. first runthrough will be a junk value.
seed = $+1
    ld  b,0         ;the "seed"
    ld  a,r         ;our random number base
    add a,b
    inc a           ;just playing with the number
    ld  (seed),a    ;update the seed
    ld b,0          ;255/6 = 42.xx, so we round up.
    inc b           ;inc b every time we subtract 43 from a. (0-42=1, 43-85=2, 85-127=3, etc.)
    sub 43          ;Basically, we are dividing the number by 6 and storing the result in b.
    jr nc,$-3       ;repeat until
    dec l
    jr nz,rN_loop
    ld l,b
    ret
