;#########################################
;#
;#THIS WHOLE SECTION SHOULD BE OPTIMIZED AND THE ALPHABET RESTRUCTURED
;#
;#########################################

rotateLetter:
.db %11110000,5 \ .dw rotateLeft        ;even,  0-42
.db %11110000,5 \ .dw rotateRight       ;odd,   0-43
.db %11111000,6 \ .dw rotateLeft        ;even,  44-
.db %11100000,4 \ .dw rotateRight+1     ;odd,   45-
.db %11000000,3 \ .dw rotateLeft
.db %11000000,3 \ .dw rotateLeft+2
.db %11000000,3 \ .dw rotateRight
.db %11000000,3 \ .dw rotateRight+2
.db %11100000,4 \ .dw rotateLeft
.db %11100000,4 \ .dw rotateLeft+3
.db %11000000,3 \ .dw rotateRight+2

drawLine:
    ld a,(letRow)
    add a,b
    call getTextRow
    inc hl
    ld a,%01111111
    or (hl)
    ld (hl),a
    inc hl
    ld a,$FF
    ld b,8
lineLoop:
    ld (hl),a
    inc hl
    djnz lineLoop
    ld a,%11111110
    or (hl)
    ld (hl),a
    ret 
        
;#############################
;#DRAWTEXT
;#Display text to the screen
;# surrounded by a box
;#input: hl - address to text
;#############################
drawText:
    ld a,12
    ld (letRow),a       ;initialize row/column values
    ld (letCol),a
    push hl             ;hl points to text string
    call clearRow       ;draw the sides of the textbox
    ld b,-2             ;where to draw the horizontal line in relation to letRow
    call drawLine       ;draw the top part of the box
    pop hl
drawText_skipInit:
    ld a,(hl)           ;get the letter ID
dT_loop:
    push hl
    call sacarLetra     ;get information on the letter
    ex af,af'
        ld a,(hl)       ;mask
        ld (mascLet),a
        inc hl
        ld a,(hl)
        ld (addSpace),a ;letter width (in pixels)
    ex af,af'
    inc hl
    ld c,(hl)           ;rotate address pointer (1st byte)
    inc hl
    ld h,(hl)           ;2nd byte
    ld l,c
    ld de,letRotate
    ldi
    ldi
    ldi
    ldi
    ld e,a
    ld d,0
    ld hl,alfabeto
    add hl,de
    add hl,de
    add hl,de
    add hl,de
    add hl,de       ;x5
    call dibLetra       ;draw the letter to the gbuf
    pop hl
    ld a,(letCol)
addSpace = $+1
    add a,5             ;smc: letterwidth
    ld (letCol),a
    inc hl
    ld a,(hl)           ;the next letter
    cp $FF
    jr z,dT_quit
    cp $FD              ;$FD = don't draw the box
    jp z,wait2nd
    cp $FE
    jr nz,dT_loop
    inc hl
    exx
        ld hl,letCol
        inc (hl)
    exx
    call contarLetras   ;count the size of the word, if we need to wrap or not.
    ld a,(hl)
    jr dT_loop

dT_quit:
    ld b,7              ;where to draw the horizontal line in relation to letRow
    call drawLine       ;draw the top part of the box
    jp wait2nd

;read from table until reach FE/FF then check if passes for example 94
contarLetras:
    push hl
    ld a,(letCol)
contarBucle:
    ld b,a
    ld a,(hl)
    cp $FE              ;cual letra tenemos
    jr nc,exitLetras    ;palabra cabe
    exx
        call sacarLetra
        inc hl              ;anchura de la letra
        ld a,(hl)
    exx
    inc hl
    add a,b
    cp 86
    jr c,contarBucle
;newline
    ld hl,letRow
    ld a,(hl)
    add a,6
    ld (hl),a
    ld hl,letCol
    ld (hl),12
    call clearRow   ;a=row to clear
exitLetras:
    pop hl
    ret

;##############################
;#CLEARROW
;#Clears a row and draws the text box
;#input: a = row number
;##############################
clearRow:
    dec a
    call getTextRow
    inc hl
    ld c,8
cB_outLoop
    ld b,8
    ld (hl),%11000000
    inc hl
cB_inLoop:
    ld (hl),a
    inc hl
    djnz cB_inLoop
    ld (hl),%00000011
    ld de,5
    add hl,de
    dec c
    jr nz,cB_outLoop
    ret

;##########################
;#GETTEXTROW
;#Get the address of the row in the gbuf
;# pointed to by letRow
;##########################
getTextRow:
    ld e,a          ;a = row
    xor a
    ld d,a
    ld l,e
    ld h,d
    add hl,hl       ;x2
    add hl,de       ;x3
    add hl,hl       ;x6
    add hl,de       ;x7
    add hl,hl       ;x14
    ld de,saferam1
    add hl,de
    ret

;###########################
;#SACARLETRA
;#Get correct address from rotateletter
;#input: a = letter
;#output hl=correct address
;###########################
sacarLetra:
    or a            ;reset carry flag
    rra             ;/2
    ld hl,rotateLetter
    ld de,4         ;each row of data in rotateLetter is 4 bytes
    jr nc,letPar    ;is the letter even/odd? nc = even
    add hl,de
letPar:
    ld e,8
    cp 22           ;letters 0-43 (remember, it's divided by 2) use the first/second row
    ret c           ; depending on whether or not it's an odd number
    add hl,de

    cp 31           ;letters 44-61: 3rd/4th row
    ret c
    add hl,de
    cp 32           ;62 and 63: 5th/6th row
    ret c
    dec a
    add hl,de
    cp 32
    ret c
    add hl,de
    cp 33
    ret c
    dec a
    add hl,de
    ret

dibLetra:
    exx
        ld hl,0
letRow = $+1            ;basically, penrow
        ld e,0
        ld d,l          ;d=0
        ld b,l          ;b=0
        add hl,de
        add hl,hl       ;y*2
        add hl,de       ;y*3
        add hl,hl       ;y*6
        add hl,de       ;y*7
        add hl,hl       ;y*14
        
        ld de,saferam1
        add hl,de
letCol = $+1            ;"pencol"
        ld a,0
        ld c,a          ;remember, b=0
        and $7          ;offset
        srl c
        srl c
        srl c           ;/8
        add hl,bc       ;hl = starting point in gbuf
        ld b,a
    exx
   ld c,5
letBucle:
    ld a,(hl)           ;sprite
letRotate:              ;we need to rotate the sprite
    nop
    nop
    nop
    nop
mascLet = $+1           ;a mask to ensure the bits underneath our sprite are empty
    and $F0
    exx
        ld e,b                  ;guardar b
        ld d,0
        dec b \ inc b           ;offset = 0?
        jr z,skipClip
        rra \ rr d \ djnz $-3   ;rotate sprite
        ld b,e
skipClip:
        or (hl)
        ld (hl),a
        inc hl
        ld a,d
        or (hl)
        ld (hl),a
        ld de,13
        add hl,de
    exx
    inc hl
    dec c
    jp nz, letBucle
    ret


;##########################
;#WAIT2ND
;#Wait for the 2nd key to be pressed.
;# If 2nd is currently held, we first
;# wait for it to be released then
;# check if it has been pressed again.
;# Also, displays the gbuf
;##########################
wait2nd:
    call drawgbuf
    call wait2ndReleased
    ld a,$BF        ;group 7
    out (1),a
w2_loop:
    in a,(1)
    cp 223          ;2nd
    jr nz,w2_loop   ;if 2nd isn't pressed, repeat loop
    call wait2ndReleased
    ret

wait2ndReleased:
    ld a,$BF        ;group 7
    out (1),a
w2R_loop:
    in a,(1)
    cp 223          ;2nd
    jr z,w2R_loop
    ret

;#######################
;#DISPNUMBER
;#Display the number stored in HL
;#input: hl = number to display
;#######################
dispNumber:
    exx
        ld de,numberText2
    exx
    ld de,-10000
    call dN_b2d
    ld de,-1000
    call dN_b2d
    ld de,-100
    call dN_b2d
    ld de,-10
    call dN_b2d
    ld de,-1
    call dN_b2d

    ld a,20
    ld (letRow),a
    ld (letCol),a

    ld hl,numberText2
    call drawText_skipInit
    ret

dN_b2d:
    ld a,-1
dN_b2dloop:
    inc a
    add hl,de
    jr c,dN_b2dloop
    or a
    sbc hl,de
    exx
        ld hl,numberTable
        ld b,0
        ld c,a
        add hl,bc       ;hl=numberTable, bc = number of units
        ldi
    exx
    ret

numberTable:
.db 10,57,36,37,38,39,40,41,42,43
numberText2:
.db 0,0,0,0,0,$FD