/*
** pencil.c for pencil in /pencil
**
** Made by remi caput
** Login   <caput_r@epita.fr>
**
** Started on  Fri Nov  4 20:57:07 2005 remi caput
** Last update Sat Nov 12 21:36:44 2005 remi caput
*/

#include "pencil.h"



/*
** Pencil global variable
*/
pl_internal	gl_pl_internal;



/*
** Clear screen
*/
void			PL_Clear(void)
{
	SDL_Surface	*screen = gl_pl_internal.screen;

	memset(screen->pixels, 0, gl_pl_internal.screen_x * screen->format->BytesPerPixel + gl_pl_internal.screen_y * screen->pitch);
}



/*
** Create color from red, green and blue components
*/
pl_color	PL_Color(pl_integer r, pl_integer g, pl_integer b)
{
	return SDL_MapRGB(gl_pl_internal.screen->format, r, g, b);
}



/*
** Draw a line on the screen
*/
void	PL_DrawLine(pl_integer x1, pl_integer y1, pl_integer x2, pl_integer y2, pl_color color)
{
	int	i;

	if (x1 == x2)
	{
		if (y1 < y2)
			for (i = y1; i <= y2; ++i)
				PL_DrawPixel(x1, i, color);
		else
			for (i = y2; i <= y1; ++i)
				PL_DrawPixel(x1, i, color);
	}
	else if (abs(x1 - x2) > abs(y1 - y2))
	{
		if (x1 < x2)
			for (i = x1; i <= x2; ++i)
				PL_DrawPixel(i, y1 + (y2 - y1) * (i - x1) / (x2 - x1), color);
		else
			for (i = x2; i <= x1; ++i)
				PL_DrawPixel(i, y2 + (y1 - y2) * (i - x2) / (x1 - x2), color);
	}
	else
	{
		if (y1 < y2)
			for (i = y1; i <= y2; ++i)
				PL_DrawPixel(x1 + (x2 - x1) * (i - y1) / (y2 - y1), i, color);
		else
			for (i = y2; i <= y1; ++i)
				PL_DrawPixel(x2 + (x1 - x2) * (i - y2) / (y1 - y2), i, color);
	}
}



/*
** Put a pixel on the screen
*/
void			PL_DrawPixel(pl_integer x, pl_integer y, pl_color color)
{
	SDL_Surface	*screen = gl_pl_internal.screen;
	char		*buffer = screen->pixels;

	if (x >= 0 && y >= 0 && x < gl_pl_internal.screen_x && y < gl_pl_internal.screen_y)
	{
		if (SDL_MUSTLOCK(screen))
			if (SDL_LockSurface(screen) < 0)
				return;
		switch (screen->format->BytesPerPixel)
		{
			case 1:
				*(char *)(buffer + y * screen->pitch + x) = color;
				break;
			case 2:
				*(short *)(buffer + y * screen->pitch + x * 2) = color;
				break;
			case 3:
				*(long *)(buffer + y * screen->pitch + x * 3) = color;
				break;
			case 4:
				*(long *)(buffer + y * screen->pitch + x * 4) = color;
				break;
		}
		if (SDL_MUSTLOCK(screen))
			SDL_UnlockSurface(screen);
	}
}



/*
** Init library
*/
int			PL_Init(char *title, pl_integer x, pl_integer y)
{
	int		flags;

	flags = SDL_HWSURFACE | SDL_DOUBLEBUF;
	if (SDL_Init(SDL_INIT_AUDIO | SDL_INIT_VIDEO) >= 0)
		if ((gl_pl_internal.screen = SDL_SetVideoMode(x, y, 16, flags)))
		{
			SDL_WM_SetCaption(title, NULL);
			memset(gl_pl_internal.key, 0, PL_COUNT_KEY * sizeof (*gl_pl_internal.key));
			gl_pl_internal.img_count = 0;
			gl_pl_internal.img_index = 0;
			gl_pl_internal.img_list = NULL;
			gl_pl_internal.screen_x = x;
			gl_pl_internal.screen_y = y;
			gl_pl_internal.quit = 0;
			gl_pl_internal.time = SDL_GetTicks();
			return 0;
		}
	return 1;
}



/*
** Load BMP image
*/
int				PL_LoadImage(char *path, SDL_Surface **image)
{
	SDL_Surface	**new;
	SDL_Surface	*temp;

	if (!(temp = SDL_LoadBMP(path)))
		return 1;
	if (!(*image = SDL_DisplayFormat(temp)))
		return 1;
	SDL_FreeSurface(temp);
	if (gl_pl_internal.img_index == gl_pl_internal.img_count)
	{
		gl_pl_internal.img_count += PL_IMAGE_REALLOC;
		if (!(new = realloc(gl_pl_internal.img_list, gl_pl_internal.img_count * sizeof(gl_pl_internal.img_list))))
		{
			if (gl_pl_internal.img_list)
				free(gl_pl_internal.img_list);
			return 1;
		}
		gl_pl_internal.img_list = new;
	}
	gl_pl_internal.img_list[gl_pl_internal.img_index++] = *image;
	return 0;
}



/*
** Get events and refresh screen
*/
int				PL_Loop(void)
{
	SDL_Event	event;

	while (SDL_GetTicks() - gl_pl_internal.time < PL_TIME_SYNC);
		gl_pl_internal.time = SDL_GetTicks();
	while (SDL_PollEvent(&event))
	{
		if (event.type == SDL_KEYDOWN)
			gl_pl_internal.key[event.key.keysym.sym] = 1;
		else if (event.type == SDL_KEYUP)
			gl_pl_internal.key[event.key.keysym.sym] = 0;
		else if (event.type == SDL_QUIT)
		{
			gl_pl_internal.quit = 1;
			return 1;
		}
	}
	SDL_Flip(gl_pl_internal.screen);
	return 0;
}



/*
** Unload library
*/
void	PL_Stop(void)
{
	while (gl_pl_internal.img_index)
		SDL_FreeSurface(gl_pl_internal.img_list[--gl_pl_internal.img_index]);
	if (gl_pl_internal.img_list)
		free(gl_pl_internal.img_list);
	SDL_FreeSurface(gl_pl_internal.screen);
	SDL_Quit();
}
