/*
** volume.h for volume in /volume
**
** Made by remi caput
** Login   <caput_r@epita.fr>
**
** Started on  Sat Nov 12 21:55:58 2005 remi caput
** Last update Sat Nov 12 22:53:16 2005 remi caput
*/

#ifndef VOLUME_H_
#define VOLUME_H_

#include <math.h>
#include <stdlib.h>

#define VL_ANGLE 256
#define VL_DBLPI 6.28318531
#define VL_SHIFT 8
#define VL_WORLD 128

#if VL_SHIFT == 0
#define VL_COS(A) (cos(A))
#define VL_DIV(N) (N)
#define VL_MUL(N) (N)
#define VL_UNIT float
#define VL_SIN(A) (sin(A))
#else
#define VL_COS(A) (gl_vl_internal.angle[(unsigned)(A) % 256])
#define VL_DIV(N) ((N) >> VL_SHIFT)
#define VL_MUL(N) ((N) << VL_SHIFT)
#define VL_UNIT int
#define VL_SIN(A) (gl_vl_internal.angle[(unsigned)(A) % 256 + VL_ANGLE])
#endif

typedef VL_UNIT		vl_coord;
typedef int			vl_integer;
typedef vl_coord	vl_matrix[16];
typedef vl_coord	*vl_matrix_p;

typedef struct
{
	vl_coord	x;
	vl_coord	y;
}	vl_vector2D;

typedef struct
{
	vl_coord	x;
	vl_coord	y;
	vl_coord	z;
}	vl_vector3D;

typedef struct
{
	vl_matrix	a;
	vl_matrix	b;
	vl_matrix_p	matrix;
}	vl_world;

typedef struct
{
#if VL_SHIFT != 0
  vl_coord		*angle;
#endif
  vl_coord		focal_x;
  vl_coord		focal_y;
  vl_integer	depth;
  vl_integer	screen_x;
  vl_integer	screen_y;
  vl_matrix_p	matrix;
  vl_world		*world;
} vl_internal;

void	VL_Convert(vl_vector2D *, vl_vector3D *);
int		VL_Init(vl_integer, vl_integer);
void	VL_Loop(void);
void	VL_MatPop(void);
void	VL_MatPush(void);
void	VL_MatReset(void);
void	VL_MatRotateX(vl_coord);
void	VL_MatRotateY(vl_coord);
void	VL_MatRotateZ(vl_coord);
void	VL_MatTranslate(vl_coord, vl_coord, vl_coord);
void	VL_MatZoom(vl_coord);
void	VL_Stop(void);

#endif /* !VOLUME_H_ */
