/*
** test.c for test in /test
**
** Made by remi caput
** Login   <caput_r@epita.fr>
**
** Started on  Sat Nov 12 16:07:24 2005 remi caput
** Last update Sat Nov 12 23:32:40 2005 remi caput
*/

#include "pencil.h"
#include "volume.h"

extern pl_internal	gl_pl_internal;

#define NB_DOTS 8

int				WinMain(void)
{
	vl_vector3D	object[NB_DOTS] =
	{
		{-2, 2,-2},
		{ 2, 2,-2},
		{ 2,-2,-2},
		{-2,-2,-2},
		{-2, 2, 2},
		{ 2, 2, 2},
		{ 2,-2, 2},
		{-2,-2, 2}
	};
	vl_vector2D	dot[NB_DOTS];
	float		px = 0;
	float		pz = -(10 << VL_SHIFT);
	float		rx = 0;
	float		ry = 0;
	int			i;
	int			j;
	int			n;

	if (PL_Init("Cube", 640, 480) || VL_Init(640, 480))
		return 1;
	while (!PL_Loop())
	{
		PL_Clear();
		for (n = 0; n < 5; ++n)
		{
			VL_MatPush();
			VL_MatTranslate(px, 0, pz);
			VL_MatRotateX(-ry * (1 << VL_SHIFT));
			VL_MatRotateY(rx * (1 << VL_SHIFT));
			for (i = 0; i < NB_DOTS; ++i)
				VL_Convert(&dot[i], &object[i]);
			for (i = 0; i < NB_DOTS; ++i)
				for (j = 0; j < NB_DOTS; ++j)
					if (i != j)
						PL_DrawLine(dot[i].x, dot[i].y, dot[j].x, dot[j].y, PL_Color(255 - n * 25, n * 25, 0));
		}
		if (gl_pl_internal.key[SDLK_UP])
			pz += 0.1 * (1 << VL_SHIFT);
		if (gl_pl_internal.key[SDLK_DOWN])
			pz -= 0.1 * (1 << VL_SHIFT);
		if (gl_pl_internal.key[SDLK_LEFT])
			px -= 0.1 * (1 << VL_SHIFT);
		if (gl_pl_internal.key[SDLK_RIGHT])
			px += 0.1 * (1 << VL_SHIFT);
		if (gl_pl_internal.key['d'])
			rx += 0.01;
		if (gl_pl_internal.key['a'])
			rx -= 0.01;
		if (gl_pl_internal.key['w'])
			ry += 0.01;
		if (gl_pl_internal.key['s'])
			ry -= 0.01;
		VL_Loop();
	}
	PL_Stop();
	VL_Stop();
	return 0;
}
