/*
** pencil.h for pencil in /pencil
**
** Made by remi caput
** Login   <caput_r@epita.fr>
**
** Started on  Fri Nov  4 21:16:15 2005 remi caput
** Last update Sat Nov 12 16:14:49 2005 remi caput
*/

#ifndef PENCIL_H_
# define PENCIL_H_

# include <SDL/SDL.h>
# include <stdlib.h>
# include <string.h>
# include <time.h>

# define PL_COUNT_KEY 512
# define PL_IMAGE_REALLOC 32
# define PL_TIME_SYNC 20

typedef unsigned	pl_color;
typedef int			pl_integer;

typedef struct
{
	SDL_Surface	**img_list;
	SDL_Surface	*screen;
	char		key[PL_COUNT_KEY];
	int			img_count;
	int			img_index;
	char		quit;
	int			screen_x;
	int			screen_y;
	int			time;
} pl_internal;

void		PL_Clear(void);
pl_color	PL_Color(pl_integer, pl_integer, pl_integer);
void		PL_DrawLine(pl_integer, pl_integer, pl_integer, pl_integer, pl_color);
void		PL_DrawPixel(pl_integer, pl_integer, pl_color);
int			PL_Init(char *, pl_integer, pl_integer);
int			PL_LoadImage(char *, SDL_Surface **);
int			PL_Loop(void);
void		PL_Stop(void);

#endif /* !SYSTEM_H_ */
