/*
** volume.c for volume in /volume
**
** Made by remi caput
** Login   <caput_r@epita.fr>
**
** Started on  Sat Nov 12 22:29:36 2005 remi caput
** Last update Sat Nov 12 23:12:39 2005 remi caput
*/

#include "volume.h"



/*
** Volume global variable
*/
vl_internal	gl_vl_internal;



/*
** Multiply current matrix by a new one
*/
static void		VLI_MatMultiply(vl_matrix mat)
{
	vl_world	*world = gl_vl_internal.world + gl_vl_internal.depth - 1;
	vl_matrix_p	new = gl_vl_internal.matrix == world->a ? world->b : world->a;
	vl_matrix_p	old = gl_vl_internal.matrix;

	gl_vl_internal.matrix = world->matrix = new;
	new[0] = VL_DIV(old[0] * mat[0] + old[1] * mat[4] + old[2] * mat[8] + old[3] * mat[12]);
	new[4] = VL_DIV(old[4] * mat[0] + old[5] * mat[4] + old[6] * mat[8] + old[7] * mat[12]);
	new[8] = VL_DIV(old[8] * mat[0] + old[9] * mat[4] + old[10] * mat[8] + old[11] * mat[12]);
	new[12] = VL_DIV(old[12] * mat[0] + old[13] * mat[4] + old[14] * mat[8] + old[15] * mat[12]);
	new[1] = VL_DIV(old[0] * mat[1] + old[1] * mat[5] + old[2] * mat[9] + old[3] * mat[13]);
	new[5] = VL_DIV(old[4] * mat[1] + old[5] * mat[5] + old[6] * mat[9] + old[7] * mat[13]);
	new[9] = VL_DIV(old[8] * mat[1] + old[9] * mat[5] + old[10] * mat[9] + old[11] * mat[13]);
	new[13] = VL_DIV(old[12] * mat[1] + old[13] * mat[5] + old[14] * mat[9] + old[15] * mat[13]);
	new[2] = VL_DIV(old[0] * mat[2] + old[1] * mat[6] + old[2] * mat[10] + old[3] * mat[14]);
	new[6] = VL_DIV(old[4] * mat[2] + old[5] * mat[6] + old[6] * mat[10] + old[7] * mat[14]);
	new[10] = VL_DIV(old[8] * mat[2] + old[9] * mat[6] + old[10] * mat[10] + old[11] * mat[14]);
	new[14] = VL_DIV(old[12] * mat[2] + old[13] * mat[6] + old[14] * mat[10] + old[15] * mat[14]);
	new[3] = VL_DIV(old[0] * mat[3] + old[1] * mat[7] + old[2] * mat[11] + old[3] * mat[15]);
	new[7] = VL_DIV(old[4] * mat[3] + old[5] * mat[7] + old[6] * mat[11] + old[7] * mat[15]);
	new[11] = VL_DIV(old[8] * mat[3] + old[9] * mat[7] + old[10] * mat[11] + old[11] * mat[15]);
	new[15] = VL_DIV(old[12] * mat[3] + old[13] * mat[7] + old[14] * mat[11] + old[15] * mat[15]);
}



/*
** Convert 3D coords to 2D coords according to current matrix
*/
void			VL_Convert(vl_vector2D *dest, vl_vector3D *src)
{
	vl_matrix_p	mat = gl_vl_internal.matrix;
/*	vl_coord	w = mat[12] * src->x + mat[13] * src->y + mat[14] * src->z + mat[15]; */
	vl_vector3D	trans;

	if (mat == NULL)
		trans = *src;
	else
	{
		trans.x = mat[0] * src->x + mat[1] * src->y + mat[2] * src->z + mat[3];
		trans.y = mat[4] * src->x + mat[5] * src->y + mat[6] * src->z + mat[7];
		trans.z = mat[8] * src->x + mat[9] * src->y + mat[10] * src->z + mat[11];
/*		if (w)
		{
			trans.x /= w;
			trans.y /= w;
			trans.z /= w;
		}*/
	}
	if (!trans.z)
		trans.z = 1;
	dest->x = (gl_vl_internal.screen_x >> 1) - gl_vl_internal.focal_x * trans.x / trans.z;
	dest->y = (gl_vl_internal.screen_y >> 1) + gl_vl_internal.focal_y * trans.y / trans.z;
}



/*
** Init library
*/
int		VL_Init(vl_integer x, vl_integer y)
{
#if VL_SHIFT != 0
	int	i;

	if ((gl_vl_internal.angle = malloc(VL_ANGLE * 2 * sizeof (*gl_vl_internal.angle))))
	{
		for (i = 0; i < VL_ANGLE; ++i)
		{
			gl_vl_internal.angle[i] = cos(i * VL_DBLPI / VL_ANGLE) * (1 << VL_SHIFT);
			gl_vl_internal.angle[i + VL_ANGLE] = sin(i * VL_DBLPI / VL_ANGLE) * (1 << VL_SHIFT);
		}
#endif
		if ((gl_vl_internal.world = malloc(VL_WORLD * sizeof (*gl_vl_internal.world))))
		{
			gl_vl_internal.depth = 0;
			gl_vl_internal.focal_x = (x + y) >> 1;
			gl_vl_internal.focal_y = (x + y) >> 1;
			gl_vl_internal.matrix = gl_vl_internal.world[0].a;
			gl_vl_internal.screen_x = x;
			gl_vl_internal.screen_y = y;
			VL_MatPush();
			VL_MatReset();
			return 0;
		}
#if VL_SHIFT != 0
		free(gl_vl_internal.angle);
	}
#endif
	return 1;
}



/*
** Loop
*/
void	VL_Loop(void)
{
	gl_vl_internal.depth = 1;
	gl_vl_internal.matrix = gl_vl_internal.world[0].matrix;
}



/*
** Pop matrix
*/
void	VL_MatPop(void)
{
	if (gl_vl_internal.depth > 1)
		gl_vl_internal.matrix = gl_vl_internal.world[--gl_vl_internal.depth - 1].matrix;
}



/*
** Push matrix
*/
void	VL_MatPush(void)
{
	if (gl_vl_internal.depth < VL_WORLD)
		gl_vl_internal.world[gl_vl_internal.depth++].matrix = gl_vl_internal.matrix;
}



/*
** Reset current matrix, set identity
*/
void	VL_MatReset(void)
{
	vl_world	*world = gl_vl_internal.world + gl_vl_internal.depth - 1;
	vl_matrix_p	new = gl_vl_internal.matrix == world->a ? world->b : world->a;

	gl_vl_internal.matrix = world->matrix = new;
	new[0] = VL_MUL(1);
	new[1] = 0;
	new[2] = 0;
	new[3] = 0;
	new[4] = 0;
	new[5] = VL_MUL(1);
	new[6] = 0;
	new[7] = 0;
	new[8] = 0;
	new[9] = 0;
	new[10] = VL_MUL(1);
	new[11] = 0;
	new[12] = 0;
	new[13] = 0;
	new[14] = 0;
	new[15] = 0;
}



/*
** Rotate matrix on X axis
*/
void			VL_MatRotateX(vl_coord angle)
{
	vl_matrix	mat;

	mat[0] = VL_MUL(1);
	mat[1] = 0;
	mat[2] = 0;
	mat[3] = 0;
	mat[4] = 0;
	mat[5] = VL_COS(angle);
	mat[6] = -VL_SIN(angle);
	mat[7] = 0;
	mat[8] = 0;
	mat[9] = VL_SIN(angle);
	mat[10] = VL_COS(angle);
	mat[11] = 0;
	mat[12] = 0;
	mat[13] = 0;
	mat[14] = 0;
	mat[15] = VL_MUL(1);
	VLI_MatMultiply(mat);
}



/*
** Rotate matrix on Y axis
*/
void			VL_MatRotateY(vl_coord angle)
{
	vl_matrix	mat;

	mat[0] = VL_COS(angle);
	mat[1] = 0;
	mat[2] = VL_SIN(angle);
	mat[3] = 0;
	mat[4] = 0;
	mat[5] = VL_MUL(1);
	mat[6] = 0;
	mat[7] = 0;
	mat[8] = -VL_SIN(angle);
	mat[9] = 0;
	mat[10] = VL_COS(angle);
	mat[11] = 0;
	mat[12] = 0;
	mat[13] = 0;
	mat[14] = 0;
	mat[15] = VL_MUL(1);
	VLI_MatMultiply(mat);
}



/*
** Rotate matrix on Z axis
*/
void			VL_MatRotateZ(vl_coord angle)
{
	vl_matrix	mat;

	mat[0] = VL_COS(angle);
	mat[1] = -VL_SIN(angle);
	mat[2] = 0;
	mat[3] = 0;
	mat[4] = VL_SIN(angle);
	mat[5] = VL_COS(angle);
	mat[6] = 0;
	mat[7] = 0;
	mat[8] = 0;
	mat[9] = 0;
	mat[10] = VL_MUL(1);
	mat[11] = 0;
	mat[12] = 0;
	mat[13] = 0;
	mat[14] = 0;
	mat[15] = VL_MUL(1);
	VLI_MatMultiply(mat);
}



/*
** Translate matrix
*/
void			VL_MatTranslate(vl_coord x, vl_coord y, vl_coord z)
{
	vl_matrix	mat;

	mat[0] = VL_MUL(1);
	mat[1] = 0;
	mat[2] = 0;
	mat[3] = x;
	mat[4] = 0;
	mat[5] = VL_MUL(1);
	mat[6] = 0;
	mat[7] = y;
	mat[8] = 0;
	mat[9] = 0;
	mat[10] = VL_MUL(1);
	mat[11] = z;
	mat[12] = 0;
	mat[13] = 0;
	mat[14] = 0;
	mat[15] = VL_MUL(1);
	VLI_MatMultiply(mat);
}



/*
** Zoom matrix
*/
void			VL_MatZoom(vl_coord factor)
{
	vl_matrix	mat;

	mat[0] = factor;
	mat[1] = 0;
	mat[2] = 0;
	mat[3] = 0;
	mat[4] = 0;
	mat[5] = factor;
	mat[6] = 0;
	mat[7] = 0;
	mat[8] = 0;
	mat[9] = 0;
	mat[10] = factor;
	mat[11] = 0;
	mat[12] = 0;
	mat[13] = 0;
	mat[14] = 0;
	mat[15] = VL_MUL(1);
	VLI_MatMultiply(mat);
}



/*
** Quit library
*/
void	VL_Stop(void)
{
#if VL_SHIFT != 0
	if (gl_vl_internal.angle)
		free(gl_vl_internal.angle);
#endif
	if (gl_vl_internal.world)
		free(gl_vl_internal.world);
}
