/* This file is part of the MAYLIB libray.
   Copyright 2007-2009 Patrick Pelissier

This Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

This Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with th Library; see the file COPYING.LESSER.txt.
If not, write to the Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor, Boston,
MA 02110-1301, USA. */

#include "may-impl.h"

static may_t
smod_recur (may_t e, may_t b)
{
  if (MAY_TYPE (e) == MAY_INT_T) {
    return may_num_smod (e, b);
  } else if (MAY_TYPE (e) == MAY_SUM_T
             || MAY_TYPE (e) == MAY_PRODUCT_T
             || MAY_TYPE (e) == MAY_FACTOR_T) {
    may_size_t i, n = MAY_NODE (e).size;
    may_t y = MAY_NODE_C (MAY_TYPE (e), n);
    for (i = 0 ; MAY_LIKELY (i < n); i++)
      MAY_SET_AT (y, i, smod_recur (MAY_AT (e, i), b));
    return y;
  } else
    return e;
}

/* Return the Modulus (in symmetric representation).
   return a mod b in the range [-iquo(abs(b)-1,2), iquo(abs(b),2)] */
may_t
may_smod (may_t a, may_t b)
{
  MAY_ASSERT (MAY_TYPE (b) == MAY_INT_T);
  MAY_ASSERT (MAY_EVAL_P (a) && MAY_EVAL_P(b));

  MAY_LOG_FUNC (("a='%Y' b='%Y'", a, b));

  if (may_num_cmp (b, MAY_ZERO) == 0 || may_num_cmp (b, MAY_ONE) == 0)
    return MAY_ZERO;

  MAY_RECORD ();
  MAY_RET_EVAL (smod_recur (a, b));
}
