#define REG_P1CNT       ((volatile u8*)0x300000)
#define REG_P2CNT       ((volatile u8*)0x340000)
#define REG_STATUS_B       ((volatile u8*)0x380000)

struct Stick {
    u8 up;
    u8 down;
    u8 left;
    u8 right;
    u8 bt1;
    u8 bt2;
    u8 bt3;
    u8 bt4;
    u8 start;
    u8 select;
    u8 up_hit;
    u8 down_hit;
    u8 left_hit;
    u8 right_hit;
    u8 bt1_hit;
    u8 bt2_hit;
    u8 bt3_hit;
    u8 bt4_hit;
    u8 start_hit;
    u8 select_hit;
};

void init_stick(struct Stick *s) {
    s->up = 0;
    s->down = 0;
    s->left = 0;
    s->right = 0;
    s->bt1 = 0;
    s->bt2 = 0;
    s->bt3 = 0;
    s->bt4 = 0;
    s->start = 0;
    s->select = 0;
    s->up_hit = 0;
    s->down_hit = 0;
    s->left_hit = 0;
    s->right_hit = 0;
    s->bt1_hit = 0;
    s->bt2_hit = 0;
    s->bt3_hit = 0;
    s->bt4_hit = 0;
    s->start_hit = 0;
    s->select_hit = 0;
}

struct Stick stick1;
struct Stick stick2;

void init_sticks_2p() {
    init_stick(&stick1);
    init_stick(&stick2);
}

u8 p1cnt = 0;
u8 p2cnt = 0;
u8 status_b = 0;


void get_inputs() {
    p1cnt = *REG_P1CNT^0xff;
    
    if (p1cnt >> 0 & 1) {
        if (!stick1.up)
            stick1.up_hit = 1;
        else
            stick1.up_hit = 0;
        stick1.up = 1;
    } else {
        stick1.up_hit = 0;
        stick1.up = 0;
    }
    
    if (p1cnt >> 1 & 1) {
        if (!stick1.down)
            stick1.down_hit = 1;
        else
            stick1.down_hit = 0;
        stick1.down = 1;
    } else {
        stick1.down_hit = 0;
        stick1.down = 0;
    }

    if (p1cnt >> 2 & 1) {
        if (!stick1.left)
            stick1.left_hit = 1;
        else
            stick1.left_hit = 0;
        stick1.left = 1;
    } else {
        stick1.left_hit = 0;
        stick1.left = 0;
    }
    
    if (p1cnt >> 3 & 1) {
        if (!stick1.right)
            stick1.right_hit = 1;
        else
            stick1.right_hit = 0;
        stick1.right = 1;
    } else {
        stick1.right_hit = 0;
        stick1.right = 0;
    }

    if (p1cnt >> 4 & 1) {
        if (!stick1.bt1)
            stick1.bt1_hit = 1;
        else
            stick1.bt1_hit = 0;
        stick1.bt1 = 1;
    } else {
        stick1.bt1_hit = 0;
        stick1.bt1 = 0;
    }
    
    if (p1cnt >> 5 & 1) {
        if (!stick1.bt2)
            stick1.bt2_hit = 1;
        else
            stick1.bt2_hit = 0;
        stick1.bt2 = 1;
    } else {
        stick1.bt2_hit = 0;
        stick1.bt2 = 0;
    }
    
    if (p1cnt >> 6 & 1) {
        if (!stick1.bt3)
            stick1.bt3_hit = 1;
        else
            stick1.bt3_hit = 0;
        stick1.bt3 = 1;
    } else {
        stick1.bt3_hit = 0;
        stick1.bt3 = 0;
    }
    
    if (p1cnt >> 7 & 1) {
        if (!stick1.bt4)
            stick1.bt4_hit = 1;
        else
            stick1.bt4_hit = 0;
        stick1.bt4 = 1;
    } else {
        stick1.bt4_hit = 0;
        stick1.bt4 = 0;
    }


    p2cnt = *REG_P2CNT^0xff;
    if (p2cnt >> 0 & 1) {
        if (!stick2.up)
            stick2.up_hit = 1;
        else
            stick2.up_hit = 0;
        stick2.up = 1;
    } else {
        stick2.up_hit = 0;
        stick2.up = 0;
    }
    
    if (p2cnt >> 1 & 1) {
        if (!stick2.down)
            stick2.down_hit = 1;
        else
            stick2.down_hit = 0;
        stick2.down = 1;
    } else {
        stick2.down_hit = 0;
        stick2.down = 0;
    }

    if (p2cnt >> 2 & 1) {
        if (!stick2.left)
            stick2.left_hit = 1;
        else
            stick2.left_hit = 0;
        stick2.left = 1;
    } else {
        stick2.left_hit = 0;
        stick2.left = 0;
    }
    
    if (p2cnt >> 3 & 1) {
        if (!stick2.right)
            stick2.right_hit = 1;
        else
            stick2.right_hit = 0;
        stick2.right = 1;
    } else {
        stick2.right_hit = 0;
        stick2.right = 0;
    }

    if (p2cnt >> 4 & 1) {
        if (!stick2.bt1)
            stick2.bt1_hit = 1;
        else
            stick2.bt1_hit = 0;
        stick2.bt1 = 1;
    } else {
        stick2.bt1_hit = 0;
        stick2.bt1 = 0;
    }
    
    if (p2cnt >> 5 & 1) {
        if (!stick2.bt2)
            stick2.bt2_hit = 1;
        else
            stick2.bt2_hit = 0;
        stick2.bt2 = 1;
    } else {
        stick2.bt2_hit = 0;
        stick2.bt2 = 0;
    }
    
    if (p2cnt >> 6 & 1) {
        if (!stick2.bt3)
            stick2.bt3_hit = 1;
        else
            stick2.bt3_hit = 0;
        stick2.bt3 = 1;
    } else {
        stick2.bt3_hit = 0;
        stick2.bt3 = 0;
    }
    
    if (p2cnt >> 7 & 1) {
        if (!stick2.bt4)
            stick2.bt4_hit = 1;
        else
            stick2.bt4_hit = 0;
        stick2.bt4 = 1;
    } else {
        stick2.bt4_hit = 0;
        stick2.bt4 = 0;
    }
    
    
    status_b = *REG_STATUS_B^0xf;
    
    if (status_b >> 0 & 1) {
        if (!stick1.start)
            stick1.start_hit = 1;
        else
            stick1.start_hit = 0;
        stick1.start = 1;
    } else {
        stick1.start_hit = 0;
        stick1.start = 0;
    }
    
    if (status_b >> 1 & 1) {
        if (!stick1.select)
            stick1.select_hit = 1;
        else
            stick1.select_hit = 0;
        stick1.select = 1;
    } else {
        stick1.select_hit = 0;
        stick1.select = 0;
    }
    
   if (status_b >> 2 & 1) {
        if (!stick2.start)
            stick2.start_hit = 1;
        else
            stick2.start_hit = 0;
        stick2.start = 1;
    } else {
        stick2.start_hit = 0;
        stick2.start = 0;
    }
    
    if (status_b >> 3 & 1) {
        if (!stick2.select)
            stick2.select_hit = 1;
        else
            stick2.select_hit = 0;
        stick2.select = 1;
    } else {
        stick2.select_hit = 0;
        stick2.select = 0;
    }

}
