


typedef unsigned char  u8;
typedef signed char    s8;
typedef unsigned short u16;
typedef signed short   s16;
typedef unsigned int   u32;
typedef signed int     s32;

#define REG_VRAMADDR	((volatile u16*)0x3c0000)
#define REG_VRAMRW	((volatile u16*)0x3c0002)
#define REG_VRAMMOD	((volatile u16*)0x3c0004)
#define MMAP_PALBANK1	((volatile u16*)0x400000)
#define ADDR_FIXMAP	0x7000
#define ADDR_SCB1      0
#define ADDR_SCB2 0x8000
#define ADDR_SCB3 0x8200
#define ADDR_SCB4 0x8400


#define EMPTY_TILE 611
#define MAX_V_TILES 14

#define ball_black 0
#define ball_red 1
#define ball_white 2
#define star 3
#define tree 4
#define sky 5
#define ground 6
#define cloud1 7
#define cloud2 8
const u16 def_htiles[] = {2,2,2,4,8,19,19,8,8};
const u16 def_vtiles[] = {2,2,2,4,14,7,14,4,5};
const u16 def_tile_index[] = {0,4,8,12,28,140,273,539,571};
const u16 tiles_to_pals[] = {1,1,1,1,2,2,2,2,3,3,3,3,1,4,4,1,4,4,4,4,4,4,4,4,4,4,4,1,1,5,5,5,5,5,1,1,1,1,1,1,5,5,1,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,5,5,1,1,5,5,5,5,5,1,1,1,1,1,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,8,8,8,8,3,8,8,8,8,8,8,8,8,8,8,8,3,8,8,8,8,8,8,1,8,8,8,1,8,8,1,1,9,9,9,1,9,9,9,9,1,9,9,9,9,9,9,9,9,9,9,9,3,3,9,9,3,9,9,9,9,1,1,9,9,9,1,1,1,9,9};
const u16 palettes_count = 9;
const u16 palettes[]= {0x8000, 0x8333, 0x8444, 0xc444, 0xf444, 0x8555, 0xf555, 0x8666, 0x8777, 0xb877, 0xf888, 0x8aaa, 0x8bbb, 0xfccc, 0xfddd, 0x8fff, 0x8000, 0x8500, 0xc600, 0x8700, 0x8700, 0xc700, 0xc800, 0xc900, 0x8b00, 0x8c00, 0xfc11, 0x8d44, 0xfd66, 0x8e99, 0xbfbb, 0xcfee, 0x8000, 0xf333, 0xf888, 0xf888, 0x8999, 0x8aaa, 0x8bbb, 0xfccc, 0xfddd, 0x8eee, 0xfeee, 0x8fff, 0xffff, 0xffff, 0xffff, 0xffff, 0x8000, 0x8840, 0xef80, 0xef90, 0xcfa0, 0xefa0, 0xcfb0, 0xefb0, 0xcfc0, 0xefc0, 0xcfd0, 0xcfd0, 0xefd0, 0xefd0, 0xefd0, 0xefe0, 0x8000, 0x8000, 0xf149, 0xe204, 0xe341, 0xc417, 0xd53b, 0xa630, 0xc619, 0x9719, 0xa840, 0xf81b, 0x8a2d, 0xaa50, 0xfa1d, 0xcc80, 0x8000, 0xb18e, 0xf18e, 0xb28e, 0xd29e, 0xb39e, 0xb49e, 0xc4af, 0xe5af, 0xc6bf, 0x88cf, 0xb9cf, 0xd9df, 0xdadf, 0xbbdf, 0xfbdf, 0x8000, 0xc461, 0x9561, 0xb561, 0xc572, 0xb672, 0xb783, 0xc794, 0xb894, 0xc8a5, 0xb9a5, 0x89b6, 0xc9b6, 0xbab6, 0x8ac7, 0xcac7, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xa56c, 0xb78e, 0x8888, 0xf999, 0x8bbb, 0xfbbb, 0xfccc, 0xfddd, 0xffff, 0xffff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xf888, 0x8bbb, 0x8ccc, 0xfccc, 0x8ddd, 0xfddd, 0xfddd, 0x8fff, 0xffff, 0xffff};

// memory slots
u16 sky_slot = 0;
u16 cloud1_slot;
u16 cloud2_slot = 0;
u16 ground_slot = 0;
u16 sprites3d_slot = 0;


// useful variables
u16 tile_index = 0;
u8 h_tiles = 0;
u8 v_tiles = 0;
u16 vramaddr = 0;
s16 h = 0;
s16 v = 0;


void display_sprite(u8 p_target_class, u16 p_slot, u16 p_x, u16 p_y, u8 p_shrx, u8 p_shry) {
    h_tiles = def_htiles[p_target_class];
    v_tiles = def_vtiles[p_target_class];
    tile_index = def_tile_index[p_target_class];
    *REG_VRAMMOD = 1;
    vramaddr = ADDR_SCB1 + (p_slot<<6);
    *REG_VRAMADDR = vramaddr;
    for (h=0 ; h<h_tiles ; h++) {
        for (v=0 ; v<v_tiles ; v++) {
            *REG_VRAMRW = tile_index;
            *REG_VRAMRW = tiles_to_pals[tile_index]<<8;
            tile_index++;
        }
        for (v=v_tiles ; v<MAX_V_TILES ; v++) {
            *REG_VRAMRW = EMPTY_TILE;
            *REG_VRAMRW = 0;
        }
        *REG_VRAMADDR = (vramaddr +=64);
    }
    
    *REG_VRAMMOD = 0x200;
    vramaddr = ADDR_SCB2 + p_slot;
    *REG_VRAMADDR = vramaddr;
    for (h=0 ; h<h_tiles ; h++) {
        if (h==0) {
          *REG_VRAMRW = (p_shrx << 8) | p_shry;
          *REG_VRAMRW = (p_y << 7) | (0 << 6) | v_tiles;
          *REG_VRAMRW = p_x << 7;
        } else {
          *REG_VRAMRW = p_shrx << 8;
          *REG_VRAMRW = 64; // sticky
        }
        *REG_VRAMADDR = (++vramaddr);
    }
}

void set_x(u16 p_slot, u16 p_x) {
    *REG_VRAMADDR = ADDR_SCB4 + p_slot;
    *REG_VRAMRW = p_x<<7;
}

u16 mask_shrx = 3840;
void set_shry(u16 p_slot, u16 p_shry) {
    *REG_VRAMADDR = ADDR_SCB2 + p_slot;
    *REG_VRAMRW = (*REG_VRAMRW & mask_shrx) | p_shry;
}

#include "inputs.c"
#include "trigo.c"
#include "3d.c"


////////////////////////  MAIN LOOP  ////////////////

volatile u8 vblank=0;
void rom_callback_VBlank() {
    vblank=1;
}

u8 frame = 0;
int main(void) {
    // clean all tiles
    *REG_VRAMADDR = ADDR_FIXMAP;
    *REG_VRAMMOD = 1;
    for (u16 i=0; i<40*32; i++)
        *REG_VRAMRW = 95;
    
    for (u16 i=0; i<448; i++) {
        *REG_VRAMMOD = 1;
        *REG_VRAMADDR = ADDR_SCB1 + i*64;
        for (u16 j=0; j<32; j++) {
            *REG_VRAMRW = EMPTY_TILE;
            *REG_VRAMRW = 0;
        }
        *REG_VRAMMOD = 0x200;
        *REG_VRAMADDR = ADDR_SCB2 + i;
        *REG_VRAMRW = 0xFFF; // scale
        *REG_VRAMRW = 0; // Y + sticky + size
        *REG_VRAMRW = 0; // X
    }

    // set palettes
    u16 fixpal[]= {0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
                 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FFF};
    for (u16 i=0; i<16; i++) {
        MMAP_PALBANK1[i] = fixpal[i];
    }
    u16 color_count = palettes_count*16;
    for (u16 i=0; i<color_count; i++) {
        MMAP_PALBANK1[i+16] = palettes[i];
    }
    
    // set memory
    sky_slot = 1;
    cloud1_slot = sky_slot + def_htiles[sky];
    cloud2_slot = cloud1_slot + def_htiles[cloud1];
    ground_slot = cloud2_slot + def_htiles[cloud2];
    sprites3d_slot = ground_slot + def_htiles[ground];

    init_3d();
    init_sticks_2p();

    // show sky ground and clouds
    display_sprite(sky, sky_slot, 8, -16, 0xF, 0xFF);
    display_sprite(cloud1, cloud1_slot, 0, -40, 0xF, 0xFF);
    display_sprite(cloud2, cloud2_slot, 0, -20, 0xF, 0xFF);
    display_sprite(ground, ground_slot, 8, -128, 0xF, 0xFF);
    //
    while (1) {
        while (!vblank);
        vblank = 0;
 
        if (frame & 1) {
            display();
        } else {
            get_inputs();
            move_cam();
            transform_3d_to_2d();
            sort_2d();
        }

        frame++;     
    }
}


