
#define OBJ_COUNT 57
s32 obj_x[] = {-372,374,374,-372,-372,374,374,-372,-372,374,-372,374,-372,374,281,-652,-932,-185,-559,-1773,-465,94,-1306,-1026,-2147,-1399,-1680,-2614,-2707,-1960,-1960,-2707,-2427,-1866,-2707,-1960,-2707,-1960,-2707,-1960,-1960,-2707,-2707,-1960,1,-14,-7,-966,-2019,-2393,-2393,-2347,515,-1246,-1660,-2886,-2105};
s32 obj_y[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,140,140,140,140,140,0,224,224,224,224,224};
s32 obj_z[] = {-3738,-3738,-3364,-2991,-2617,-2617,-2244,-1870,-3364,-2991,-2244,-1870,-1497,-1497,-1123,-749,-376,-376,-2,371,-1123,-749,-2,371,744,744,1118,1491,1865,1865,2239,2612,1118,1491,2239,2612,2986,2986,3359,3359,3733,4107,3733,4107,-4112,-2747,-1450,-41,973,2171,3337,4369,-1329,-299,1338,2721,4242};
u8 obj_spritedef[] = {ball_white,ball_white,ball_red,ball_white,ball_red,ball_red,ball_white,ball_red,ball_red,ball_white,ball_white,ball_red,ball_white,ball_white,ball_red,ball_white,ball_red,ball_red,ball_white,ball_red,ball_red,ball_white,ball_white,ball_red,ball_white,ball_white,ball_red,ball_white,ball_black,ball_black,ball_black,ball_black,ball_red,ball_white,ball_black,ball_black,ball_black,ball_black,ball_black,ball_black,ball_black,ball_black,ball_black,ball_black,ball_black,star,star,star,star,star,star,ball_black,tree,tree,tree,tree,tree};

u8 obj_visible[OBJ_COUNT];
s16 obj_d[OBJ_COUNT];
s16 obj_scrx[OBJ_COUNT];
s16 obj_scry[OBJ_COUNT];
u8 obj_shrx[OBJ_COUNT];
u8 obj_shry[OBJ_COUNT];
u16 obj_order[OBJ_COUNT];

u16 dsorted_index[OBJ_COUNT];


s16 SCREEN_W = 320;
s16 SCREEN_H = 224;
s16 SCREEN_HALF_W = 160;
s16 SCREEN_HALF_H = 112;
s16 SCREEN_H_OFFSET = 16;
s16 SCREEN_HALFPLUSOFFSET_H = 112 + 16;


u16 max_slot = 0;
s16 cam_yaw = 0;
s32 cam_x = 0;
s32 cam_y = 0;
s32 cam_z = 0;
s32 CAM_NEAR = 120 << 8;
s32 CAM_FAR = 1500 << 8;
s32 cam_bb_xmin = 0;
s32 cam_bb_xmax = 0;
s32 cam_bb_zmin = 0;
s32 cam_bb_zmax = 0;
s32 CAM_MIN_Y = 100 << 8;
s32 CAM_MAX_Y = 200 << 8;
s32 CAM_BB_SIZE = 2100 << 8; // computed from CAM_FAR

// gameplay related
s32 speed = 0 << 8;
s8 turn_speed = 0;
s32 cam_dir_x = 0 << 8;
s32 cam_dir_z = 0 << 8;
//


//// work variables
u16 _index = 0;
u16 _slot3d = 0;
u16 _camyawMult = 0;
s32 _xt=0, _yt=0, _zt=0, _xr=0, _yr=0, _zr=0, _xp=0, _yp=0, _xs=0, _ys=0, _d=0, _cos=0, _sin=0, _shr=0;
u8 _shrx = 0, _shry = 0;
u8 _visible = 0;
////


void init_3d() {
    cam_yaw = 0;
    cam_x = 0 << 8;
    cam_y = 140 << 8;
    cam_z = -4000 << 8;

    cam_dir_x = mathsin(ROT_MAX-cam_yaw);
    cam_dir_z = mathcos(ROT_MAX-cam_yaw);
    speed = 0;
    
    u8 i=0;
    u8 j=0;
    
    for (i=0 ; i<OBJ_COUNT ; i++) {
        obj_x[j] = obj_x[i] << 8;
        obj_y[j] = obj_y[i] << 8;
        obj_z[j] = obj_z[i] << 8;
        obj_d[j] = 0;
        obj_order[j] = j;
        dsorted_index[j] = j;
        j++;
    }
    
    max_slot = 0;
}



void move_cam() {
    if (stick1.up) {
        cam_y -= (5 << 8);
        if (cam_y < CAM_MIN_Y)
            cam_y = CAM_MIN_Y;
    } else if (stick1.down) {
        cam_y += (5 << 8);
        if (cam_y > CAM_MAX_Y)
            cam_y = CAM_MAX_Y;
    }
    
    if (stick1.left) {
        turn_speed += 1;
        if (turn_speed > 6)
            turn_speed = 6;
    } else if (stick1.right) {
        turn_speed -= 1;
        if (turn_speed < -6)
            turn_speed = -6;
    } else {
        if (turn_speed > 0) {
            turn_speed -= 2;
            if (turn_speed < 0)
                turn_speed = 0;
        } else if (turn_speed < 0) {
            turn_speed += 2;
            if (turn_speed > 0)
                turn_speed = 0;
        }
    }
    
    if (stick1.bt1) {
        if (speed < -400)
            speed += 400;
        else
            speed += 100;
        if (speed > (50 << 8))
            speed = 50 << 8;
    } else if (stick1.bt2) {
        if (speed > 400)
            speed -= 400;
        else
            speed -= 100;
        if (speed < (-50 << 8))
            speed = -50 << 8;
    } else {
        if (speed > 0) {
            speed -= 100;
            if (speed < 0)
                speed = 0;
        } else if (speed < 0) {
            speed += 100;
            if (speed > 0)
                speed = 0;
        }
    }
    
    cam_yaw += turn_speed;
    if (cam_yaw < 0)
        cam_yaw += ROT_MAX;
    else if (cam_yaw >= ROT_MAX)
        cam_yaw -= ROT_MAX;
    
    cam_dir_x = mathsin(ROT_MAX-cam_yaw);
    cam_dir_z = mathcos(ROT_MAX-cam_yaw);
    
    cam_x += (cam_dir_x * speed) >> 8;
    cam_z += (cam_dir_z * speed) >> 8;
    
    if (cam_yaw < 45 || cam_yaw >= 320) {
        cam_bb_xmin = cam_x - CAM_BB_SIZE;
        cam_bb_xmax = cam_x + CAM_BB_SIZE;
        cam_bb_zmin = cam_z;
        cam_bb_zmax = cam_z + CAM_BB_SIZE;
    } else if (cam_yaw < 135 && cam_yaw >= 45) {
        cam_bb_xmin = cam_x - CAM_BB_SIZE;
        cam_bb_xmax = cam_x;
        cam_bb_zmin = cam_z - CAM_BB_SIZE;
        cam_bb_zmax = cam_z + CAM_BB_SIZE;
    } else if (cam_yaw < 225 && cam_yaw >= 135) {
        cam_bb_xmin = cam_x - CAM_BB_SIZE;
        cam_bb_xmax = cam_x + CAM_BB_SIZE;
        cam_bb_zmin = cam_z - CAM_BB_SIZE;
        cam_bb_zmax = cam_z;
    } else {
        cam_bb_xmin = cam_x;
        cam_bb_xmax = cam_x + CAM_BB_SIZE;
        cam_bb_zmin = cam_z - CAM_BB_SIZE;
        cam_bb_zmax = cam_z + CAM_BB_SIZE;
    }
}



void display() {
    u16 i = 0, j = 0;
    _slot3d = sprites3d_slot;
    for (i=0 ; i<OBJ_COUNT ; i++) {
        _index = dsorted_index[i];
        if (obj_visible[_index]) {
            display_sprite( obj_spritedef[_index], _slot3d, obj_scrx[_index], obj_scry[_index], obj_shrx[_index], obj_shry[_index]);
            _slot3d += def_htiles[obj_spritedef[_index]];
        }
    }
    for (i=_slot3d ; i<max_slot ; i++) {
        *REG_VRAMMOD = 1;
        *REG_VRAMADDR = ADDR_SCB1 + (i<<6);
        for (j=0; j<MAX_V_TILES; j++) {
            *REG_VRAMRW = EMPTY_TILE;
            *REG_VRAMRW = 0;
        }
        *REG_VRAMADDR = ADDR_SCB3 + _slot3d+i;
        *REG_VRAMRW = 0;
    }
    max_slot = _slot3d;
    
    _camyawMult = (cam_yaw<<9) / ROT_MAX;
    set_x(cloud1_slot, _camyawMult);
    set_x(cloud2_slot, 256 + _camyawMult);
    set_shry(ground_slot, ((cam_y / (CAM_MAX_Y >> 8) )) - 1);
}

void transform_3d_to_2d() {
    u16 i = 0;
    for (i=0 ; i<OBJ_COUNT ; i++) {
        
        // skip objects outside Bounding Box
        if ( obj_x[i] < cam_bb_xmin || obj_x[i] > cam_bb_xmax || obj_z[i] < cam_bb_zmin || obj_z[i] > cam_bb_zmax ) {
            obj_visible[i] = 0;
            continue;
        }
        
        // from cam position
        _xt = obj_x[i] - cam_x; // max val: +/- 8 388 608 , precision digits: 8
        _zt = obj_z[i] - cam_z; // max val: +/- 8 388 608 , precision digits: 8
        _sin = mathsin(cam_yaw);
        _cos = mathcos(cam_yaw);
        _zr = ((_zt >> 6) * _cos) >> 2;     
        _zr -= ((_xt >> 6) * _sin) >> 2;
        
        // skip objets to close or behind
        if ( _zr < CAM_NEAR || _zr > CAM_FAR ) {
            obj_visible[i] = 0;
            continue;
        }
        
        // from cam position (suite)
        _yt = obj_y[i] - cam_y; // max val: +/- 8 388 608 , precision digits: 8
        _xr = ((_zt >> 6) * _sin) >> 2;
        _xr += ((_xt >> 6) * _cos) >> 2;
        _yr = _yt;
        

        // skip objets on sides
        if (   (_xr > 0 && _xr > _zr) || (_xr < 0 && _xr < -_zr)
            || (_yr > 0 && _yr > _zr) || (_yr < 0 && _yr < -_zr) ) {
            obj_visible[i] = 0;
            continue;
        }
        obj_visible[i] = 1;
        
        _d = _zr >> 6;
        obj_d[i] = _d;

        // shrinking x and y
        _shr = ((SCREEN_HALF_H  << 10) / _d);
        if (_shr & 8)
            _shrx = (_shr >> 4) + 1;
        else
            _shrx = (_shr >> 4);
        _shry = _shr;
        obj_shrx[i] = _shrx;
        obj_shry[i] = _shry;
        
        // projection and stretch to screen
        _xp = (_xr >> 8) * _shr;
        _yp = (_yr >> 8) * _shr;
        
        // center in screen
        _xs = _xp >> 8;
        _ys = _yp >> 8;
        _xs += SCREEN_HALF_W - (def_htiles[obj_spritedef[i]] * _shrx >> 1);
        _ys -= SCREEN_HALFPLUSOFFSET_H; // - (((def_vtiles[obj_spritedef[i]] << 4) * _shr) >> 8);
        
        obj_scrx[i] = _xs;
        obj_scry[i] = _ys;
    }
}

void sort_2d() {
    u16 i = 0, j = 0;
    for (i=1 ; i<OBJ_COUNT ; i++) {
        j = i-1;
        if (obj_d[dsorted_index[j]] < obj_d[dsorted_index[i]]) {
            _index  = dsorted_index[i];
            dsorted_index[i] = dsorted_index[j];
            dsorted_index[j] = _index;
            obj_order[dsorted_index[i]] = i;
            obj_order[dsorted_index[j]] = j;
        }
    }
}

