s16 table_cos[] = {256,256,256,256,255,255,255,254,254,253,252,251,250,249,248,247,246,245,243,242,241,239,237,236,234,232,230,228,226,224,222,219,217,215,212,210,207,204,202,199,196,193,190,187,184,181,178,175,171,168,165,161,158,154,150,147,143,139,136,132,128,124,120,116,112,108,104,100,96,92,88,83,79,75,71,66,62,58,53,49,44,40,36,31,27,22,18,13,9,4,0};
s16 ROT_MAX = 360;
s16 ROT_MAX_QUART = 360/4;
s16 ROT_MAX_HALF = 360/2;
s16 ROT_MAX_3QUART = 360/2 + 360/4;

s16 mathcos(s16 angle_bin) {
    if (angle_bin >= 0 && angle_bin <= ROT_MAX_QUART)
        return table_cos[angle_bin];
    else if (angle_bin > ROT_MAX_QUART && angle_bin <= ROT_MAX_HALF)
        return - table_cos[ROT_MAX_HALF - angle_bin];
    else if (angle_bin > ROT_MAX_HALF && angle_bin <= ROT_MAX_3QUART)
        return - table_cos[angle_bin - ROT_MAX_HALF];
    else if (angle_bin > ROT_MAX_3QUART && angle_bin <= ROT_MAX)
        return table_cos[ROT_MAX - angle_bin];
    else return 0;
}
s16 mathsin(s16 angle_bin) {
    if (angle_bin >= 0 && angle_bin <= ROT_MAX_QUART)
        return table_cos[ROT_MAX_QUART - angle_bin];
    else if (angle_bin > ROT_MAX_QUART && angle_bin <= ROT_MAX_HALF)
        return table_cos[angle_bin - ROT_MAX_QUART];
    else if (angle_bin > ROT_MAX_HALF && angle_bin <= ROT_MAX_3QUART)
        return - table_cos[ROT_MAX_3QUART - angle_bin];
    else if (angle_bin > ROT_MAX_3QUART && angle_bin <= ROT_MAX)
        return - table_cos[angle_bin - ROT_MAX_3QUART];
    else return 0;
}
