; RST ROUTINES
#define rop1toop2	$08
#define rfindsym	$10
#define rpushrealo1	$18
#define rmov9toop1	$20
#define rbr_call	$28
#define rfpadd	$30
#define brt_jump0	$50

; BANKED CALL MACROS
#define bcall(romcall)	rst rbr_call\	.dw romcall
#define	bcallz(romcall)	jr nz,$+5\	rst rbr_call\	.dw romcall
#define	bcallnz(romcall)	jr z,$+5\	rst rbr_call\	.dw romcall
#define	bcallc(romcall)	jr nc,$+5\	rst rbr_call\	.dw romcall
#define	bcallnc(romcall)	jr c,$+5\	rst rbr_call\	.dw romcall
#define bcalldi(romcall)	rst rbr_call\	.dw romcall\	di
#define	bcalldiz(romcall)	jr nz,$+6\	rst rbr_call\	.dw romcall\	di
#define	bcalldinz(romcall)	jr z,$+6\	rst rbr_call\	.dw romcall\	di
#define	bcalldic(romcall)	jr nc,$+6\	rst rbr_call\	.dw romcall\	di
#define	bcalldinc(romcall)	jr c,$+6\	rst rbr_call\	.dw romcall\	di
#define bjump(romcall)	call brt_jump0\	.dw romcall

; PAGE $1b ROM CALLS
#define _cphlde	$400c
#define _putc	$44fb
#define _disphl	$44fe
#define _puts	$4501
#define _runindicon	$4564
#define _runindicoff	$4567
#define _getkey	$495d
#define _keyscnlnk	$4a05
#define _createvar	$4e55
#define _enablecursorhook	$4f45
#define _disablecursorhook	$4f4e
#define _delvararc	$4fab
#define _getkeyretoff	$4ff0
#define _writetoflash	$50b0
#define _disp32	$51af

; PAGE $1f ROM CALLS
#define _checkosvalidated	$8117

; COLOR LCD CONTROL REGISTERS & MACROS
#define lcdhigh(x)	x >> 8
#define lcdlow(x)	x & 255
#define lrsync	$00
#define lrdrivercode	$00
#define lroutctrl1	$01
#define lrdrivectrl	$02
#define lrentrymode	$03
#define lrrow	$20
#define lrcol	$21
#define lrgram	$22
#define lrwinrowstart	$50
#define lrwinrowend	$51
#define lrwincolstart	$52
#define lrwincolend	$53
#define lrbaseimgdispctrl	$61
#define lrhorizscroll	$6a

; REGISTER $01 (lroutctrl1) BITFIELDS
#define lcdreversecol	$0100
#define lcdreverserow	$0400

; REGISTER $02 (lrdrivectrl) BITFIELDS
#define lcdeor	$0100
#define lcdbdivc	$0200

; REGISTER $03 (lrdispctrl1) BITFIELDS
#define lcdam	$0008
#define lcdcurmovehoriz	$0008
#define lcdvertinc	$0010
#define lcdhorizinc	$0020
#define lcdorg	$0080
#define lcdbgr	$1000
#define lcdtri	$4000
#define lcddfm	$8000

; REGISTER $61 (lrbaseimgdispctrl) BITFIELDS
#define lcdrev	$0001
#define lcdvle	$0002

; ERROR HANDLER EQUATES
#define app_push_errorh	$59
#define app_pop_errorh	$5c

; MEMORY EQUATES
#define ramstart	$8000
#define appdata	$8000
#define ramcode	$8100
#define tempswaparea	$82b3
#define op1	$84ae
#define flags	$8b26
#define statvars	$8c1c
#define pagedcount	$9e15
#define pagedgetptr	$9e17
#define pagedbuf	$9e1b
#define locallanguage	$9e54
#define cursorhookblockptr	$9e5d
#define usermem	$a60b

; CRYSTAL TIMER EQUATES
#define tmroff	$00
#define tmr11000hz	$40
#define tmr1000hz	$41
#define tmr100hz	$42
#define tmr10hz	$43
#define tmr32768hz	$44
#define tmr2048hz	$45
#define tmr1$28z	$46
#define tmr8hz	$47
#define tmrcpu	$80
#define tmrcpudiv2	$81
#define tmrcpudiv4	$82
#define tmrcpudiv8	$84
#define tmrcpudiv16	$88
#define tmrcpudiv32	$90
#define tmrcpudiv64	$a0
#define tmrnullack	$00
#define tmrloop	$01
#define tmrint	$02
#define tmrloopandint	$03

; HARDWARE PORTS
#define plink	$00
#define pkey	$01
#define pstatus	$02
#define pintmask	$03
#define pintid	$04
#define pmmaptmrfreq	$04
#define pmpagec	$05
#define plnkastberead	$05
#define pmpagea	$06
#define pmpageb	$07
#define plnkastseenable	$08
#define plnkastsestatus	$09
#define plnkastseinbuf	$0a
#define plnkastsecfg	$0a
#define plnkastsercvtimeout	$0b
#define plnkastsesndtimeout	$0c
#define plnkastseoutbuf	$0d
#define pmpageahighbits	$0e
#define pmpagebhighbits	$0f
#define plcdcmd	$10
#define plcddata	$11
#define pprotctrl	$14
#define pasicid	$15
#define pcpuspeed	$20
#define pflashtyperammask	$21
#define pflashexeclowerlimit	$22
#define pflashexecupperlimit	$23
#define pflashexecexecoverride	$24
#define pramexeclowerlimit	$25
#define pramexecupperlimit	$26
#define pblockmremapc	$27
#define pblockmremapb	$28
#define plcddelay0	$29
#define plcddelay1	$2a
#define plcddelay2	$2b
#define plcddelay3	$2c
#define punknown2d	$2d
#define pmemdelay	$2e
#define plcdgendelay	$2f
#define ptmr1freq	$30
#define ptmr1cfg	$31
#define ptmr1count	$32
#define ptmr2freq	$33
#define ptmr2cfg	$34
#define ptmr2count	$35
#define ptmr3freq	$36
#define ptmr3cfg	$37
#define ptmr3count	$38
#define pusbunkoldflg	$39
#define pusbunkoldflg2	$3a
#define prtcctrl	$40
#define prtcset0	$41
#define prtcset1	$42
#define prtcset2	$43
#define prtcset3	$44
#define prtc0	$45
#define prtc1	$46
#define prtc2	$47
#define prtc3	$48

; PORT $02 (pstatus) BITFIELDS
#define stbattgood	$01
#define stlcdready	$02
#define stflashunlocked	$04
#define stisnot83pse	$05
#define stissemodel	$07

; PORT $03 (pintmask) BITFIELDS
#define intmaskonkey	$01
#define intmasktmr1	$02
#define intmasktmr2	$04
#define intdisablelowpowermode	$08
#define intmasklinkport	$10
#define intmasknormal	intmaskonkey+intmasktmr1+intdisablelowpowermode

; PORT $04 (pmmaptmrfreq) BITFIELDS
#define intidonkey	$01
#define intidtmr1	$02
#define intidtmr2	$04
#define intidonkeydown	$08
#define intidlinkport	$16
#define intidcrstltmr1	$32
#define intidcrstltmr2	$64
#define intidcrstltmr3	$128
#define memmapmode0	$00
#define memmapmode1	$01
#define tmrfreq0	$00
#define tmrfreq1	$02
#define tmrfreq2	$04
#define tmrfreq3	$06
#define battvoltage0	$00
#define battvoltage1	$64
#define battvoltage2	$128
#define battvoltage3	$192

; PORT $08 (plnkastseenable) BITFIELDS
#define lnkseintrcv	$01
#define lnkseintsnd	$02
#define lnkseinterr	$04
#define lnkseintdisable	$128
#define lnksercving	$08
#define lnksercvd	$16
#define lnksesndready	$32
#define lnksnderr	$64
#define lnksnding	$128

; PORT $14 (pprotctrl) BITFIELDS
#define protlockflash	$00
#define protunlockflash	$01

; PORT $15 (pasicid) BITFIELDS
#define asic83pta2	$33
#define asic84pta2	$44
#define asic84pta3	$45
#define asic84pta1	$55

; PORT $20 (pcpuspeed) BITFIELDS
#define cpu6MHz	$00
#define cpu15MHz	$01
#define cpu15MHz2	$02
#define cpu15MHz3	$03

; PORT $21 (pflashtyperammask) BITFIELDS
#define flashtypemask	$03
#define flashtype1mb	$00
#define flashtype2mb	$01
#define flashtype4mb	$04
#define flashtyle8mb	$08
#define ramexecmodemask	$30
#define ramexecmode0	$00
#define ramexecmode1	$10
#define ramexecmode2	$20
#define ramexecmode3	$30

; PORT $24 (pflashexecexecoverride) BITFIELDS
#define flashallowexecall	$01
#define flashforbidexecall	$02

; PORTS $29-$2c (plcddelay0-3) BITFIELDS
#define delayflashenable	$01
#define delayramenable	$02
#define delaycyclecountmask	$fc
#define delaycyclecountshift	$02

; PORT $2e (pmemdelay) BITFIELDS
#define delayflashexec	$01
#define delayflashread	$02
#define delayflashwrite	$04
#define delayramexec	$10
#define delayramread	$20
#define delayramwrite	$40

; PORT 2f (plcdgendelay) BITFIELDS
#define cpu1lcddelay48	$00
#define cpu1lcddelay112	$01
#define cpu1lcddelay176	$02
#define cpu1lcddelay240	$03
#define cpu2lcddelay48	$00
#define cpu2lcddelay112	$04
#define cpu2lcddelay176	$08
#define cpu2lcddelay240	$12
#define cpu2lcddelay304	$16
#define cpu2lcddelay368	$20
#define cpu2lcddelay432	$24
#define cpu2lcddelay496	$28
#define cpu3lcddelay48	$00
#define cpu3lcddelay112	$32
#define cpu3lcddelay176	$64
#define cpu3lcddelay240	$96
#define cpu3lcddelay304	$128
#define cpu3lcddelay368	$160
#define cpu3lcddelay432	$192
#define cpu3lcddelay496	$224

; TOKENS
#define texttok	$ef

; MATHPRINT TOKENS
#define tzquadrant	$17
#define tzfrachalf	$18
#define tzfracthird	$19
#define tzfracfourth	$1a
#define tzfracfifth	$1b
#define tzfraceighth	$1c
#define tzfractenth	$1d
#define tfracslash	$2e
#define tfracmixednum	$2f
#define tswapimproper	$30
#define tswapfracdec	$31
#define tremainder	$32
#define tsummationsigma	$33
#define tlogbase	$34
#define trandintnorep	$35
#define tmathprint	$37
#define tclassic	$38
#define tautoanswer	$3b
#define tdecanswer	$3c
#define tfracanswer	$3d

; TI 84+ C SE TOKENS
#define tblue	$41
#define tred	$42
#define tblack	$43
#define tmagenta	$44
#define tgreen	$45
#define torange	$46
#define tbrown	$47
#define tnavy	$48
#define tltblue	$49
#define tyellow	$4a
#define twhite	$4b
#define tltgray	$4c
#define tmedgray	$4d
#define tgray	$4e
#define tdarkgray	$4f
#define tgraphcolor	$65
#define ttextcolor	$67
#define tbackgroundon	$5b
#define tbackgroundoff	$64
#define tthin	$74
#define tasm84cprgm	$68
#define tasm84ccmp	$69
#define tbordercolor	$6c

; FLAGS
#define applwrcaseflag	$24
#define lwrcaseactive $03