unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, DB, DBTables;

type Gegenstand = record
  wert: integer;
  gewicht: integer;
  eingepackt: boolean;
end;

type
  TMainForm = class(TForm)
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    Label4: TLabel;
    btnBestimmeInhalt: TButton;
    Label5: TLabel;
    lblMaxWert: TLabel;
    Label3: TLabel;
    spinMaxGewicht: TSpinEdit;
    lstRucksack: TListBox;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    spinGgsWert: TSpinEdit;
    spinGgsGewicht: TSpinEdit;
    btnHinzufuegen: TButton;
    GroupBox2: TGroupBox;
    listGgs: TListBox;
    btnEntfernen: TButton;
    GroupBox3: TGroupBox;
    spinZufAnz: TSpinEdit;
    Label6: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    spinZufMinWert: TSpinEdit;
    spinZufMaxWert: TSpinEdit;
    spinZufMinGewicht: TSpinEdit;
    spinZufMaxGewicht: TSpinEdit;
    Label7: TLabel;
    btnAlleEntfernen: TButton;
    Label11: TLabel;
    lblErreichtesGewicht: TLabel;
    Label12: TLabel;
    lblGgsAnzahl: TLabel;
    Label13: TLabel;
    procedure fuegeGegenstandHinzu(ggs: Gegenstand);
    procedure EntferneGegenstand(n: integer);
    procedure EntferneGegenstaende();
    procedure btnHinzufuegenClick(Sender: TObject);
    procedure btnZufHinzufuegenClick(Sender: TObject);
    procedure listGgsKeyPress(Sender: TObject; var Key: Char);
    procedure btnEntfernenClick(Sender: TObject);
    procedure listGgsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnAlleEntfernenClick(Sender: TObject);
    procedure btnBestimmeInhaltClick(Sender: TObject);
    procedure spinGgsGewichtKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure spinGgsWertKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure spinZufAnzKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure spinZufMinWertKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure spinZufMaxWertKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure spinZufMinGewichtKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure spinZufMaxGewichtKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure spinMaxGewichtKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  ggsList: array[0..1000] of Gegenstand;
  ggsNum: integer;

implementation

{$R *.dfm}

procedure TMainForm.fuegeGegenstandHinzu(ggs: Gegenstand);
begin
  ggsList[ggsNum] := ggs;
  inc(ggsNum);
  listGGs.items.add(inttostr(ggs.wert) + ';' + inttostr(ggs.gewicht));
  lblGgsAnzahl.Caption := inttostr(ggsNum);
end;

procedure TMainForm.EntferneGegenstand(n: integer);
var i: integer;
begin
  for i := n to ggsNum - 2 do
    ggsList[i] := ggsList[i+1];
  dec(ggsNum);
  listGGs.items.delete(n);
  lblGgsAnzahl.Caption := inttostr(ggsNum);
end;

procedure TMainForm.EntferneGegenstaende();
var i: integer;
begin
  {while listGgs.SelCount > 0 do
  listGgs.DeleteSelected;}
  i := 0;
  while i < listGGs.Count do
  begin
    if listGGs.Selected[i] then
      {listGGs.Items.Delete(i)}
      EntferneGegenstand(i)
    else
      inc(i);
  end;
end;

procedure TMainForm.btnAlleEntfernenClick(Sender: TObject);
begin
  ggsNum := 0;
  listGGs.Items.Clear;
  lblGgsAnzahl.Caption := '0'; {inttostr(ggsNum);}
end;

var c : array[0..1000, 0..1000] of integer;

procedure TMainForm.btnBestimmeInhaltClick(Sender: TObject);
var i,g,N,M,v1,v2: integer;
begin
  N := ggsNum;
  M := spinMaxGewicht.Value;
  for g := 0 to M do
    c[0,g] := 0;
  for i := 0 to N - 1 do
  begin
    {ggsList[i].eingepackt := False;}
    c[i,0] := 0;
    for g := 1 to M do
    begin
      v1 := ggsList[i].wert + c[i, g - ggsList[i].gewicht];
      v2 := c[i, g];
      if (ggsList[i].gewicht <= g) and (v1 > v2) then
      begin
        c[i+1,g] := v1;
        {ggsList[i].eingepackt := True;}
      end else
      begin
        c[i+1,g] := v2;
        {ggsList[i].eingepackt := False;}
      end;
    end;
  end;
  lblMaxWert.Caption := inttostr(c[N,M]);
  lstRucksack.Clear;
  g := M;
  v1 := 0;
  for i := N-1 downto 0 do
  begin
    if c[i,g] = c[i+1,g] then
      ggsList[i].eingepackt := False
    else
    begin
      ggsList[i].eingepackt := True;
      v1 := v1 + ggsList[i].gewicht;
      g := g - ggsList[i].gewicht;
    end;
  end;
  lblErreichtesGewicht.Caption := inttostr(v1);
  for i := 0 to N - 1 do
  begin
    if ggsList[i].eingepackt then
      lstRucksack.items.add(
        inttostr(ggsList[i].wert) + ';' +
        inttostr(ggsList[i].gewicht));
  end;
end;

procedure TMainForm.btnEntfernenClick(Sender: TObject);
begin
  EntferneGegenstaende;
end;

procedure TMainForm.listGgsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_DELETE then
    EntferneGegenstaende;
end;

procedure TMainForm.listGgsKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #8 then
    EntferneGegenstaende;
end;

procedure TMainForm.spinGgsGewichtKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnHinzufuegenClick(Sender);
end;

procedure TMainForm.spinGgsWertKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnHinzufuegenClick(Sender);
end;

procedure TMainForm.spinMaxGewichtKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnBestimmeInhaltClick(Sender);
end;

procedure TMainForm.spinZufAnzKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnZufHinzufuegenClick(Sender);
end;

procedure TMainForm.spinZufMaxGewichtKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnZufHinzufuegenClick(Sender);
end;

procedure TMainForm.spinZufMaxWertKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnZufHinzufuegenClick(Sender);
end;

procedure TMainForm.spinZufMinGewichtKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnZufHinzufuegenClick(Sender);
end;

procedure TMainForm.spinZufMinWertKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    btnZufHinzufuegenClick(Sender);
end;

procedure TMainForm.btnHinzufuegenClick(Sender: TObject);
var ggs: Gegenstand;
begin
  ggs.wert := spinGgsWert.Value;
  ggs.gewicht := spinGgsGewicht.Value;
  if ggsNum < 1000 then
    fuegeGegenstandHinzu(ggs)
  else
    MessageBox(0, 'Es konnten nicht alle Gegenstnde hinzugefgt werden, da die Anzahl der Gegenstnde 1000 nicht berschreiten darf!', 'Error', MB_OK)
end;

procedure TMainForm.btnZufHinzufuegenClick(Sender: TObject);
var i, minWert, maxWert, minGewicht, maxGewicht: integer; ggs: Gegenstand;
  voll: boolean;
begin
  minWert := spinZufMinWert.Value;
  maxWert := spinZufMaxWert.Value;
  minGewicht := spinZufMinGewicht.Value;
  maxGewicht := spinZufMaxGewicht.Value;
  if (minWert > maxWert) or (minGewicht > maxGewicht) then
  begin
    MessageBox(0, 'Die Werte fr das Minimum mssen kleiner sein als die fr das Maximum!', 'Error', MB_OK)
  end else begin
    randomize;
    voll := False;
    for i := 1 to spinZufAnz.Value do
    begin
      ggs.wert := random(maxWert - minWert + 1) + minWert;
      ggs.gewicht := random(maxGewicht - minGewicht + 1) + minGewicht;
      if ggsNum < 1000 then
        fuegeGegenstandHinzu(ggs)
      else
        voll := True;
    end;
    if voll then
      MessageBox(0, 'Es konnten nicht alle Gegenstnde hinzugefgt werden, da die Anzahl der Gegenstnde 1000 nicht berschreiten darf!', 'Error', MB_OK)
  end;
end;

initialization
ggsNum := 0;

end.
