/**********************************/
/*  L Y N X                       */ 
/*  Vince Attack                  */ 
/*  Frederic Descharmes           */
/*  Octobre 2020                  */
/**********************************/
 
#include <stdlib.h>
#include <lynx.h>
#include <lynxlib.h>
#include "fonte.h"
#include "fontev.h"
#include "inc\fond.pal"

/* LYNX-specific #defines: */
#define JOY_RIGHT		0x10
#define JOY_LEFT		0x20
#define JOY_DOWN		0x40
#define JOY_UP			0x80

#define BUTTON_OPTION1	0x08
#define BUTTON_OPTION2	0x04
#define BUTTON_INNER	0x02
#define BUTTON_OUTER	0x01

#define BUTTON_PAUSE	0x01

#define SCBPAL(a)   (*(uint *)((a)+19))

#define MAX_BLAGUES  5

char SCREEN[8160]       at (0xfff8-16320);
char RENDER[8160]       at (0xfff8-8160);


char fond[4500];
char ptPen[350];
char barreB[550];
char bigSprite[1400];

extern char score[];
extern char curseur[];
extern char fedora[];

extern char s000000[];
extern char s000001[];
extern char s000002[];
extern char s000003[];
extern char s000004[];
extern char s000005[];


char rr[10][150];
char ll[10][150];

extern char SCBf[];
#asm         
_SCBf     dc.b $c0,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$103
          dc.b $01,$23,$45,$67,$89,$Ab,$cd,$ef
#endasm
extern char SCB1[];
#asm         
_SCB1     dc.b $c7,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$100
          dc.b $01,$23,$45,$67,$89,$AB,$CD,$eF
#endasm
extern char SCBt[];
#asm         
_SCBt     dc.b $c0,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$103
          dc.b $21,$23,$45,$67,$89,$AB,$CD,$eF
#endasm

unsigned char niveau[10][5];
unsigned char grille[10][5];
char ligne[5];
int choix, chrono, fin, test, joytest, oldJoystick, decalage;
char vitesseChrono;
int scoreJeu;
int i,j,k,x,y;
int r;
int jauge[7],nextJauge[7];
int KK, squalyl, godzil, godzilI, godzilJ, nil;
char bruni, tempBruni[7],folco,succes;
char effet;
char pile[3];

char couleur[7] = {1,11,5,7,13,15,3};
char txtFedora[250] = 
"Installation de Fedora 40.2812 en cours.^Desarmement du 65C02.....^Configuration du noyau......^Reeducation de Suzy et Mickey...........^Interconnexion des bus et des trams...^Rebootez la console pour redemarrer.&";
char txtBlague[600]; 

extern void LoadFileTo();

// assembler vertical retrace syncronisation routine
void Vsync() 
{
#asm
vretrace:
	lda $fd0a
	bne vretrace
#endasm
}

void AfficheSCB(ix, iy, iCTL0, idata, iSCB)
int ix, iy,iCTL0
char *idata
char *iSCB
{
   SCBX(iSCB) = ix;
   SCBY(iSCB) = iy;
   SCBCTL0(iSCB) = iCTL0;
   SCBDATA(iSCB) = idata;
   DrawSprite(iSCB);
}

void Aff5ch(c, x, y, col)
int c;
unsigned char x, y, col;
{
        AffCarV(c/10000+16,x,y,col);
        AffCarV((c%10000)/1000+16,x,y+4,col);
        AffCarV((c%1000)/100+16,x,y+8,col);
        AffCarV((c%100)/10+16,x,y+12,col);
        AffCarV((c%10)+16,x,y+16,col);      
}


void AffCar(c,xx,yy,col)
int xx,yy,c;
char col;
{
   SCBPAL(SCBt)=col;
   AfficheSCB(xx,yy,192,f[c],SCBt);
}

void AffCarV(c,xx,yy,col)
int xx,yy,c;
char col;
{
   SCBPAL(SCBt)=col;
   AfficheSCB(xx,yy,192,v[c],SCBt);
}

int AffPave(max)
int max;
{
   int a,xt,yt;

   xt=0;
   yt=0;
   i=0;

   while ((txtFedora[i] != '&') && (i < max))
   {
      if (txtFedora[i] == '^')
      {
            xt=0;
            yt+=8;
      }
      else if (txtFedora[i] > 31)
      {
         a = txtFedora[i] - ' ';
         AffCar(a,xt,yt,9);
         xt+=4;
      }
      i++;
   }
   if (txtFedora[i] == '&')
      return 10000;
   else
      return max+1;
}

void AffBlague()
{
   int a,xt,yt;

   xt=153;
   yt=1;
   a = random()%MAX_BLAGUES;
   for (i=0;i<600;i++)
      txtBlague[i] = 0;
   LoadFileTo(74+a,txtBlague);
   i=0;

   while (txtBlague[i] != 0)
   {
      if (txtBlague[i] == 13)
      {
            yt=1;
            xt-=7;
      }
      else if (txtBlague[i] > 31)
      {
         a = txtBlague[i] - ' ';
         AffCarV(a,xt,yt,9);
         yt+=4;
      }
      i++;
   }
}
/*********************/
/* wait for a button */
/*********************/
char WaitButton()
{
   char key;
   while (joystick);
   while ( (key = joystick) != BUTTON_OUTER)      ;
   /* wait for the button to be released */
   while ( joystick )      ;
   return key;
}


void loadLevel()
{
      x = 0;
      y = 9;
      for (i=0;i<10;i++)
         for (j=0;j<5;j++)
         {
            niveau[i][j] = 0;
            ligne[j] = (random())%6+1;
         }   
      for (k=0;k<choix+1;k++)
         nouvelleLigne();
}

void nouvelleLigne()
{
   for (j=0;j<5;j++)
      if (niveau[0][j] > 0)
         fin = 0;

   for (i=0;i<9;i++)
      for (j=0;j<5;j++)
      {
         niveau[i][j] = niveau[i+1][j];
      }   
   for (j=0;j<5;j++)
   {
      niveau[9][j] = ligne[j];
      ligne[j] = (random())%6+1;
   }   
      
   chrono = 160;
   decalage = 0;
}

void chuteGrille()
{
   char e;
   for (i=8;i>=0;i--)
   {
      for (j=0;j<5;j++)
      {
         e = niveau[i][j]%100;
         if ((e > 0) && (e < 7))
         {
            if (niveau[i+1][j] == 0)
            {
               niveau[i+1][j] = 100+e;
               niveau[i][j] = 0;
            }
            else
            {
               niveau[i][j] = e;
            }       
         }
         else if (e == 7)
         {
            if ((niveau[i+1][j] == 0) && (niveau[i+1][j+1] == 0))
            {
               niveau[i-1][j]   =  0;
               niveau[i-1][j+1] =  0;
               niveau[i][j]     = 17;
               niveau[i][j+1]   = 17;
               niveau[i+1][j]   =  7;
               niveau[i+1][j+1] = 17;
            }
         }
         else if (e == 8)
         {
            for (k=0;k<5;k++)
            {
               if (niveau[i+1][k] != 0)
                  k = 10;
            }
            if (k < 10)
            {
               for (k=0;k<5;k++)
               {
                  niveau[i+1][k] = niveau[i][k];
                  niveau[i][k] = 0;
               }
            }

         }
      }  
   } 
   for (j=0;j<5;j++)
   {
      e = niveau[9][j]%100;
      if ((e > 0) && (e < 7))
             niveau[9][j] = e;     
   }
}

void addPile(v)
char v;
{
   if (pile[0] == 0)
      pile[0]=v;
   else if (pile[1] == 0)
      pile[1]=v;
   else if (pile[2] == 0)
      pile[2]=v;
   else 
   {
      pile[0] = pile [1];
      pile[1] = pile [2];
      pile[2] = v;
   }
}

void testGrille()
{
   bcopy(&niveau[0][0], &grille[0][0], 50);

   for (i=0;i<10;i++)
   {
      for (j=0;j<5;j++)
      {
         r = grille[i][j];
         if ((j<3) && (r > 0) && (r < 7))
         {
            if ((r == grille[i][j+1]) && (r == grille[i][j+2]))
            {
               scoreJeu+=5*r;
               jauge[r]++;
               niveau[i][j]   = 0;
               niveau[i][j+1] = 0;
               niveau[i][j+2] = 0;
               if ((r==1) && (KK == 20000))
                  addPile(9);
               if ((r==6) && (folco == 2))
                  addPile(9);
               if (scoreJeu > 100)
               {
                  if (scoreJeu%100 == 0)
                     addPile(7);
                  if ((scoreJeu < 1000) && (scoreJeu%111 == 0))
                      addPile(7);
                  else if ((scoreJeu < 10000) && (scoreJeu%1111 == 0))
                      addPile(7);
               }
            }
         }
         if ((i<8) && (r > 0) && (r < 7))
         {
            if ((r == grille[i+1][j]) && (r == grille[i+2][j]))
            {
               scoreJeu+=3*r;
               jauge[r]++;
               niveau[i][j]   = 0;
               niveau[i+1][j] = 0;
               niveau[i+2][j] = 0;
               if ((r==1) && (KK == 20000))
                  addPile(9);
               if ((r==6) && (folco == 2))
                  addPile(9);
               if (scoreJeu > 100)
               {
                  if (scoreJeu%100 == 0)
                     addPile(7);
                  if ((scoreJeu < 1000) && (scoreJeu%111 == 0))
                     addPile(7);
                  else if ((scoreJeu < 10000) && (scoreJeu%1111 == 0))
                     addPile(7);
                }
            }
         }
      } 
   }
}


void loadTileSet(numero)
char numero;
{
     LoadFileTo(3+numero,fond);
     for (i=0;i<9;i++)
     {
        LoadFileTo(12+18*(numero)+i,rr[i]);
        LoadFileTo(21+18*(numero)+i,ll[i]);
     }
     LoadFileTo(66+numero,ptPen);
     LoadFileTo(69+numero,barreB);

}

char attack()
{
   loadTileSet(0);
   fin = 1;
   SCBX(SCBf) = 0;
   SCBY(SCBf) = 0;
   SCBDATA(SCBf) = fond;
   decalage = 0;
   KK = 0;
   squalyl = 0;
   godzil = 0;
   godzilJ = 0;
   folco = 0;
   bruni = 0;
   nil = 0;
   vitesseChrono=1;
   for (i=0;i<3;i++)
      pile[i]=0;

   for (i=0;i<7;i++)
   {
      jauge[i]=0;
      nextJauge[i]=5;
      tempBruni[i]=0;
   }

   while (fin > 0)
   {
      if (KK == 10000)           // Reboot pour switch en Fedora mode
      {
         if ((joystick & BUTTON_OPTION1) && (switches & BUTTON_PAUSE))
         {
            while (switches & BUTTON_PAUSE);
            KK = 20000;
            loadTileSet(1);
          }
      }
      else if (effet == 5)       // Blaque de Vince
      {
         effet = 0;
         DrawFBox(0,0,160,102,1);
         AffBlague();
         Vsync();
         SwapBuffers();
         WaitButton();     
      }
      else
      {
         DrawSprite(SCBf);
         if (decalage == 0)
         {
            if (pile[0] > 0)
            {
               succes = 0;
               switch (pile[0])
               {
                  case 1:                 // Fedora Mode
                     if (KK == 0)
                        KK = 1;
                     else
                        KK=10000;

                     succes = 1;
                     break;
                  case 2:                 // Squalyl : copie ligne du bas sur future ligne
                     squalyl = 80;
                     succes = 1;
                     break;
                  case 3:                 // Godzil mode
                     succes = 1;
                     LoadFileTo(72,bigSprite);
                     godzil=240;
                     godzilJ=3;
                     break;
                  case 4:                 // Zeph mode : 2 blocs chutent sur 1 bloc identique
                     for (i=0;i<5;i++)
                     {
                        k = (random())%5;
                        if ((niveau[0][k] == 0) && (niveau[1][k] == 0))
                        {
                           for (j=2;j<10;j++)
                           {
                              if (niveau[j][k] > 0)
                              {
                                 if (niveau[j][k] < 7)
                                    j = 15;
                                 else
                                    j = 20;
                              }
                           }
                           if ((j > 10) && (j < 20))
                              i = 10;
                        }
                     }
                     if (i > 10)
                     {
                        for (j=2;j<10;j++)
                        {
                           if (niveau[j][k] > 0)
                           {
                              niveau[0][k]=niveau[j][k];
                              niveau[1][k]=niveau[j][k];
                              j = 10;
                           }
                        }
                     }
                     succes = 1;
                     break;
                  case 5:                 // Vince mode : affiche une blaque
                     effet = 5;
                     succes = 1;
                     break;
                  case 6:                 // Folco mode : passage en mode affichage niveaux de gris
                     folco = 2;
                     loadTileSet(2);
                     succes = 1;
                     break;
                  case 7:                 // Penpen mode : affichage 'un bloc 2x2
                     k=random()%4;
                     if ((niveau[0][k] == 0) && (niveau[0][k+1] == 0) && (niveau[1][k] == 0) && (niveau[1][k+1] == 0))
                     {
                        niveau[1][k]   =  7;
                        niveau[1][k+1] = 17;
                        niveau[0][k]   = 17;
                        niveau[0][k+1] = 17;
                        succes = 1;
                     }
                     break;
                  case 8:                 // Brunni mode : barre Brunni
                     for (j=0;j<5;j++)
                        if (niveau[0][j] > 0)
                           j=10;
                     
                     if (j<10)                           
                     {
                        if (vitesseChrono < 10)
                           vitesseChrono = 2*vitesseChrono;
                        niveau[0][0] = 8;
                        for (j=1;j<5;j++)
                           niveau[0][j] = 18;
                        succes = 1;
                     }
                     break;
                  case 9:                 // Normal mode : retour à la normale
                     folco = 0;
                     KK=15000;
                     loadTileSet(0);
                     succes = 1;
                     break;
               }
               if (succes == 1)
               {
                  pile[0] = pile [1];
                  pile[1] = pile [2];
                  pile[2] = 0;
               }
            }      
         }
         else
         {
            for (i=0;i<3;i++)
            {
               if (pile[i] > 0)
               {
                  SCBX(SCB1) = 50+20*i;
                  SCBY(SCB1) = 85;
                  SCBDATA(SCB1) = rr[pile[i]-1];
                  DrawSprite(SCB1);
               }
            }
         }         
         for (i=0;i<10;i++)
         {
            SCBX(SCB1) = 144-16*i + decalage;

            for (j=0;j<5;j++)
            {
               r = niveau[i][j]%100;
               if ((r > 0) && (r < 10))
               {
                  SCBY(SCB1) = 1+16*j;
                  switch (r)
                  {
                     case 7 :
                        SCBDATA(SCB1) = ptPen;
                        break;
                     case 8 :
                        SCBDATA(SCB1) = barreB;
                        break;
                     default :                           
                        SCBDATA(SCB1) = rr[r-1];
                  }
                  DrawSprite(SCB1);
               }
            }
         }

         SCBX(SCB1) = 144-16*y + decalage;
         SCBDATA(SCB1) = curseur;
         SCBY(SCB1) = 1+16*x;
         DrawSprite(SCB1);
         SCBY(SCB1) += 17;
         DrawSprite(SCB1);

         SCBY(SCB1) = 1;
         SCBX(SCB1) =  decalage-16;
         for (j=0;j<5;j++)
         {
               r = ligne[j]-1;
               SCBDATA(SCB1) = ll[r];
               DrawSprite(SCB1);
               SCBY(SCB1) += 16;
               if (squalyl == 80-(j*16+8))
               {
                  if (niveau[9][j] > 0)
                     ligne[j] = niveau[9][j];
                  if (j == 4)
                     squalyl = 0;
               }
         }

         for (i=1;i<7;i++)
         {
            DrawFBox(1,81+3*i,4*nextJauge[i],2,couleur[0]);
            DrawFBox(1,81+3*i,4*jauge[i],2,couleur[i]);
            if (tempBruni[i] == 1)
               DrawFBox(25,81+3*i,2,2,couleur[i]);
         }

         if ((KK > 0) & (KK < 10000))
            KK=AffPave(KK);
         
         if ((squalyl > 0) && (squalyl < 100))
         {
               SCBY(SCB1) = (80-squalyl);
               SCBX(SCB1) =  0;
               SCBDATA(SCB1) = s000004;
               DrawSprite(SCB1);
               squalyl-=4;
         }
         if (godzil > 0)
         {
               SCBY(SCB1) = 16*godzilJ;
               SCBDATA(SCB1) = bigSprite;
               SCBX(SCB1) =  godzil;
               godzil-=4;
               if ((godzil<160) && ((godzil%16)==0))
               {
                  godzilI = 10 - godzil/16;
                  k = niveau[godzilI][godzilJ];
                  if ((k<10) && (niveau[godzilI][godzilJ-1] < 10))
                  {
                     niveau[godzilI][godzilJ] = niveau[godzilI][godzilJ-1];
                     niveau[godzilI][godzilJ-1] = k;
                  }
               }
               DrawSprite(SCB1);
         }
                              
         chuteGrille();
         if (decalage%4 == 1)
            testGrille();
                     
         chrono-=vitesseChrono;
         decalage = (160-chrono)/10;      
         if (chrono <= 0)
         {
            nouvelleLigne();
            if (y > 0)
               y--;
         }
         bruni = 0;
         for (i=1;i<7;i++)
         {
            bruni += tempBruni[i];
            if (jauge[i] >= nextJauge[i])
            {
               addPile(i);
               tempBruni[i] = 1;
               jauge[i] = 0;
//               nextJauge[i] = 10;
            }
         }
         if (bruni == 6)
         {
            addPile(8);
            for (j=1;j<7;j++)
               tempBruni[j] = 0;
         }

         
         if (joytest > 0)
         {
            joytest--;
            if (joystick != oldJoystick)
               joytest = 0;
         }
         if ((joytest == 0) && (joystick))
         {
            if ((joystick & JOY_DOWN) && (x<3))
            {
               x++;
            }
            if ((joystick & JOY_UP) && (x>0))
            {
               x--;
            }

            if ((joystick & JOY_LEFT) && (y<9))
            {
               y++;
            }
            if ((joystick & JOY_RIGHT) && (y>0))
            {
               y--;
            }
            if ((joystick & BUTTON_OUTER))
            {
               chrono -= 10;
               decalage = (160-chrono)/10;      
            }
            if ((joystick & BUTTON_INNER))
            {
               r = niveau[y][x];
               if ((r<7) && (niveau[y][x+1]<7))
               {
                  niveau[y][x] = niveau[y][x+1];
                  niveau[y][x+1] = r;
               }
            }
            joytest = 2;
            oldJoystick = joystick;
         }
         
         if (switches & BUTTON_PAUSE)
         {
               while (switches & BUTTON_PAUSE);
               while (!joystick);
         }

         SCBY(SCB1) = 68;
         SCBX(SCB1) = 137;
         SCBDATA(SCB1) = score;
         DrawSprite(SCB1);
         Aff5ch(scoreJeu,141,76,9);

         if (KK == 10000)
         {
            SCBX(SCB1) = 100;
            SCBY(SCB1) = 8;
            SCBDATA(SCB1) = fedora;
            DrawSprite(SCB1);
         }
         Vsync();
         SwapBuffers();
      }
   }

   WaitButton();     
}


char Menu()
{
     fin=0;
     LoadFileTo(2,fond);
     while (fin == 0)
     {
         SCBX(SCBf) = 0;
         SCBY(SCBf) = 0;
         SCBDATA(SCBf) = fond;
         DrawSprite(SCBf);

         Vsync();
         SwapBuffers();

         while(!joystick)
            r=random();               
         if (joystick & BUTTON_INNER)
            fin=1;
         if (joystick & BUTTON_OUTER)
            fin=1;
         while(joystick);
     }
     return 0;
}


/**************************************************************************
**                                                                       **
**                                                                       **
**************************************************************************/
main() 
{
  InitIRQ();
  CLI;

  SetBuffers(SCREEN, RENDER,0);

  /* set the palette */
  SetRGB(pal);

  for (;;)
  {
      choix=Menu();
      scoreJeu = 0;
      loadLevel();
      attack();
  }
}
