extern void LoadFileTo();
extern unsigned char FileEntry[8];


#asm
*************************************************
* File - functions
*************************************************
; exported functions,labels:
                global _FileEntry
                global _LoadFileTo


                xref popax,tstax
                xref __iodat

; benutzt die gleichen Adressen wie explode1
FileCurrBlock   = $C0
FileBlockByte   = $C1
FileDestPtr     = $C3

_FileEntry       = $C5
FileStartBlock   = $C5
FileBlockOffset  = $C6
FileExecFlag     = $C8
FileDestAddr     = $C9
FileFileLen      = $CB

a0      = $C0 ; 2


;*******************************************
; void LoadFileTo(uchar bFileNr,char *FileAddr)
; loads the specified directory entry
; into the global structure FileEntry
_LoadFileTo:
    jsr enterfun

    ldy #2
    jsr ldaxysp

    sta FileDestPtr                ;  lo
    stx FileDestPtr+1              ;  hi

    ldy #4
    jsr ldaxysp

    jsr FileLoadFile

    stx a0
    sty a0+1

    ldy #0
    jmp exitfun


;**********************************
; Load directory-entry
; In: Accu = entry number
; X: This is only Called from FileOpenFile,
; where x is anyway overwritten
;**********************************
FileLoadDir:    
        pha
;		lda #$10                ; bank switch par AUDIN : reset AUDIN
;		trb __iodat             ; mais ça marche pas
		lda #$b2
		sta FileReadByte+1
        pla
                stz FileCurrBlock
                jsr FileSelectBlock

                tax ; Sichere Nummer
                lsr  ; *8, oberes Byte
                lsr 
                lsr 
                lsr 
                lsr 
                pha
                txa
                asl  ; *8, unteres Byte
                asl 
                asl 
                clc             ; over-read the cart-header
                adc #<$380
                eor #$ff
                tax
                pla ; oberes byte mit CARRY addieren
                adc #>$380
                eor #$ff
                tay
                jsr FileReadOver

                ldx #0
                ldy #8
ploopLD         jsr FileReadByte
                sta _FileEntry,x
                inx
                dey
                bne ploopLD

;		        lda #$80                        ; 16°bit de l offset indiquant que le fichier est sur AUDIN 1
;		        tsb FileBlockOffset+1           ; positionne le bit et teste
;		        bne pbank00                     ; si position KO (le bit était allumé) alors le fichier est sur AUDIN 0
;		        lda #$10                        ; mais de toutes manières, le bank switch sur AUDIN marche pas
;		        tsb __iodat                     ; donc on commente
pbank00	        lda #$40                        ; 15°bit de l offset indiquant que le fichier est sur RCART1
		        tsb FileBlockOffset+1           ; positionne le bit et teste
                bne pbank0                      ; si position KO (le bit était allumé) alors le fichier est sur CART0
		        lda #$b3                        ; sinon, on indique qu on va utiliser CART1
                bra pbank
pbank0	        lda #$b2                        ; on utilise CART0
pbank	        sta FileReadByte+1

                rts

;**********************************
; Open file, i.e. select block, over-read offset, set DestPtr
; In: Accu = file number
; Out: X:Y = file length
;**********************************
FileOpenFile:   jsr FileLoadDir         ; charge informations Directory
                lda FileDestAddr        ; test adresse destination du directory
                ora FileDestAddr+1      ; dest == 0 ? non renseignée ?
                bne pcont0              ; si renseignée, alors on passe à la suite

                lda FileDestPtr         ; si non renseignée
                sta FileDestAddr        ; on utilise l adresse fournit en paramètre à LoadFileTo
                lda FileDestPtr+1
                sta FileDestAddr+1
                bra pcont1

pcont0:
                lda FileDestAddr        ; si renseignée, on utilise l adresse du directory
                sta FileDestPtr
                lda FileDestAddr+1
                sta FileDestPtr+1

pcont1:         lda FileStartBlock      ; block de début du fichier
                sta FileCurrBlock       ; set current block à startblock
                jsr FileSelectBlock     ; se positionne sur le block

                ldx FileBlockOffset     ; charge les 2 chars de l offset dans les registres X & Y
                ldy FileBlockOffset+1   ; set offset
                jsr FileReadOver        ; skippe l offset

                ldx FileFileLen         ; charge la taille du fichier dans X & Y
                ldy FileFileLen+1       ; return file length
                rts

;**********************************
; load file
; In: Accu = file number
;**********************************
FileLoadFile:   jsr FileOpenFile        ; set position in cartridge and
                                        ; get file length in X:Y
                jsr FileReadBytes       ; read the whole file to its DestAddr
                ldx FileDestAddr        ; return destination address
                ldy FileDestAddr+1
                rts


;**********************************
; Overread some bytes
; X:Y count (EOR $FFFF)
;**********************************
FileReadOver:   inx                     ; incrémente X
                bne qcont0              ; si pas overflow, lit un octet
                iny                     ; incrémente Y
                beq pexit               ; si overflow, fin offset
qcont0          jsr FileReadByte        ; lit un octet sans le stocker
                bra FileReadOver        ; suivant

;**********************************
; load to DestPtr
; X:Y count (EOR $ffff)
;**********************************
FileReadBytes:  inx                    ; boucle pour lire n octets (INT défini dans X et Y)
                bne qcont1
                iny
                beq pexit
qcont1:         jsr FileReadByte       ; lit one byte from the cartridge
                sta (FileDestPtr)      ; écrit l octet à la  destination  
                inc FileDestPtr        ; incrémente le pointeur destination 
                bne FileReadBytes
                inc FileDestPtr+1
                bra FileReadBytes

;**********************************
; Read one byte from cartridge
;**********************************
FileReadByte:   lda $fcb2               ; charge l octet dans A
                inc FileBlockByte       ; incrémente le compteur d octets lus
                bne pexit
                inc FileBlockByte+1
                bne pexit

;**********************************
; Select a block
;**********************************
FileSelectBlock:
                pha             ; sauvegarde les 3 registres
                phx
                phy
                lda __iodat     ; 
                and #$fc        ; met à 0 les bits 0 et 1
                tay             ; copie A dans Y
                ora #2          ; met à 1 alimentation cartouche
                tax             ; copie A dans X
                lda FileCurrBlock
                inc FileCurrBlock
                sec             ; set carry flag
                bra SLB2

SLB0:           bcc SLB1
                stx $fd8b
                clc

SLB1:           inx
                stx $fd87       ; SYSCTL1
                dex

SLB2:           stx $fd87       ; SYSCTL1
                rol a           ; rotate left A
                sty $fd8b
                bne SLB0

                lda __iodat
                sta $fd8b
                stz FileBlockByte
                lda #$100-(>2048)           ; taille du bloc = 2048
                sta FileBlockByte+1
                ply
                plx
                pla

pexit           rts

#endasm
