;modifi pour MI-9 by rockyone
;----------------------------
;
; PALETTE SPLIT
; allow GFABASIC to do a single palette split after a given amount 
; of scanlines
;
; (c) 2007 by Simon Sunnyboy / Paradize
; http://paradize.atari.org/
;
; USE AT YOUR OWN RISK!
;
;
; ** register equates **

*palette        EQU $FFFF8240

iera           EQU $FFFFFA07
ierb           EQU $FFFFFA09
ipra           EQU $FFFFFA0B
iprb           EQU $FFFFFA0D
imra           EQU $FFFFFA13
imrb           EQU $FFFFFA15
isra           EQU $FFFFFA0F
isrb           EQU $FFFFFA11
tbdr           EQU $FFFFFA21
tbcr           EQU $FFFFFA1B

count_scanlines EQU 8			; mode comptage d'vnement

; ** TOS system variables **
*_vbclock       EQU $0462
*_frclock       EQU $0466

;.......................................ISR locations...................
vbl            equ $70
timerb         equ $0120

;.......................................jump table.......................
;
	bra.s	init_rasters	;+28
	bra.s	stop_rasters	;+30
;
;.......................................interface........................
;
raster_address:									
	dc.l	0		;+32 points to a block with 2 palettes
	dc.b	0,0,0		;+36 

gap_control:   
	dc.b	$0		;+38 number of scanlines to wait for split
	even

storage:
	dc.l	$00,$00		;+40 ...  0 pour reset
	dc.b	$00,$00,$00,$00,$00
	even
;
;...............................................disable splitscreen......
;
stop_rasters:
        move.l  a3,-(SP)
        move.w	#$2700,SR			; stop irq system

        lea.l	storage(PC),A3

        move.l  (A3)+,vbl			; restore old VBL
        move.l  (A3)+,timerb			; save old Timer B
        move.b  (A3)+,tbcr			; restore MFP context
        move.b  (A3)+,tbdr
        move.b  (A3)+,iera
        move.b  (A3)+,ierb
        move.b  (A3)+,imra

        move.w	#$2300,SR			; reenable irqs
;............................add by rockyone.....
	move.b	#0,-(a3)			; Reset for next routine
	move.l	#0,-(a3)			; call 
	move.l	#0,-(a3)			;
	move.l	#0,-(a3)			;		
;................................................
        movea.l (SP)+,a3

        rts
;
;.......................................init raster interrupt system....
;
init_rasters:
	movem.l d0-d7/a0-a6,-(SP)

        lea.l	storage(PC),a3			; store interrupt context
        move.l  vbl,(a3)+			; save old VBL
        move.l  timerb,(a3)+			; save old Timer B
        move.b  tbcr,(a3)+
        move.b  tbdr,(a3)+
        move.b  iera,(a3)+
        move.b  ierb,(a3)+
        move.b  imra,(a3)+
;
;.......................................set interrupts....................
;
        move.w	#$2700,SR			; stop interrupts
        lea.l	rastercontrol_vbl(PC),a1
        move.l  a1,vbl				; set new VBL
        lea.l	raster_timerb(PC),a1
        move.l  a1,timerb			; set new Timer B

; enable Timer B
        ori.b   #1,iera				; enable Timer B
        ori.b   #1,imra				; mask Timer B
        clr.b   tbcr				; stop Timer B

        move.w	#$2300,SR			; reenable interrupts
        movem.l (SP)+,D0-d7/a0-A6
        rts

;
;.......................................new VBL to control the rasters..
;
rastercontrol_vbl:
        movem.l d0-d7/a3,-(SP)
        clr.b	tbcr			; stop Timer B

        lea.l	raster_address(PC),a3	; address palette
        movea.l (a3),a3

        movem.l (a3),d0-d7		; load new palette
        movem.l d0-d7,$ffff8240		; get and set new color

        move.b  gap_control(PC),tbdr	; load gap_control ( number line )
        move.b  #count_scanlines,tbcr	; activate Timer B to count 
;					; raster lines
        movem.l (SP)+,d0-d7/a3

	move.l  storage(PC),-(SP)	; push old VBL address onto stack
        rts				; and jump to it :)
;
;........................................screensplit handling Timer B ISR 
;
raster_timerb:
	movem.l d0-d7/a2,-(SP)
	lea.l	raster_address(PC),a2	; set new color from table
        movea.l (a2),a2
        movem.l 32(a2),d0-d7		; load second palette 
        movem.l d0-d7,$ffff8240

        bclr.b  #0,isra			; acknowledge Timer B

        movem.l (SP)+,d0-d7/a2
        rte

        END
;------------------------------------------------------------------------