define96x64window:
	ld hl,$10b8	; bgr mode, increment order
	ld a,$03
	call setlcdregister
	ld hl,0	; coord start
	ld a,20h	; set y coord = 0
	call setlcdregister+2   ; a incremented to 21h
	call setlcdregister+2   ; set x coord = 0
	ld a,50h	; horizontal
	call setlcdregister+2   ; set y coord = 0
	ld hl,63
	call setlcdregister+2   ; set y coord = 63
	ld hl,0
	call setlcdregister+2   ; set x coord = 0
	ld hl,95
	call setlcdregister+2   ; set x coord = 95

bwimage:
;inputs:
;	hl points to the data
;	the window is already defined
;outputs:
;	b,d,e are all 0
;	a is either $00 or $ff
;	c is the last byte of the buffer

	ld de,3	; 10	10
bwloop:	;
	ld b,8	; 7	7*768
	ld a,(hl)	; 7	7*768
	cpl	; 4	4*768
	ld c,a	; 4	4*768
bwloop2:	;
	rlc c	; 8	8*6144
	sbc a,a	; 4	4*6144
	out (11h),a   ; 11	11*6144
	out (11h),a   ; 11	11*6144
	djnz bwloop	; 13|8	768(13*8-5)
	dec d	; 4	4*768
	jr nz,bwloop	; 12|7	12*768-15
	dec e	; 4	4*3
	jr nz,bwloop	; 12|7	12*3-5
	ret	; 10	10
;total time:
;314160 t-states.

setlcdregister:
	ld c,$11
	out ($10),a\	out ($10),a
	out (c),h
	out (c),l
	inc a
	ret

rectangle:
;inputs:
;	de = color
;	4 pushes to the stack in order:
;	push <width>
;	push <right coordinate>
;	push <height>
;	push <upper coordinate>
;ram: needs 2 bytes of ram:
;	(tempword1) is two bytes
	ld hl,$10b8	; bgr mode, increment order
	ld a,$03
	call setlcdregister
	pop hl\	ex (sp),hl
	ld a,20h	; set upper coordinate
	call setlcdregister+2   ; a incremented to 21h
	ld a,50h	; horizontal
	call setlcdregister+2   ;
	ld b,h
	ld c,l
	pop hl\	ex (sp),hl
	ld (tempword1),hl
	add hl,bc
	call setlcdregister+2   ; set lower coordinate

	pop hl\	ex (sp),hl
	ld a,21h
	call setlcdregister+2
	ld a,52h
	call setlcdregister+2   ; set right coordinate
	ld b,h
	ld c,l
	pop hl\	ex (sp),hl
	push hl
	add hl,bc
	call setlcdregister+2   ; set left coordinate
	pop hl	;width
	ld a,(tempword1)	;
	ld b,a	; b is height
;de is color
;c is 11h
;b is the height
;hl is the width
	dec hl
	inc h
	inc l
	push hl
fillrectloop:
	out (c),d
	out (c),e
	dec l
	jr nz,fillrectloop
	dec h
	jr nz,fillrectloop
	pop hl
	djnz fillrectloop-1
	ret