/*
** JavaScript for Hail GUI
*/

(function()
{
	Hail = {
		renders: {
			pretty: function (json)
			{
				return {
					html:	'<div class="render-pretty">' + JSON.stringify (json, null, 4) + '</div>'
				};
			},

			table:	function (json)
			{
				var columns;
				var found;
				var header;
				var index;
				var row;
				var rows;
				var	table;

				columns = {};
				header = $('<tr></tr>');
				rows = [];
				table = $('<table class="render-table"></table>');

				for (index = 0; ; ++index)
				{
					found = false;
					row = $('<tr></tr>');

					for (var name in json.columns)
					{
						if (index >= json.columns[name].length)
							continue;

						if (!columns[name])
						{
							for (var i = 0; i < rows.length; ++i)
								rows[i].append ($('<td></td>'));

							columns[name] = true;

							$('<th></th>')
								.appendTo (table)
								.text (name);
						}

						$('<td></td>')
							.appendTo (row)
							.text (json.columns[name][index]);

						found = true;
					}

					if (!found)
						break;

					rows.push (row);
				}

				table.append (header);

				for (var i = 0; i < rows.length; ++i)
					table.append (rows[i]);

				return {
					html:	table
				};
			}
		},

		resources: {
			urls: {
				destroy:	'-%20sample/destroy.json',
				register:	'-%20sample/register.json',
				update:		'-%20sample/update.json'
			}
		},

		windows: {
			input: function (origin)
			{
				var feedback;
				var	submit;
				var window;

				window = $('<aside class="window" style="width: 480px;"><h1>New expression</h1><div class="content"><table class="form"><tr><th style="width: 100px;">Query expression:</th><td><textarea name="expression" class="fill" rows="4"></textarea></td></tr><tr><th>Display result as:</th><td><select name="render"><option value="table">Values in a tabular grid</option><option value="pretty">Pretty-printed JSON</option></select></td></tr><tr><th>Refresh every:</th><td><input type="text" name="interval" value="5" /> second(s)</td></tr></table></div><div class="control"><input name="submit" type="button" value="Submit" /> <span class="feedback"></span></div></aside>');

				feedback = window.find ('span.feedback');
				submit = window.find ('input[name="submit"]');

				window
					.appendTo ('body')
					.position ({
						collision:	'fit',
						at:			'left top',
						of: 		$(origin),
						my:			'left top'
					})
					.draggable ({
						containment:	'body',
						handle: 		window.find ('h1'),
						stack:			'.window'
					})
					.resizable ({
						containment:	'body',
						alsoResize:		window.find ('.content')
					});

				submit
					.on ('click', function (event)
					{
						feedback.html ('');
						feedback.hide ();

						submit.addClass ('loading');

						jQuery
							.getJSON (Hail.resources.urls.register, {
								expression:	window.find ('input[name="expression"]').val ()
							})
							.done (function (json)
							{
								var	interval;
								var render;

								submit.removeClass ('loading');

								if (!json.id)
								{
									feedback.html ('Registration failed (' + json.error + ')');
									feedback.show ();

									return;
								}

								feedback.html ('');
								feedback.hide ();

								interval = Math.max (window.find ('input[name="interval"]').val (), 1) * 1000;
								render = Hail.renders[window.find ('select[name="render"]').val ()] || Hail.renders.pretty;

								Hail.windows.show (event, json.id, interval, render);
							})
							.fail (function ()
							{
								submit.removeClass ('loading');

								feedback.html ('Registration failed (network failure)');
								feedback.show ();
							});
					});
			},

			show : function (origin, id, interval, render)
			{
				var content;
				var dismiss;
				var execute;
				var freeze;
				var refresh;
				var save;
				var setup;
				var timeout;
				var window;

				execute = function ()
				{
					refresh.addClass ('loading');

					jQuery
						.getJSON (Hail.resources.urls.update, {
							id:	id
						})
						.done (function (json)
						{
							var	output;

							refresh.removeClass ('loading');

							output = render (json, save);
							save = output.save;

							content.html (output.html);
						})
						.fail (function ()
						{
							refresh.removeClass ('loading');

							content.html ('Error while retreiving result');
						});

					setup ();
				};

				setup = function ()
				{
					if (timeout !== undefined)
						clearTimeout (timeout);

					timeout = setTimeout (execute, interval);
				};

				window = $('<aside class="window" style="width: 640px;"><h1>Expression #' + id + '</h1><div class="content"></div><div class="control"><input name="refresh" type="button" value="Refresh" /> <input name="freeze" type="button" value="Freeze" /> <input name="dismiss" type="button" value="Dismiss" /></div></aside>');

				content = window.find ('.content');
				dismiss = window.find ('input[name="dismiss"]');
				freeze = window.find ('input[name="freeze"]');
				refresh = window.find ('input[name="refresh"]');

				window
					.appendTo ('body')
					.position ({
						collision:	'fit',
						at:			'left top',
						of: 		$(origin),
						my:			'left top'
					})
					.draggable ({
						containment:	'body',
						handle: 		window.find ('h1'),
						stack:			'.window'
					})
					.resizable ({
						containment:	'body',
						alsoResize:		window.find ('.content')
					});

				dismiss
					.on ('click', function ()
					{
						jQuery
							.getJSON (Hail.resources.urls.destroy, {
								id:	id
							});

						window.remove ();
					});

				freeze
					.on ('click', function ()
					{
						if (timeout !== undefined)
							clearTimeout (timeout);
					});

				refresh
					.on ('click', execute);

				execute ();
			}
		}
	};
})();
