// special thanks Karri, Flavor, LX.NET, Obschan, Maeel
// cc65 sprite TGI - 18/12/2012
#include <stdlib.h>
#include <6502.h>
#include <lynx.h>
#include <tgi.h>
#include <conio.h>
#include <peekpoke.h>
#include <joystick.h>

extern char lynxtgi[];
extern char lynxjoy[];

char plagepal[]={
	0x00,0x05,0x09,0x0F,0x02,0x05,0x07,0x09,0x0A,0x0C,0x0D,0x08,0x0A,0x0C,0x06,0x08,
	0x00,0x65,0x99,0xFF,0x41,0x82,0xD4,0xD7,0xE8,0xEA,0xDC,0xB1,0xD3,0xD6,0x14,0x72};
	
typedef struct {
	unsigned char b0;
	unsigned char b1;
	unsigned char b2;
	void *next;
	void *bitmap;
	int posx, posy, sizex, sizey;
	char palette[8];
} sprite_t;

extern char fda[];

/*
sprite_t background = {
	0xc0, 0x10, 0x01,
	0,
	&fda,
	0, 0,
	0x100, 0x100,
	{0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF}
};
*/

static sprite_t SCB1 = {
	0xc0,0x10,0x20,
    0,0,
    0,0,0x100,0x100,
    {0x01,0x23,0x45,0x67,0x89,0xAb,0xcd,0xef}
};

void show_screen()
{
	// Clear current screen
	tgi_clear();
	tgi_sprite(&SCB1);
	tgi_setcolor(COLOR_WHITE);
	tgi_outtextxy(30, 48, "sprite ready !");
	tgi_updatedisplay();
//	WaitTicks(5000);
}

void initialize()
{
	tgi_install(&lynxtgi);
	joy_install(&lynxjoy);
	tgi_init();
	CLI();
	
	while (tgi_busy()) 
	{ 
	};

	tgi_setbgcolor(COLOR_BLACK); 
	tgi_setpalette(plagepal);
//	SCB1.posx=100;SCB1.posy=50;
	
	tgi_setcolor(COLOR_BLACK);
	tgi_clear();
}

void main(void) 
{
	unsigned char joy;
	unsigned char waitForRelease = 0;
	
	initialize();
	
	/*					-----------------------------------------------			*/
	SCB1.bitmap=&fda; // ici image
	tgi_sprite(&SCB1);
	
	
	while (1)
	{
		if (kbhit()) 
		{
			switch (cgetc()) 
			{
				case 'F':
					tgi_flip();
					break;

				default:
					break;
			}
		}

		joy = joy_read(JOY_1);
		if (!joy) waitForRelease = 0;
		if (waitForRelease != 0) continue;

		if (JOY_BTN_RIGHT(joy))
		{
			waitForRelease = 1;
		}

		if (JOY_BTN_LEFT(joy))
		{
			waitForRelease = 1;
		}

		if (!tgi_busy())
		{
			show_screen();
		}
		
		
		
		
	};
}