;modifi pour MI-9 by rockyone
;----------------------------
; Nombre de lignes-1 dans le word aprs la deuxime palette.    16.01.2018
;
;.......................................jump table.......................
;
		bra.s	init_rasters	;+28
		bra.s	stop_rasters	;+30
;
;.......................................interface........................
;
raster_address:	dc.l	0		;+32 address block with 2 palettes
;					;    1 Word start line number-1
storage:	dc.l	0,0		;+34 
		dc.b	0,0,0,0,0
		even

;...............................................disable splitscreen......

stop_rasters:
        move.l  a3,-(SP)
        move.w	#$2700,SR			; stop irq system

        lea.l	storage(PC),A3

        move.l  (A3)+,$70			; restore old VBL
        move.l  (A3)+,$120			; save old Timer B
        move.b  (A3)+,$fffffa1b.w		;tbrc restore MFP context
        move.b  (A3)+,$fffffa21.w		;tbdr 
        move.b  (A3)+,$fffffa07.w		;iera
        move.b  (A3)+,$fffffa09.w		;ierb
        move.b  (A3)+,$fffffa13.w		;irma
        move.w	#$2300,SR			; reenable irqs
        movea.l (SP)+,a3
        rts

;.......................................init raster interrupt system....
init_rasters:
	movem.l d0-d7/a0-a6,-(SP)
        lea.l	storage(PC),a3			; store interrupt context
        move.l  $70,(a3)+			; save old VBL
        move.l  $120,(a3)+			; save old Timer B
        move.b  $fffffa1b,(a3)+			;tbrc
        move.b  $fffffa21.w,(a3)+		;tbdr
        move.b  $fffffa07.w,(a3)+		;iera
        move.b  $fffffa09.w,(a3)+		;ierb
        move.b  $fffffa13.w,(a3)+		;irma

;.......................................set interrupts....................

        move.w	#$2700,SR			; stop interrupts
        lea.l	rastercontrol_vbl(PC),a1
        move.l  a1,$70				; set new VBL
        lea.l	raster_timerb(PC),a1
        move.l  a1,$120				; set new Timer B

; enable Timer B
        bset.b  #0,$fffffa07.w			;iera  enable Timer B
        bset.b  #0,$fffffa13.w			;imra  mask Timer B
        clr.b   $fffffa1b.w			;tbcr  stop Timer B

        move.w	#$2300,SR			; reenable interrupts

        movem.l (SP)+,D0-d7/a0-A6
        rts

;.......................................new VBL to control the rasters..

rastercontrol_vbl:
        movem.l d0-d7/a3,-(SP)

	sf	$fffffa21.w			;tbdr 
        sf	$fffffa1b			;tbcr stop Timer B

        lea.l	raster_address(PC),a3		; address palette
        movea.l (a3),a3
        movem.l (a3),d0-d7			; load new palette
        movem.l d0-d7,$ffff8240			; get and set new color
	move.b	65(a3),$fffffa21.w		;tbdr  number line
        move.b  #8,$fffffa1b.w			;tbcr  mode evenemet

        movem.l (SP)+,d0-d7/a3

	move.l  storage(PC),-(SP)	; push old VBL address on to stack
        rts				; and jump to it :)

;........................................screensplit handling Timer B ISR 

raster_timerb:
	movem.l d0-d7/a2,-(SP)
	lea.l	raster_address(PC),a2		; set new color from table
        movea.l (a2),a2

	move.b	$fffffa21.w,d0			;tbdr
att:	cmp.b	$fffffa21.w,d0
	beq.s	att

        movem.l 32(a2),d0-d7			; load second palette 
        movem.l d0-d7,$ffff8240.w

        bclr.b  #0,$fffffa0f.w			;isra  acknowledge Timer B

        movem.l (SP)+,d0-d7/a2
        rte

        END
;------------------------------------------------------------------------