#ifdef GL_ES
precision mediump float;
#endif

varying vec4 vColor;
varying vec2 vTexCoord;

uniform sampler2D uImage0;
uniform float uOriginY;
uniform float uMask;

void main(void)
{
	// A negative mask means only draw above uOriginY
	// A null mask is pass-through
	if((gl_FragCoord.y < uOriginY) != (uMask > 0.) && uMask != 0.)
		discard;
	
	vec4 color = texture2D(uImage0, vTexCoord);
	if (color.a == 0.0)
		discard;
	gl_FragColor = color * vColor;
}
