# Magnetoculus

Visualisation de champs magnétiques avec l'Oculus Rift et Unity.

## Utilisation

Magnetoculus permet d'explorer des champs magnétiques dans le contexte d'une ville, ou d'une partie d'une ville, afin de voir l'action de celui-ci sur les façades des bâtiments et sur la route.

### Génération d'une base de données

La première étape est d'exposer les données à l'application. Pour ce faire, l'outil DBBrowser permet d'enregistrer des champs magnétiques ainsi que des villes, puis de les lier deux à deux afin de positionner et d'orienter les champs magnétiques dans les villes.

Dans chacun des onglets "Enregistrer une ville" et "Enregistrer un champ", le bouton Enregistrer permet d'ajouter le fichier décrit par le formulaire à la base de données active, qui est créée s'il n'y a pas déjà une. Pour l'instant, cela se limite à un fichier database.db créé dans le même dossier que DBBrowser. *Une fois tous les fichiers enregistrés, il faut déplacer ce fichier dans le même dossier que l'exécutable de Magnetoculus*.

### Application principale

Une fois l'application lancée et la configuration de contrôles et de graphismes passée, un menu apparaît avec différentes options. Ce menu est un menu contextuel également accessible en tout temps par un appui sur Echap.

- **Generate a field representation** : ajoute un champ magnétique à la scène à partir de ceux de la base de données précédemment générée.
- **Generate a town** : même remarque pour les villes. Notez qu'**en l'état, il faut générer la ville avant le champ magnétique correspondant**..
- **Representation Management** : liste les différents champs et villes actifs.
- **Set color scheme** : gère la manière dont les couleurs sont assignées à différentes intensités du champ magnétique.
- **Enter Cut Mode** : obsolète. Voir plus bas.
- **Resume** : ferme le menu contextuel.
- **Quit** : ferme l'application.

### Generate a field representation

Une fois l'option correspondante sélectionnée et le fichier désiré choisi dans la liste des fichiers trouvés dans la base de données, 3 modes de génération sont proposés :
- **Voxel** : mode classique, où chaque point du champ magnétique 3D est affiché comme un cube transparent d'une couleur dépendant de l'intensité du champ à cet endroit.
- **Isosurface** : mode isosurface, où l'application génère une surface composée de tous les points où le champ a une certaine valeur à choisir (**non fonctionnel pour l'instant**).
- **Surface** : à choisir pour les champs surfaciques.

### Generate a town

La génération de la ville commence après l'avoir sélectionnée dans la liste des fichiers trouvés dans la base de données.

### Representation management

Ce menu liste les différents champs et villes actifs. Pour chaque élément dans cette liste (navigable avec les boutons flèches gauche et droite), la case cochable indique si l'entité doit être visible ou non. Le bouton "delete" permet également de supprimer cette représentation.

### Set color scheme

Ce menu permet de changer le gradient de couleurs des *prochains champs chargés*. **Pour le moment, les champs déjà chargés ont un gradient immuable**. Sélectionner n'importe laquelle des 7 couleurs permet d'en choisir une nouvelle à cet emplacement, avec la couleur n°1 correspondant à la valeur de champ la plus basse, et la couleur n°7 à la plus haute.

### Enter cut mode

Précédemment, ce mode permettait de sélectionner une façade sur laquelle projeter les champs magnétiques chargés. Cependant, cette fonctionnalité est maintenant obsolète car tous les champs chargés sont automatiquement projetés sur les villes chargées. Il suffit donc de rendre invisible un champ via le gestionnaire de représentations pour voir son effet sur les façades de la ville.

## Notes de développement

Pendant le développement, un certain nombre de problèmes ont été rencontrés. En voici l'historique non exhaustif :

- Le toolkit Oculus d'Unity ne fonctionne pas avec les versions antérieures à **Unity 5.6.6f2**. Veillez à utiliser cette version d'Unity pour compiler correctement le projet.
- Les fichiers GML et CityGML représentant les données des villes ont parfois (souvent) des sommets en double ou plus dans la définition des polygones des bâtiments. À cet effet, la classe `Polygon` a une méthode `CleanUp()` qui s'occupe de retirer proprement les doublons ainsi que toute donnée associée au doublon retiré (pour l'instant, sa coordonnée de texture). Il faut penser à appeler cette méthode après avoir fini d'instantier et de remplir les sommets et autres données d'un polygone.
- La disposition des éléments d'UI (interface graphique) est différente selon si l'on teste sur un PC ou sur l'Oculus. **Toujours** tester l'UI sur les deux plateformes d'exécution pour éviter les surprises.
- Il existe une variété de formats GML ou basés GML différents. Pour l'instant, le format GML référencé dans l'application est **CityGML 2.0**, et rien d'autre ne fonctionnera. **Attention**, CityGML 2.0 n'est pas GML 2.0, c'est un format différent.
- Attention dans OVRCameraRig à cocher la case "Use Per-Eye Cameras", sinon problème de distorsion de l'affichage.
