#include <Gamebuino-Meta.h>

#define MAP_WIDTH 128
#define MAP_HEIGHT 64

#define TILE_WIDTH          8
#define TILE_HEIGHT         8
#define TILES_PASSABLE_END  26
#define TILE_GRASS          3
#define TILE_CAVE           7
#define TILE_WATER_START    17
#define TILE_WATER_END      26
#define TILE_ELEMENT        101

#define WALK_SPEED 5

#define TEXT_SPEED 40
#define BLINK_SPEED 70

#define BUTTON_DELAY 5
#define TEXT_BUTTON_DELAY 1
#define ARROW_DELAY  5

Color pico_8_palette[] = {
  (Color)0x0000,
  (Color)0x194a,
  (Color)0x792a,
  (Color)0x042a,
  (Color)0xaa86,
  (Color)0x5aa9,
  (Color)0xc618,
  (Color)0xff9d,
  (Color)0xf809,
  (Color)0xfd00,
  (Color)0xff64,
  (Color)0x0726,
  (Color)0x2d7f,
  (Color)0x83b3,
  (Color)0xfbb5,
  (Color)0xfe75
};

byte player_x = 36;
byte player_y = 7;
byte player_direction = 3;
byte player_animation = 0;
int camera_x;
int camera_y;
byte tmp;

#include "maps.h"
#include "sprites.h"
#include "strings.h"
#include "stats.h"
#include "scripts.h"
#include "graphics.h"

const byte zone00[] = {
  SWOOTY, PIGGY, GROLDO, FEUXDINO, WATAWAMP, ROWPIM, BUZZCOR, PURBIRB, TINKERELLE, BOBERL,
  PLARADI, HATCELL, MOGMINE, CRUB, FLIPA, SNEG, PILO, LIMEGOO, DOGSHADE, PUKESUN, HUEVO
};
const byte zone01[] = { ROWPIM, PIGGY, PURBIRB };
const byte zone02[] = { GROLDO, FEUXDINO, TINKERELLE };
const byte zone03[] = { LIMEGOO };
const byte zone04[] = { MOGMINE, HATCELL, PLARADI };
const byte zone05[] = { DOGSHADE, BUZZCOR, SNEG };
const byte zone06[] = { WATAWAMP, PILO };
const byte zone07[] = { FLIPA, CRUB };

const byte map_menu[] = {
  // x, y, w, h, option id
  45, 0, 35, 27,
  M_MONSTER, M_ITEM, M_SAVE, M_RESET
};

const byte first_release_menu[] = {
  // x, y, w, h, option id
  22, 24, 35, 15,
  M_FIRST, M_RELEASE
};

const byte use_drop_menu[] = {
  // x, y, w, h, option id
  28, 24, 23, 15,
  M_USE, M_DROP
};

void setup() {
  gb.begin();
  gb.display.colorIndex = pico_8_palette;
  player_sprite_set.setTransparentColor((Color)0xff9d);
}

void loop() {
  boolean object_collision = false;
  update_camera();
  update_map();
  while (true) {
    if (gb.update()) {
      int x_direction = -gb.buttons.repeat(BUTTON_LEFT, 1) * (player_x > 0) + gb.buttons.repeat(BUTTON_RIGHT, 1) * (player_x < MAP_WIDTH - 1);
      int y_direction = -gb.buttons.repeat(BUTTON_UP, 1) * (player_y > 0) + gb.buttons.repeat(BUTTON_DOWN, 1) * (player_y < MAP_HEIGHT - 1);
      if (!x_direction != !y_direction) {
        player_direction = (1 + x_direction) * (x_direction != 0);
        player_direction = (2 + y_direction) * (y_direction != 0 || player_direction == 0);

        // check for objects to collide
        object_collision = false;
        for (byte i = 0; i < sizeof(action_triggered_scripts); i += ACTION_SCRIPTS_LENGTH) {
          if (action_triggered_scripts[i + 3] > 0 &&
              flag[action_triggered_scripts[i + 2]] == 0 &&
              player_x + x_direction == action_triggered_scripts[i] &&
              player_y + y_direction == action_triggered_scripts[i + 1]) {
            object_collision = true;
            break;
          }
        }
 
        if (TILES_PASSABLE_END - map_[(player_y + y_direction)*MAP_WIDTH + player_x + x_direction] > 0 && !object_collision) {
          for (byte i = 1; i <= 8; i++) {
            player_animation += i % 2;
            player_animation *= player_animation < 2 && i < 8;
            camera_x = (player_x * TILE_WIDTH - gb.display.width() / 2 + 4 + i * x_direction);
            camera_x = camera_x * (camera_x > 0) + (MAP_WIDTH * TILE_WIDTH - gb.display.width() - camera_x) * (camera_x > MAP_WIDTH * TILE_WIDTH - gb.display.width());
            camera_y = player_y * TILE_HEIGHT - gb.display.height() / 2 + 4 + i * y_direction;
            camera_y = camera_y * (camera_y > 0) + (MAP_HEIGHT * TILE_HEIGHT - gb.display.height() - camera_y) * (camera_y > MAP_HEIGHT * TILE_HEIGHT - gb.display.height());
            draw_map(camera_x, camera_y);
            draw_player(player_x * TILE_WIDTH - camera_x + i * x_direction, player_y * TILE_WIDTH - camera_y + i * y_direction);
            gb.update();
            delay(WALK_SPEED);
          }
          player_x += x_direction;
          player_y += y_direction;

          // check for warps
          for (byte i = 0; i < sizeof(warps); i += WARPS_LENGTH) {
            if (player_x == warps[i] && player_y == warps[i + 1]) {
              player_x = warps[i + 2];
              player_y = warps[i + 3];
              update_camera();
              break;
            }
          }

          // check for walk-triggered events
          for (byte i = 0; i < sizeof(walk_triggered_scripts); i += WALK_SCRIPTS_LENGTH) {
            if (player_x == walk_triggered_scripts[i] & player_y == walk_triggered_scripts[i + 1]) {
              script(walk_triggered_scripts[i + 2]);
              break;
            }
          }

          // check for battles
          if(rand()%2){
            if(map_[player_y * MAP_WIDTH + player_x] == TILE_GRASS){
              if(player_x < 19 && player_y < 31){
                battle(zone01, sizeof(zone01));
              }else if(player_x < 35 && player_y < 56){
                battle(zone02, sizeof(zone02));
              }else if(player_x < 35){
                battle(zone03, sizeof(zone03));
              }else if(player_x > 108 && player_y > 38){
                battle(zone04, sizeof(zone04));
              }else if(player_x > 60 && player_y > 40){
                battle(zone05, sizeof(zone05));
              }else{
                battle(zone00, sizeof(zone00));
              }
            }else if(map_[player_y * MAP_WIDTH + player_x] == TILE_CAVE){
              battle(zone06, sizeof(zone06));
            }else if(map_[player_y * MAP_WIDTH + player_x] >= TILE_WATER_START && map_[player_y * MAP_WIDTH + player_x] <= TILE_WATER_END){
              battle(zone07, sizeof(zone07));
            }
          }

        }
        update_map();
      } else if (gb.buttons.repeat(BUTTON_A, BUTTON_DELAY)) {
        for (byte i = 0; i < sizeof(action_triggered_scripts); i += ACTION_SCRIPTS_LENGTH) {
          if (flag[action_triggered_scripts[i + 2]] == 0 &&
              player_x + (player_direction == 0) - (player_direction == 2) == action_triggered_scripts[i] &&
              player_y + (player_direction == 3) - (player_direction == 1) == action_triggered_scripts[i + 1]) {
            switch (action_triggered_scripts[i + 4]) {
              case TEXT :
                text((char*) strings[action_triggered_scripts[i + 5]]);
                break;
              case SCRIPT :
                script(action_triggered_scripts[i + 5]);
                break;
            }
          }
        }
      }else if (gb.buttons.repeat(BUTTON_MENU, BUTTON_DELAY)) {
map_menu_loop:
        update_map();
        switch(menu(map_menu, sizeof(map_menu))){
          case M_MONSTER:
            stats_menu();
            goto map_menu_loop;
          case M_ITEM:
            item_menu();
            goto map_menu_loop;
          case M_SAVE:
          case M_RESET:
            break;
        }
        update_map();
      }
      
    }
  }
}

void text_frame() {
  gb.display.setColor(BLACK);
  gb.display.fillRect(0, 37, 80, 27);
  gb.display.setColor(WHITE);
  gb.display.fillRect(1, 38, 78, 25);
  gb.display.setColor(BLACK);
  gb.display.setCursor(2, 39);
}

void text_pause() {
  byte i = 0;
  byte quit = 0;
  while (!quit) {
    if (gb.update()) {
      i++;
      if (i % 2) {
        gb.display.setColor(WHITE);
      }
      gb.display.drawChar(gb.display.getCursorX(), gb.display.getCursorY(), 21, 1);
      gb.display.setColor(BLACK);
      gb.update();
      delay(BLINK_SPEED);
      if (gb.buttons.repeat(BUTTON_A, TEXT_BUTTON_DELAY)) quit = 1;
    }
  }
}

byte text(const char string[]) {
  text_frame();
  for (byte i = 0; i < strlen(string); i++) {
    char c = (char) string[i];
    switch ((byte) c) {
      case 10:
        gb.display.setCursor(2, gb.display.getCursorY()+6);
        break;
      case 112:
        text_pause();
        text_frame();
        break;
      default:
        gb.display.print(c);
        gb.update();
        delay(TEXT_SPEED);
    }
  }
  text_pause();
  update_map();
}

byte handle_vertical_cursor(byte options_number, byte x, byte y){
  byte cursor_pos = 0, prev_pos = 1;
  do{
    if (gb.update()) {
      if (cursor_pos != prev_pos) {
        gb.display.setColor(WHITE);
        gb.display.drawChar(x, y + 6 * (prev_pos), 16, 1);
        gb.display.setColor(BLACK);
        gb.display.drawChar(x, y + 6 * (cursor_pos), 16, 1);
        prev_pos = cursor_pos;
      }
      cursor_pos -= gb.buttons.repeat(BUTTON_UP, ARROW_DELAY) * (cursor_pos > 0);
      cursor_pos += gb.buttons.repeat(BUTTON_DOWN, ARROW_DELAY) * (cursor_pos < options_number-1);
      if(gb.buttons.repeat(BUTTON_B, BUTTON_DELAY)){ return M_CANCEL; }
    }
  }while(!gb.buttons.repeat(BUTTON_A, BUTTON_DELAY));
  return cursor_pos;
}

word menu(const byte data[], byte size){
  gb.display.setColor(BLACK);
  gb.display.fillRect((int) data[0], (int) data[1], (int) data[2], (int) data[3]);
  gb.display.setColor(WHITE);
  gb.display.fillRect((int) data[0]+1, (int) data[1]+1, (int) data[2]-2, (int)data[3]-2);
  gb.display.setColor(BLACK);
  for (byte i = 4; i < size; i++) {
    gb.display.setCursor(data[0]+6, data[1]+2+6*(i-4));
    gb.display.print(menu_strings[data[i]]);
  }
  byte option = handle_vertical_cursor(size-4, data[0]+2, data[1]+2);
  if(option == M_CANCEL) return option;
  return data[4+option];
}

byte script(byte script_id) {
  switch (script_id) {
    case S_PHONE :
      if(!flag[F_PICOBALL]){
        text(str_phone);
        break;
      }
      text(str_no_messages);
      break;
    case S_PICOBALL :
      flag[F_PICOBALL] = 1;
      add_picomon(SWOOTY, 2, calc_stat(SWOOTY, 2, HP), 0, MO_TACKLE, MO_LEER, NO_MOVE, NO_MOVE);
      text(str_starter);
      break;
    case S_LEAVE_HOUSE :
      if(!flag[F_PICOBALL]){
        text(str_take_picoball);
        break;
      }
      player_x = 12;
      player_y = 7;
      update_camera();
      break;
  }
}

void add_picomon(byte id, byte lvl, unsigned short hp, unsigned short xp, byte move_1, byte move_2, byte move_3, byte move_4){
  for(byte i = 0 ; i < sizeof(player_picomons) ; i += PLAYER_PICOMONS_LENGTH){
    if(player_picomons[i+ID] == MISSING_NO){
      player_picomons[i+ID] = (unsigned short) id;
      player_picomons[i+LVL] = (unsigned short) lvl;
      player_picomons[i+CUR_HP] = hp;
      player_picomons[i+XP] = xp;
      player_picomons[i+MOVE_1] = (unsigned short) move_1;
      player_picomons[i+MOVE_2] = (unsigned short) move_2;
      player_picomons[i+MOVE_3] = (unsigned short) move_3;
      player_picomons[i+MOVE_4] = (unsigned short) move_4;
      return;
    }
  }
  // pas de places !!
}

unsigned short calc_stat(byte id, byte lvl, byte stat){
  return floor((picomon_stats[id*PICOMON_STATS_LENGTH+stat]*2*lvl/100)+lvl+10);
}

void stats_menu(){
  if(player_picomons[ID] == MISSING_NO) return;
  while(true){
    if(gb.update()){
      byte picomon_count, cursor_pos = 0, prev_pos = 1;
      do{
        if (gb.update()) {
          if (cursor_pos != prev_pos) {
            gb.display.fill(WHITE);
            gb.display.setColor(BLACK);
            gb.display.drawRect(0, 0, 43, 64);
            gb.display.drawRect(37, 37, 43, 27);
            gb.display.setColor(WHITE);
            gb.display.fillRect(38, 38, 41, 25);
            for(picomon_count = 0; picomon_count < sizeof(player_picomons)/2; picomon_count += PLAYER_PICOMONS_LENGTH){
              if(player_picomons[picomon_count+ID] == MISSING_NO) break;
              tile_set.setFrame(picomon_stats[player_picomons[picomon_count+ID]*PICOMON_STATS_LENGTH+SPRITE_ID]);
              gb.display.drawImage(48, 1+picomon_count/PLAYER_PICOMONS_LENGTH*9, tile_set);
              draw_HP_box(57, 4+picomon_count/PLAYER_PICOMONS_LENGTH*9, 22, 4, player_picomons[picomon_count+CUR_HP]/calc_stat(player_picomons[picomon_count+ID], player_picomons[picomon_count+LVL], HP));
            }
            picomon_count = picomon_count/PLAYER_PICOMONS_LENGTH;
            
            gb.display.setColor(WHITE);
            gb.display.drawChar(44, 3 + 6 * (prev_pos), 16, 1);
            gb.display.setColor(BLACK);
            gb.display.drawChar(44, 3 + 6 * (cursor_pos), 16, 1);
            prev_pos = cursor_pos;

            gb.display.setCursor(2, 2);
            gb.display.print(picomon_names[player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+ID]]);
            tile_set.setFrame(TILE_ELEMENT+picomon_stats[player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+ID]*PICOMON_STATS_LENGTH+ELEMENT]);
            gb.display.drawImage(2, 8, tile_set);
            gb.display.setCursor(11, 10);
            gb.display.print(element_names[picomon_stats[player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+ID]*PICOMON_STATS_LENGTH+ELEMENT]]);
            gb.display.setCursor(2, 17);
            gb.display.print("LVL");
            gb.display.setCursor(2, 23);
            gb.display.print("XP");
            gb.display.setCursor(2, 29);
            gb.display.print("HP");
            gb.display.setCursor(2, 35);
            gb.display.print("SPD");
            gb.display.setCursor(2, 41);
            gb.display.print("DEF");
            gb.display.setCursor(2, 47);
            gb.display.print("ATK");
            gb.display.setCursor(26, 23);
            gb.display.print("/");
            gb.display.setCursor(26, 29);
            gb.display.print("/");
            gb.display.setCursor(18, 17);
            gb.display.print(player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+LVL]);
            tmp = player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+XP];
            gb.display.setCursor(14+4*(tmp < 100)+4*(tmp < 10), 23);
            gb.display.print(tmp);
            tmp = pow(player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+LVL]*10, 1.2);
            gb.display.setCursor(30+4*(tmp < 100)+4*(tmp < 10), 23);
            gb.display.print(tmp);
            tmp = player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+CUR_HP];
            gb.display.setCursor(14+4*(tmp < 100)+4*(tmp < 10), 29);
            gb.display.print(tmp);
            tmp = calc_stat(player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+ID], player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+LVL], HP);
            gb.display.setCursor(30+4*(tmp < 100)+4*(tmp < 10), 29);
            gb.display.print(tmp);
            gb.display.setCursor(18, 35);
            gb.display.print(calc_stat(player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+ID], player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+LVL], SPEED));
            gb.display.setCursor(18, 41);
            gb.display.print(calc_stat(player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+ID], player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+LVL], DEFENSE));
            gb.display.setCursor(18, 47);
            gb.display.print(calc_stat(player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+ID], player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+LVL], ATTACK));
            for(byte i = 0; i < 4; i++){
              tmp = player_picomons[(cursor_pos*PLAYER_PICOMONS_LENGTH)+MOVE_1+i];
              if(tmp == NO_MOVE) break;
              gb.display.setCursor(39, 39+i*6);
              gb.display.print(move_names[tmp]);
            }
          }
          cursor_pos -= gb.buttons.repeat(BUTTON_UP, ARROW_DELAY) * (cursor_pos > 0);
          cursor_pos += gb.buttons.repeat(BUTTON_DOWN, ARROW_DELAY) * (cursor_pos < picomon_count-1);
          if(gb.buttons.repeat(BUTTON_B, BUTTON_DELAY)) return;
        }
      }while(!gb.buttons.repeat(BUTTON_A, BUTTON_DELAY));
      delay(50);
      switch(menu(first_release_menu, sizeof(first_release_menu))){
        case M_FIRST:
        case M_RELEASE:
          break;
      }
    }
  }
}

void item_menu(){
  if(player_items[0] == NO_ITEM) return;
  while(true){
    if(gb.update()){
      byte items_count, cursor_pos = 0, prev_pos = 1;
      do{
        if (gb.update()) {
          if (cursor_pos != prev_pos) {
            gb.display.setColor(BLACK);
            gb.display.drawRect(0, 0, 59, 64);
            gb.display.setColor(WHITE);
            gb.display.fillRect(1, 1, 57, 62);
            gb.display.setColor(BLACK);
            for(items_count = 0; items_count < sizeof(player_items); items_count ++){
              if(player_items[items_count] == NO_ITEM) break;
              gb.display.setCursor(7, 2+6*items_count);
              gb.display.print(item_names[player_items[items_count]]);
            }
            gb.display.setColor(WHITE);
            gb.display.drawChar(2, 2 + 6 * (prev_pos), 16, 1);
            gb.display.setColor(BLACK);
            gb.display.drawChar(2, 2 + 6 * (cursor_pos), 16, 1);
            prev_pos = cursor_pos;
          }
          cursor_pos -= gb.buttons.repeat(BUTTON_UP, 1) * (cursor_pos > 0);
          cursor_pos += gb.buttons.repeat(BUTTON_DOWN, 1) * (cursor_pos < items_count-1);
          if(gb.buttons.repeat(BUTTON_B, BUTTON_DELAY)) return;
        }
      }while(!gb.buttons.repeat(BUTTON_A, BUTTON_DELAY));
        delay(50);
        switch(menu(use_drop_menu, sizeof(use_drop_menu))){
          case M_USE:
          case M_DROP:
            break;
        }
    }
  }
}

#define B_FIGHT   1
#define B_MONSTER 2
#define B_ITEM    3
#define B_RUN     4

unsigned short opponent_stats[] = {
  // picomon id, lvl, current hp, xp, move 1 id, move 2 id, move 3 id, move 4 id
  MISSING_NO, 0, 0, 0, NO_MOVE, NO_MOVE, NO_MOVE, NO_MOVE,
};

void battle(const byte zone[], byte size){
  byte escape_tries = 0, move_accuracy = 95, effectiveness, critical;
  opponent_stats[ID] = zone[rand()%size];
  int tmp = player_picomons[LVL] - 3 + rand() % 4;
  if(tmp < 1) tmp = 1;
  if(tmp > 100) tmp = 100;
  opponent_stats[LVL] = tmp;
  opponent_stats[CUR_HP] = calc_stat(opponent_stats[ID], opponent_stats[LVL], HP);

  draw_battle_screen();

  battle_text("A WILD ");
  battle_text(picomon_names[opponent_stats[ID]]);
  battle_text("\nAPPEARS!\p");

  while(true){
    if(gb.update()){
battle_loop:
      draw_battle_screen();
      gb.display.setCursor(23, 51);
      gb.display.print("FIGHT");
      gb.display.setCursor(51, 51);
      gb.display.print("MONSTER");
      gb.display.setCursor(23, 57);
      gb.display.print("ITEM");
      gb.display.setCursor(51, 57);
      gb.display.print("RUN");
      switch(handle_battle_cursor(19, 28, 4, false)){
        case B_FIGHT:
          battle_text_frame();
          gb.display.setCursor(6, 51);
          gb.display.print(move_names[player_picomons[MOVE_1]]);
          tmp = 1;
          if(player_picomons[MOVE_2] != NO_MOVE){
            gb.display.setCursor(45, 51);
            gb.display.print(move_names[player_picomons[MOVE_2]]);
            tmp ++;
          }
          if(player_picomons[MOVE_3] != NO_MOVE){
            gb.display.setCursor(6, 57);
            gb.display.print(move_names[player_picomons[MOVE_3]]);
            tmp ++;
          }
          if(player_picomons[MOVE_4] != NO_MOVE){
            gb.display.setCursor(45, 57);
            gb.display.print(move_names[player_picomons[MOVE_4]]);
            tmp ++;
          }
          delay(50);
          tmp = handle_battle_cursor(2, 39, tmp, true);
          switch(tmp){
            case M_CANCEL:
              goto battle_loop;
            default:
              battle_text_frame();
              if(rand()%101 > move_accuracy){
                battle_text(move_names[tmp]);
                battle_text(" MISSED!\p");
                break;
              }
              effectiveness = calc_effectiveness(picomon_stats[player_picomons[ID]*PICOMON_STATS_LENGTH+ELEMENT], picomon_stats[opponent_stats[ID]*PICOMON_STATS_LENGTH+ELEMENT]);
              
              break;
          }
          break;
        case B_MONSTER:
          stats_menu();
          break;
        case B_ITEM:
          item_menu();
          break;
        case B_RUN:
          battle_text_frame();
          if(rand() % 255 < calc_stat(player_picomons[ID], player_picomons[LVL], SPEED)*32/((calc_stat(opponent_stats[ID], opponent_stats[LVL], SPEED)/4)%256) + escape_tries *30){
            battle_text("YOU RAN AWAY!\p");
            return;
          }else{
            escape_tries ++;
            battle_text("YOU TRY TO RUN\nAWAY... BUT FAIL!\p");
          }
          break;
      }
    }
  }
}

void draw_battle_screen(){
    gb.display.fill(WHITE);
  // draw opponent stuff
  gb.display.drawFastVLine(1, 0, 20);
  gb.display.drawFastHLine(2, 19, 52);
  gb.display.setCursor(3, 1);
  gb.display.print(picomon_names[opponent_stats[ID]]);
  gb.display.setCursor(3, 7);
  gb.display.print(":L");
  gb.display.print(opponent_stats[LVL]);
  gb.display.setCursor(3, 13);
  gb.display.print("HP:");
  draw_HP_box(15, 14, 38, 4, opponent_stats[CUR_HP]/calc_stat(opponent_stats[ID], opponent_stats[LVL], HP));
  tile_set.setFrame(picomon_stats[opponent_stats[ID]*PICOMON_STATS_LENGTH+SPRITE_ID]);
  gb.display.drawImage(55, 1, tile_set, 24, 24);

  gb.display.drawFastVLine(78, 28, 20);
  gb.display.drawFastHLine(26, 47, 52);
  gb.display.setCursor(78-strlen(picomon_names[player_picomons[ID]])*4, 30);
  gb.display.print(picomon_names[player_picomons[ID]]);
  gb.display.setCursor(66-4*(player_picomons[LVL] > 9)-4*(player_picomons[LVL] > 99), 36);
  gb.display.print(":L");
  gb.display.print(player_picomons[LVL]);
  gb.display.setCursor(27, 41);
  gb.display.print("HP:");
  draw_HP_box(39, 42, 38, 4, player_picomons[CUR_HP]/calc_stat(player_picomons[ID], player_picomons[LVL], HP));
  tile_set.setFrame(picomon_stats[player_picomons[ID]*PICOMON_STATS_LENGTH+SPRITE_ID]);
  gb.display.drawImage(1, 24, tile_set, -24, 24);

  battle_text_frame();
}

void draw_HP_box(byte x, byte y, byte w, byte h, byte hp){
  gb.display.setColor((Color)0xf809);
  gb.display.fillRect(x+1, y+1, w*hp-2, h-2);
  gb.display.setColor(BLACK);
  gb.display.drawRect(x, y, w, h);
}

void battle_text_frame(){
  gb.display.setColor(WHITE);
  gb.display.fillRect(1, 50, 78, 13);
  gb.display.setColor(BLACK);
  gb.display.drawRect(0, 49, 80, 15);
  gb.display.setCursor(2, 51);
}

byte battle_text(const char string[]) {
  for (byte i = 0; i < strlen(string); i++) {
    char c = (char) string[i];
    switch ((byte) c) {
      case 10:
        gb.display.setCursor(2, gb.display.getCursorY()+6);
        break;
      case 112:
        text_pause();
        battle_text_frame();
        break;
      default:
        gb.display.print(c);
        gb.update();
        delay(TEXT_SPEED);
    }
  }
}

byte handle_battle_cursor(byte x, byte w, byte options_number, boolean allow_cancel){
  byte cursor_pos = 1, prev_pos = 2;
  do{
    if (gb.update()) {
      if (cursor_pos != prev_pos) {
        gb.display.setColor(WHITE);
        gb.display.drawChar(x + w * !(prev_pos % 2), 51 + 6 * (prev_pos > 2), 16, 1);
        gb.display.setColor(BLACK);
        gb.display.drawChar(x + w * !(cursor_pos % 2), 51 + 6 * (cursor_pos > 2), 16, 1);
        prev_pos = cursor_pos;
      }
      cursor_pos -= 1 * gb.buttons.repeat(BUTTON_LEFT, ARROW_DELAY) * (cursor_pos > 1 & cursor_pos != 3);
      cursor_pos += 1 * gb.buttons.repeat(BUTTON_RIGHT, ARROW_DELAY) * (cursor_pos < 4 & cursor_pos != 2) * (options_number > 1 | (cursor_pos == 3 & options_number > 3));
      cursor_pos -= 2 * gb.buttons.repeat(BUTTON_UP, ARROW_DELAY) * (cursor_pos > 2);
      cursor_pos += 2 * gb.buttons.repeat(BUTTON_DOWN, ARROW_DELAY) * (cursor_pos < 3) * (options_number > 2);
      if(allow_cancel && gb.buttons.repeat(BUTTON_B, BUTTON_DELAY)){ return M_CANCEL; }
    }
  }while(!gb.buttons.repeat(BUTTON_A, BUTTON_DELAY));
  return cursor_pos;
}

byte calc_effectiveness(byte from_element, byte target_element){
  switch(from_element){
    case T_AIR:
      if(target_element == T_WATER) return 2;
    case T_FIRE:
      if(target_element == T_AIR || target_element == T_EARTH) return 2;
    //case T_EARTH:
    case T_WATER:
      if(target_element == T_FIRE) return 2;
    default:
      return 1;
  }
}

byte calc_damage(byte from_attack_id, byte from_lvl, byte from_att, byte target_defense, byte effectiveness){
//  local base = base or 15
//  local dmg = ((2*from.level+10)/250) * (from.attack/target.defense)*base + 2
//  local eff = (effectness[monstats[from.name].element..":"..monstats[target.name].element] or 1)
//  dmg = dmg * eff
//  -- crit
//  local crit
//  if rnd() < from.speed/512 then
//    dmg = dmg * 2
//    crit = true
//  end
//  dmg = dmg * (0.85 + rnd(0.15))
}

